/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OBinaryTypeSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OBooleanSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OByteSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OCharSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.ODateSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.ODateTimeSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.ODecimalSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.ODoubleSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OFloatSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OIntegerSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLongSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.ONullSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OShortSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OStringSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OCompositeKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.index.OSimpleKeySerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializerRID;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OBinarySerializerFactory {
    private final Map<Byte, OBinarySerializer<?>> serializerIdMap = new HashMap();
    private final Map<Byte, Class<? extends OBinarySerializer<?>>> serializerClassesIdMap = new HashMap();
    private final Map<OType, OBinarySerializer<?>> serializerTypeMap = new HashMap();
    public static final OBinarySerializerFactory INSTANCE = new OBinarySerializerFactory();
    public static final int TYPE_IDENTIFIER_SIZE = 1;

    private OBinarySerializerFactory() {
        this.registerSerializer(new ONullSerializer(), null);
        this.registerSerializer(OBooleanSerializer.INSTANCE, OType.BOOLEAN);
        this.registerSerializer(OIntegerSerializer.INSTANCE, OType.INTEGER);
        this.registerSerializer(OShortSerializer.INSTANCE, OType.SHORT);
        this.registerSerializer(OLongSerializer.INSTANCE, OType.LONG);
        this.registerSerializer(OFloatSerializer.INSTANCE, OType.FLOAT);
        this.registerSerializer(ODoubleSerializer.INSTANCE, OType.DOUBLE);
        this.registerSerializer(ODateTimeSerializer.INSTANCE, OType.DATETIME);
        this.registerSerializer(OCharSerializer.INSTANCE, null);
        this.registerSerializer(OStringSerializer.INSTANCE, OType.STRING);
        this.registerSerializer(OByteSerializer.INSTANCE, OType.BYTE);
        this.registerSerializer(ODateSerializer.INSTANCE, OType.DATE);
        this.registerSerializer(OLinkSerializer.INSTANCE, OType.LINK);
        this.registerSerializer(OCompositeKeySerializer.INSTANCE, null);
        this.registerSerializer(OStreamSerializerRID.INSTANCE, null);
        this.registerSerializer(OBinaryTypeSerializer.INSTANCE, OType.BINARY);
        this.registerSerializer(ODecimalSerializer.INSTANCE, OType.DECIMAL);
        this.registerSerializer((byte)15, OSimpleKeySerializer.class);
    }

    public void registerSerializer(OBinarySerializer<?> iInstance, OType iType) {
        this.serializerIdMap.put(iInstance.getId(), iInstance);
        if (iType != null) {
            this.serializerTypeMap.put(iType, iInstance);
        }
    }

    public void registerSerializer(byte iId, Class<? extends OBinarySerializer> iClass) {
        this.serializerClassesIdMap.put(iId, iClass);
    }

    public OBinarySerializer<?> getObjectSerializer(byte identifier) {
        Class<OBinarySerializer<?>> cls;
        OBinarySerializer<?> impl = this.serializerIdMap.get(identifier);
        if (impl == null && (cls = this.serializerClassesIdMap.get(identifier)) != null) {
            try {
                impl = cls.newInstance();
            }
            catch (Exception e) {
                OLogManager.instance().error((Object)this, "Cannot create an instance of class %s invoking the empty constructor", new Object[]{cls});
            }
        }
        return impl;
    }

    public OBinarySerializer<?> getObjectSerializer(OType type) {
        return this.serializerTypeMap.get((Object)type);
    }
}

