/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.ODateTimeSerializer;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODateSerializer
implements OBinarySerializer<Date> {
    public static ODateSerializer INSTANCE = new ODateSerializer();
    public static final byte ID = 4;

    @Override
    public int getObjectSize(Date object) {
        return 8;
    }

    @Override
    public void serialize(Date object, byte[] stream, int startPosition) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        dateTimeSerializer.serialize(calendar.getTime(), stream, startPosition);
    }

    @Override
    public Date deserialize(byte[] stream, int startPosition) {
        ODateTimeSerializer dateTimeSerializer = ODateTimeSerializer.INSTANCE;
        return dateTimeSerializer.deserialize(stream, startPosition);
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 4;
    }
}

