/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLongSerializer;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODateTimeSerializer
implements OBinarySerializer<Date> {
    public static ODateTimeSerializer INSTANCE = new ODateTimeSerializer();
    public static final byte ID = 5;

    @Override
    public int getObjectSize(Date object) {
        return 8;
    }

    @Override
    public void serialize(Date object, byte[] stream, int startPosition) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(object);
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        longSerializer.serialize(calendar.getTimeInMillis(), stream, startPosition);
    }

    @Override
    public Date deserialize(byte[] stream, int startPosition) {
        Calendar calendar = Calendar.getInstance();
        OLongSerializer longSerializer = OLongSerializer.INSTANCE;
        calendar.setTimeInMillis(longSerializer.deserialize(stream, startPosition));
        return calendar.getTime();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 5;
    }
}

