/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OBinaryTypeSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OIntegerSerializer;
import java.math.BigDecimal;
import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODecimalSerializer
implements OBinarySerializer<BigDecimal> {
    public static final ODecimalSerializer INSTANCE = new ODecimalSerializer();
    public static final byte ID = 18;

    @Override
    public int getObjectSize(BigDecimal object) {
        return 4 + OBinaryTypeSerializer.INSTANCE.getObjectSize(object.unscaledValue().toByteArray());
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        int size = 4 + OBinaryTypeSerializer.INSTANCE.getObjectSize(stream, startPosition + 4);
        return size;
    }

    @Override
    public void serialize(BigDecimal object, byte[] stream, int startPosition) {
        OIntegerSerializer.INSTANCE.serialize(object.scale(), stream, startPosition);
        OBinaryTypeSerializer.INSTANCE.serialize(object.unscaledValue().toByteArray(), stream, startPosition += 4);
    }

    @Override
    public BigDecimal deserialize(byte[] stream, int startPosition) {
        int scale = OIntegerSerializer.INSTANCE.deserialize(stream, startPosition);
        byte[] unscaledValue = OBinaryTypeSerializer.INSTANCE.deserialize(stream, startPosition += 4);
        return new BigDecimal(new BigInteger(unscaledValue), scale);
    }

    @Override
    public byte getId() {
        return 18;
    }
}

