/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODoubleSerializer
implements OBinarySerializer<Double> {
    public static ODoubleSerializer INSTANCE = new ODoubleSerializer();
    public static final byte ID = 6;
    public static final int DOUBLE_SIZE = 8;

    @Override
    public int getObjectSize(Double object) {
        return 8;
    }

    @Override
    public void serialize(Double object, byte[] stream, int startPosition) {
        OBinaryProtocol.long2bytes(Double.doubleToLongBits(object), stream, startPosition);
    }

    @Override
    public Double deserialize(byte[] stream, int startPosition) {
        return Double.longBitsToDouble(OBinaryProtocol.bytes2long(stream, startPosition));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return 8;
    }

    @Override
    public byte getId() {
        return 6;
    }
}

