/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl;

import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OCharSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStringSerializer
implements OBinarySerializer<String> {
    public static OStringSerializer INSTANCE = new OStringSerializer();
    public static final byte ID = 13;

    @Override
    public int getObjectSize(String object) {
        return object.length() * 2 + 4;
    }

    @Override
    public void serialize(String object, byte[] stream, int startPosition) {
        OCharSerializer charSerializer = new OCharSerializer();
        int length = object.length();
        OBinaryProtocol.int2bytes(length, stream, startPosition);
        int i = 0;
        while (i < length) {
            charSerializer.serialize(Character.valueOf(object.charAt(i)), stream, startPosition + 4 + i * 2);
            ++i;
        }
    }

    @Override
    public String deserialize(byte[] stream, int startPosition) {
        OCharSerializer charSerializer = new OCharSerializer();
        int len = OBinaryProtocol.bytes2int(stream, startPosition);
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < len) {
            stringBuilder.append(charSerializer.deserialize(stream, startPosition + 4 + i * 2));
            ++i;
        }
        return stringBuilder.toString();
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        return OBinaryProtocol.bytes2int(stream, startPosition) * 2 + 4;
    }

    @Override
    public byte getId() {
        return 13;
    }
}

