/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.binary.impl.index;

import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSimpleKeySerializer<T extends Comparable<?>>
implements OBinarySerializer<T> {
    private OType type;
    private OBinarySerializer binarySerializer;
    public static final byte ID = 15;
    public static final String NAME = "bsks";

    public OSimpleKeySerializer() {
    }

    public OSimpleKeySerializer(OType iType) {
        this.type = iType;
        this.binarySerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(this.type);
    }

    @Override
    public int getObjectSize(T key) {
        this.init(key);
        return 1 + this.binarySerializer.getObjectSize(key);
    }

    @Override
    public void serialize(T key, byte[] stream, int startPosition) {
        this.init(key);
        stream[startPosition] = this.binarySerializer.getId();
        this.binarySerializer.serialize(key, stream, ++startPosition);
        startPosition += this.binarySerializer.getObjectSize(key);
    }

    @Override
    public T deserialize(byte[] stream, int startPosition) {
        byte typeId = stream[startPosition];
        this.init(typeId);
        return (T)((Comparable)this.binarySerializer.deserialize(stream, ++startPosition));
    }

    @Override
    public int getObjectSize(byte[] stream, int startPosition) {
        byte serializerId = stream[startPosition];
        this.init(serializerId);
        return 1 + this.binarySerializer.getObjectSize(stream, startPosition + 1);
    }

    @Override
    public byte getId() {
        return 15;
    }

    protected void init(T key) {
        if (this.binarySerializer == null) {
            this.type = OType.getTypeByClass(key.getClass());
            this.binarySerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(this.type);
        }
    }

    protected void init(byte serializerId) {
        if (this.binarySerializer == null) {
            this.binarySerializer = OBinarySerializerFactory.INSTANCE.getObjectSerializer(serializerId);
        }
    }
}

