/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.record.string;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.OUserObject2RecordHandler;
import com.orientechnologies.orient.core.db.object.ODatabaseObject;
import com.orientechnologies.orient.core.db.record.ORecordLazyMultiValue;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerCSVAbstract;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ORecordSerializerSchemaAware2CSV
extends ORecordSerializerCSVAbstract {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "ORecordDocument2csv";
    public static final ORecordSerializerSchemaAware2CSV INSTANCE = new ORecordSerializerSchemaAware2CSV();

    @Override
    public ORecordSchemaAware<?> newObject(String iClassName) {
        return new ODocument(iClassName);
    }

    public String toString() {
        return NAME;
    }

    @Override
    protected StringBuilder toString(ORecordInternal<?> iRecord, StringBuilder iOutput, String iFormat, OUserObject2RecordHandler iObjHandler, Set<Integer> iMarshalledRecords, boolean iOnlyDelta) {
        String[] fieldNames;
        if (!(iRecord instanceof ODocument)) {
            throw new OSerializationException("Cannot marshall a record of type " + iRecord.getClass().getSimpleName() + " to CSV");
        }
        ODocument record = (ODocument)iRecord;
        Integer identityRecord = System.identityHashCode(record);
        if (iMarshalledRecords != null) {
            if (iMarshalledRecords.contains(identityRecord)) {
                return iOutput;
            }
            iMarshalledRecords.add(identityRecord);
        }
        if (!iOnlyDelta && record.getSchemaClass() != null) {
            iOutput.append(record.getSchemaClass().getStreamableName());
            iOutput.append("@");
        }
        int i = 0;
        String[] stringArray = fieldNames = iOnlyDelta && record.isTrackingChanges() ? record.getDirtyFields() : record.fieldNames();
        if (iObjHandler == null && ODatabaseRecordThreadLocal.INSTANCE.isDefined()) {
            iObjHandler = ODatabaseRecordThreadLocal.INSTANCE.get();
        }
        String[] stringArray2 = fieldNames;
        int n = fieldNames.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray2[n2];
            Object fieldValue = record.rawField(fieldName);
            if (i > 0) {
                iOutput.append(',');
            }
            OProperty prop = record.getSchemaClass() != null ? record.getSchemaClass().getProperty(fieldName) : null;
            String fieldClassName = this.getClassName(fieldValue);
            OType type = record.fieldType(fieldName);
            OClass linkedClass = null;
            OType linkedType = null;
            if (prop != null) {
                type = prop.getType();
                linkedClass = prop.getLinkedClass();
                linkedType = prop.getLinkedType();
            } else if (fieldValue != null) {
                if (type == null) {
                    if (fieldValue.getClass() == byte[].class) {
                        type = OType.BINARY;
                    } else if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && fieldValue instanceof ORecord) {
                        if (type == null) {
                            type = fieldValue instanceof ODocument && ((ODocument)fieldValue).hasOwners() ? OType.EMBEDDED : OType.LINK;
                        }
                        linkedClass = this.getLinkInfo(ODatabaseRecordThreadLocal.INSTANCE.get(), fieldClassName);
                    } else if (fieldValue instanceof ORID) {
                        type = OType.LINK;
                    } else if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner() instanceof ODatabaseObject && ((ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner()).getEntityManager().getEntityClass(fieldClassName) != null) {
                        type = OType.LINK;
                        linkedClass = this.getLinkInfo(ODatabaseRecordThreadLocal.INSTANCE.get(), fieldClassName);
                    } else if (fieldValue instanceof Date) {
                        type = OType.DATETIME;
                    } else if (fieldValue instanceof String) {
                        type = OType.STRING;
                    } else if (fieldValue instanceof Integer || fieldValue instanceof BigInteger) {
                        type = OType.INTEGER;
                    } else if (fieldValue instanceof Long) {
                        type = OType.LONG;
                    } else if (fieldValue instanceof Float) {
                        type = OType.FLOAT;
                    } else if (fieldValue instanceof Short) {
                        type = OType.SHORT;
                    } else if (fieldValue instanceof Byte) {
                        type = OType.BYTE;
                    } else if (fieldValue instanceof Double) {
                        type = OType.DOUBLE;
                    } else if (fieldValue instanceof BigDecimal) {
                        type = OType.DECIMAL;
                    }
                }
                if (fieldValue instanceof Collection || fieldValue.getClass().isArray()) {
                    int size = OMultiValue.getSize(fieldValue);
                    Boolean autoConvertLinks = null;
                    if (fieldValue instanceof ORecordLazyMultiValue && (autoConvertLinks = Boolean.valueOf(((ORecordLazyMultiValue)fieldValue).isAutoConvertToRecord())).booleanValue()) {
                        ((ORecordLazyMultiValue)fieldValue).setAutoConvertToRecord(false);
                    }
                    if (size > 0) {
                        Object firstValue = OMultiValue.getFirstValue(fieldValue);
                        if (firstValue != null) {
                            if (firstValue instanceof ORID) {
                                linkedClass = null;
                                linkedType = OType.LINK;
                                type = fieldValue instanceof Set ? OType.LINKSET : OType.LINKLIST;
                            } else if (ODatabaseRecordThreadLocal.INSTANCE.isDefined() && firstValue instanceof ODocument && !((ODocument)firstValue).isEmbedded() && (firstValue instanceof ORecord || ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner() instanceof ODatabaseObject && ((ODatabaseObject)ODatabaseRecordThreadLocal.INSTANCE.get().getDatabaseOwner()).getEntityManager().getEntityClass(this.getClassName(firstValue)) != null)) {
                                linkedClass = this.getLinkInfo(ODatabaseRecordThreadLocal.INSTANCE.get(), this.getClassName(firstValue));
                                if (type == null) {
                                    linkedType = OType.LINK;
                                    type = fieldValue instanceof Set ? OType.LINKSET : OType.LINKLIST;
                                } else {
                                    linkedType = OType.EMBEDDED;
                                }
                            } else {
                                if (firstValue instanceof ODocument && (((ODocument)firstValue).hasOwners() || type == OType.EMBEDDEDSET || type == OType.EMBEDDEDLIST || type == OType.EMBEDDEDMAP)) {
                                    linkedType = OType.EMBEDDED;
                                } else if (firstValue instanceof Enum) {
                                    linkedType = OType.STRING;
                                } else {
                                    linkedType = OType.getTypeByClass(firstValue.getClass());
                                    if (linkedType != OType.LINK && linkedType == null) {
                                        linkedType = OType.EMBEDDED;
                                    }
                                }
                                if (type == null) {
                                    type = fieldValue instanceof Set ? OType.EMBEDDEDSET : OType.EMBEDDEDLIST;
                                }
                            }
                        }
                    } else if (type == null) {
                        type = OType.EMBEDDEDLIST;
                    }
                    if (fieldValue instanceof ORecordLazyMultiValue && autoConvertLinks.booleanValue()) {
                        ((ORecordLazyMultiValue)fieldValue).setAutoConvertToRecord(true);
                    }
                } else if (fieldValue instanceof Map && type == null) {
                    type = OType.EMBEDDEDMAP;
                }
            }
            if (type != OType.TRANSIENT) {
                if (type == null) {
                    type = OType.EMBEDDED;
                }
                iOutput.append(fieldName);
                iOutput.append(':');
                this.fieldToStream((ODocument)iRecord, iOutput, iObjHandler, type, linkedClass, linkedType, fieldName, fieldValue, iMarshalledRecords, true);
                ++i;
            }
            ++n2;
        }
        if (iMarshalledRecords != null) {
            iMarshalledRecords.remove(identityRecord);
        }
        float overSize = record.getSchemaClass() != null ? record.getSchemaClass().getOverSize() : 0.0f;
        int newSize = record.hasOwners() ? iOutput.length() : (record.getSize() == iOutput.length() ? record.getSize() : (record.getSize() > iOutput.length() ? record.getSize() : (overSize > 0.0f ? (int)((float)iOutput.length() * overSize) : iOutput.length())));
        if (newSize > iOutput.length()) {
            int b = iOutput.length();
            while (b < newSize) {
                iOutput.append(' ');
                ++b;
            }
        }
        return iOutput;
    }

    private String getClassName(Object iValue) {
        if (iValue instanceof ORecordSchemaAware) {
            return ((ORecordSchemaAware)iValue).getClassName();
        }
        return iValue != null ? iValue.getClass().getSimpleName() : null;
    }

    private OClass getLinkInfo(ODatabaseComplex<?> iDatabase, String iFieldClassName) {
        OClass linkedClass = iDatabase.getMetadata().getSchema().getClass(iFieldClassName);
        if (iDatabase.getDatabaseOwner() instanceof ODatabaseObject) {
            Class<?> entityClass;
            ODatabaseObject dbo = (ODatabaseObject)iDatabase.getDatabaseOwner();
            if (linkedClass == null && (entityClass = dbo.getEntityManager().getEntityClass(iFieldClassName)) != null) {
                linkedClass = iDatabase.getMetadata().getSchema().createClass(iFieldClassName);
            }
        }
        return linkedClass;
    }

    @Override
    public ORecordInternal<?> fromString(String iContent, ORecordInternal<?> iRecord) {
        if ((iContent = iContent.trim()).length() == 0) {
            return iRecord;
        }
        ODocument record = (ODocument)iRecord;
        int posFirstValue = iContent.indexOf(58);
        int pos = iContent.indexOf("@");
        if (pos > -1 && (pos < posFirstValue || posFirstValue == -1)) {
            record.setClassNameIfExists(iContent.substring(0, pos));
            iContent = iContent.substring(pos + 1);
        } else {
            record.setClassNameIfExists(null);
        }
        List<String> fields = OStringSerializerHelper.smartSplit(iContent, ',', new char[0]);
        String fieldName = null;
        OType type = null;
        int i = 0;
        while (i < fields.size()) {
            String field = fields.get(i).trim();
            boolean uncertainType = false;
            try {
                pos = field.indexOf(58);
                if (pos > -1) {
                    OType linkedType;
                    OClass linkedClass;
                    OProperty prop;
                    fieldName = field.substring(0, pos);
                    String fieldValue = field.length() > pos + 1 ? field.substring(pos + 1) : null;
                    OProperty oProperty = prop = record.getSchemaClass() != null ? record.getSchemaClass().getProperty(fieldName) : null;
                    if (prop != null) {
                        type = prop.getType();
                        linkedClass = prop.getLinkedClass();
                        linkedType = prop.getLinkedType();
                    } else {
                        type = record.fieldType(fieldName);
                        linkedClass = null;
                        linkedType = null;
                        if (fieldValue != null && type == null) {
                            if (fieldValue.length() > 1 && fieldValue.charAt(0) == '\"' && fieldValue.charAt(fieldValue.length() - 1) == '\"') {
                                type = OType.STRING;
                            } else if (fieldValue.charAt(0) == '[' && fieldValue.charAt(fieldValue.length() - 1) == ']') {
                                type = OType.EMBEDDEDLIST;
                                String value = fieldValue.substring(1, fieldValue.length() - 1);
                                if (!value.isEmpty()) {
                                    if (value.charAt(0) == '#') {
                                        String className;
                                        type = OType.LINKLIST;
                                        linkedType = OType.LINK;
                                        int classSeparatorPos = value.indexOf("@");
                                        if (classSeparatorPos > -1 && (className = value.substring(1, classSeparatorPos)) != null) {
                                            linkedClass = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(className);
                                        }
                                    } else if (value.charAt(0) == '(') {
                                        linkedType = OType.EMBEDDED;
                                    } else if (value.charAt(0) == '^') {
                                        linkedType = OType.CUSTOM;
                                    } else if (Character.isDigit(value.charAt(0)) || value.charAt(0) == '+' || value.charAt(0) == '-') {
                                        String[] items = value.split(",");
                                        linkedType = ORecordSerializerSchemaAware2CSV.getType(items[0]);
                                    } else if (value.charAt(0) == '\'' || value.charAt(0) == '\"') {
                                        linkedType = OType.STRING;
                                    }
                                } else {
                                    uncertainType = true;
                                }
                            } else {
                                type = fieldValue.charAt(0) == '{' && fieldValue.charAt(fieldValue.length() - 1) == '}' ? OType.EMBEDDEDMAP : (fieldValue.charAt(0) == '#' ? OType.LINK : (fieldValue.charAt(0) == '(' ? (fieldValue.startsWith("(ORIDs") ? OType.LINKSET : OType.EMBEDDED) : (fieldValue.equals("true") || fieldValue.equals("false") ? OType.BOOLEAN : ORecordSerializerSchemaAware2CSV.getType(fieldValue))));
                            }
                        }
                    }
                    if (type == OType.EMBEDDEDLIST || type == OType.EMBEDDEDSET || type == OType.EMBEDDEDMAP || type == OType.EMBEDDED) {
                        record.field(fieldName, this.fieldFromStream(iRecord, type, linkedClass, linkedType, fieldName, fieldValue), type);
                    } else {
                        record.field(fieldName, this.fieldFromStream(iRecord, type, linkedClass, linkedType, fieldName, fieldValue));
                    }
                    if (uncertainType) {
                        record.setFieldType(fieldName, null);
                    }
                }
            }
            catch (Exception e) {
                OLogManager.instance().exception("Error on unmarshalling field '%s' with value: ", e, OSerializationException.class, fieldName, field);
            }
            ++i;
        }
        return iRecord;
    }
}

