/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.serialization.serializer.stream;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class OStreamSerializerAnyRuntime
implements OStreamSerializer {
    private static final String NAME = "au";
    public static final OStreamSerializerAnyRuntime INSTANCE = new OStreamSerializerAnyRuntime();

    public String getName() {
        return NAME;
    }

    public Object fromStream(byte[] iStream) throws IOException {
        if (iStream == null || iStream.length == 0) {
            return null;
        }
        ByteArrayInputStream is = new ByteArrayInputStream(iStream);
        ObjectInputStream in = new ObjectInputStream(is);
        try {
            Object object = in.readObject();
            return object;
        }
        catch (ClassNotFoundException e) {
            throw new OSerializationException("Cannot unmarshall Java serialized object", e);
        }
        finally {
            in.close();
            is.close();
        }
    }

    public byte[] toStream(Object iObject) throws IOException {
        if (iObject == null) {
            return new byte[0];
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(os);
        oos.writeObject(iObject);
        oos.close();
        return os.toByteArray();
    }
}

