/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.index.ORuntimeKeyIndexDefinition;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLCreateIndex
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_CREATE = "CREATE";
    public static final String KEYWORD_INDEX = "INDEX";
    public static final String KEYWORD_ON = "ON";
    private String indexName;
    private OClass oClass;
    private String[] fields;
    private OClass.INDEX_TYPE indexType;
    private OType[] keyTypes;
    private byte serializerKeyId;

    public OCommandExecutorSQLCreateIndex parse(OCommandRequest iRequest) {
        int n;
        OCommandExecutorSQLCreateIndex.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_CREATE)) {
            throw new OCommandSQLParsingException("Keyword CREATE not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_INDEX)) {
            throw new OCommandSQLParsingException("Keyword INDEX not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected index name. Use " + this.getSyntax(), this.text, oldPos);
        }
        this.indexName = word.toString();
        int namePos = oldPos;
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
            throw new OCommandSQLParsingException("Index type requested. Use " + this.getSyntax(), this.text, oldPos + 1);
        }
        if (word.toString().equals(KEYWORD_ON)) {
            if (this.indexName.contains(".")) {
                throw new OCommandSQLParsingException("Index name cannot contain '.' character. Use " + this.getSyntax(), this.text, namePos);
            }
            oldPos = pos;
            if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1) {
                throw new OCommandSQLParsingException("Expected class name. Use " + this.getSyntax(), this.text, oldPos);
            }
            oldPos = pos;
            this.oClass = this.findClass(word.toString());
            if (this.oClass == null) {
                throw new OCommandExecutionException("Class " + word + " not found");
            }
            pos = this.textUpperCase.indexOf(")");
            if (pos == -1) {
                throw new OCommandSQLParsingException("No right bracket found. Use " + this.getSyntax(), this.text, oldPos);
            }
            String props = this.textUpperCase.substring(oldPos, pos).trim().substring(1);
            ArrayList<String> propList = new ArrayList<String>();
            ArrayList<OType> typeList = new ArrayList<OType>();
            String[] stringArray = props.trim().split("\\s*,\\s*");
            int n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String propToIndex = stringArray[n];
                this.checkMapIndexSpecifier(propToIndex, this.text, oldPos);
                String propName = propToIndex.split("\\s+")[0];
                OProperty property = this.oClass.getProperty(propName);
                if (property == null) {
                    throw new IllegalArgumentException("Property '" + propToIndex + "' was not found in class '" + this.oClass.getName() + "'");
                }
                propList.add(propToIndex);
                typeList.add(property.getType());
                ++n;
            }
            this.fields = new String[propList.size()];
            propList.toArray(this.fields);
            oldPos = pos + 1;
            pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
            if (pos == -1) {
                throw new OCommandSQLParsingException("Index type requested. Use " + this.getSyntax(), this.text, oldPos + 1);
            }
            this.keyTypes = new OType[propList.size()];
            typeList.toArray(this.keyTypes);
        } else if (this.indexName.indexOf(46) > 0) {
            String[] parts = this.indexName.split("\\.");
            this.oClass = this.findClass(parts[0]);
            if (this.oClass == null) {
                throw new OCommandExecutionException("Class " + parts[0] + " not found");
            }
            OProperty prop = this.oClass.getProperty(parts[1]);
            if (prop == null) {
                throw new IllegalArgumentException("Property '" + parts[1] + "' was not found in class '" + this.oClass.getName() + "'");
            }
            this.fields = new String[]{prop.getName()};
            this.keyTypes = new OType[]{prop.getType()};
        }
        this.indexType = OClass.INDEX_TYPE.valueOf(word.toString());
        if (this.indexType == null) {
            throw new OCommandSQLParsingException("Index type is null", this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) != -1 && !word.toString().equalsIgnoreCase("NULL")) {
            String typesString = this.textUpperCase.substring(oldPos).trim();
            if (word.toString().equalsIgnoreCase("RUNTIME")) {
                oldPos = pos;
                pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
                this.serializerKeyId = Byte.parseByte(word.toString());
            } else {
                ArrayList<OType> keyTypeList = new ArrayList<OType>();
                String[] stringArray = typesString.split("\\s*,\\s*");
                n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String typeName = stringArray[n3];
                    keyTypeList.add(OType.valueOf(typeName));
                    ++n3;
                }
                OType[] parsedKeyTypes = new OType[keyTypeList.size()];
                keyTypeList.toArray(parsedKeyTypes);
                if (this.keyTypes == null) {
                    this.keyTypes = parsedKeyTypes;
                } else if (!Arrays.deepEquals((Object[])this.keyTypes, (Object[])parsedKeyTypes)) {
                    throw new OCommandSQLParsingException("Property type list not match with real property types", this.text, oldPos);
                }
            }
        }
        return this;
    }

    private OClass findClass(String part) {
        return OCommandExecutorSQLCreateIndex.getDatabase().getMetadata().getSchema().getClass(part);
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.indexName == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLCreateIndex.getDatabase();
        OIndex<?> idx = this.fields == null || this.fields.length == 0 ? (this.keyTypes != null ? database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), new OSimpleKeyIndexDefinition(this.keyTypes), null, null) : (this.serializerKeyId != 0 ? database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), new ORuntimeKeyIndexDefinition(this.serializerKeyId), null, null) : database.getMetadata().getIndexManager().createIndex(this.indexName, this.indexType.toString(), null, null, null))) : this.oClass.createIndex(this.indexName, this.indexType, this.fields);
        if (idx != null) {
            return idx.getSize();
        }
        return null;
    }

    private void checkMapIndexSpecifier(String fieldName, String text, int pos) {
        String[] fieldNameParts = fieldName.split("\\s+");
        if (fieldNameParts.length == 1) {
            return;
        }
        if (fieldNameParts.length == 3) {
            if ("by".equals(fieldNameParts[1].toLowerCase())) {
                try {
                    OPropertyMapIndexDefinition.INDEX_BY.valueOf(fieldNameParts[2].toUpperCase());
                }
                catch (IllegalArgumentException iae) {
                    throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
                }
                return;
            }
            throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
        }
        throw new OCommandSQLParsingException("Illegal field name format, should be '<property> [by key|value]' but was '" + fieldName + "'", text, pos);
    }

    @Override
    public String getSyntax() {
        return "CREATE INDEX <name> [ON <class-name> (prop-names)] <type> [<key-type>]";
    }
}

