/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchemaProxy;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLDropClass
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_DROP = "DROP";
    public static final String KEYWORD_CLASS = "CLASS";
    private String className;

    public OCommandExecutorSQLDropClass parse(OCommandRequest iRequest) {
        OCommandExecutorSQLDropClass.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_DROP)) {
            throw new OCommandSQLParsingException("Keyword DROP not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, true)) == -1 || !word.toString().equals(KEYWORD_CLASS)) {
            throw new OCommandSQLParsingException("Keyword CLASS not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, pos, word, false)) == -1) {
            throw new OCommandSQLParsingException("Expected <class>. Use " + this.getSyntax(), this.text, pos);
        }
        this.className = word.toString();
        if (this.className == null) {
            throw new OCommandSQLParsingException("Class is null. Use " + this.getSyntax(), this.text, pos);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.className == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        ODatabaseRecord database = OCommandExecutorSQLDropClass.getDatabase();
        OClass oClass = database.getMetadata().getSchema().getClass(this.className);
        if (oClass == null) {
            return null;
        }
        for (OIndex<?> oIndex : oClass.getClassIndexes()) {
            database.getMetadata().getIndexManager().dropIndex(oIndex.getName());
        }
        OClass superClass = oClass.getSuperClass();
        int[] clustersToIndex = oClass.getPolymorphicClusterIds();
        String[] clusterNames = new String[clustersToIndex.length];
        int i = 0;
        while (i < clustersToIndex.length) {
            clusterNames[i] = database.getClusterNameById(clustersToIndex[i]);
            ++i;
        }
        int clusterId = oClass.getDefaultClusterId();
        ((OSchemaProxy)database.getMetadata().getSchema()).dropClassInternal(this.className);
        ((OSchemaProxy)database.getMetadata().getSchema()).saveInternal();
        database.getMetadata().getSchema().reload();
        this.deleteDefaultCluster(clusterId);
        if (superClass == null) {
            return true;
        }
        for (OIndex<?> oIndex : superClass.getIndexes()) {
            String[] stringArray = clusterNames;
            int n = clusterNames.length;
            int n2 = 0;
            while (n2 < n) {
                String clusterName = stringArray[n2];
                oIndex.getInternal().removeCluster(clusterName);
                ++n2;
            }
            OLogManager.instance().info((Object)"Index %s is used in super class of %s and should be rebuilt.", oIndex.getName(), this.className);
            oIndex.rebuild();
        }
        return true;
    }

    protected void deleteDefaultCluster(int clusterId) {
        ODatabaseRecord database = OCommandExecutorSQLDropClass.getDatabase();
        OCluster cluster = database.getStorage().getClusterById(clusterId);
        if (cluster.getName().equalsIgnoreCase(this.className) && this.isClusterDeletable(clusterId)) {
            database.getStorage().dropCluster(clusterId);
        }
    }

    protected boolean isClusterDeletable(int clusterId) {
        ODatabaseRecord database = OCommandExecutorSQLDropClass.getDatabase();
        for (OClass iClass : database.getMetadata().getSchema().getClasses()) {
            int[] nArray = iClass.getClusterIds();
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int i = nArray[n2];
                if (i == clusterId) {
                    return false;
                }
                ++n2;
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "DROP CLASS <class>";
    }
}

