/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OFindReferenceHelper;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLFindReferences
extends OCommandExecutorSQLAbstract {
    public static final String KEYWORD_FIND = "FIND";
    public static final String KEYWORD_REFERENCES = "REFERENCES";
    private Set<ORID> recordIds = new HashSet<ORID>();
    private String classList;
    private StringBuilder subQuery;

    public OCommandExecutorSQLFindReferences parse(OCommandRequest iRequest) {
        OCommandExecutorSQLFindReferences.getDatabase().checkSecurity("database.command", ORole.PERMISSION_READ);
        this.init(((OCommandRequestText)iRequest).getText());
        StringBuilder word = new StringBuilder();
        int oldPos = 0;
        int pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos == -1 || !word.toString().equals(KEYWORD_FIND)) {
            throw new OCommandSQLParsingException("Keyword FIND not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if ((pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true)) == -1 || !word.toString().equals(KEYWORD_REFERENCES)) {
            throw new OCommandSQLParsingException("Keyword REFERENCES not found. Use " + this.getSyntax(), this.text, oldPos);
        }
        if ((pos = OStringParser.jumpWhiteSpaces(this.text, pos)) == -1) {
            throw new OCommandSQLParsingException("Expected <target>. Use " + this.getSyntax(), this.text, oldPos);
        }
        oldPos = pos;
        if (this.text.charAt(pos) == '(') {
            this.subQuery = new StringBuilder();
            pos = OStringSerializerHelper.getEmbedded(this.text, oldPos, -1, this.subQuery);
        } else {
            pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, false);
            if (pos == -1) {
                throw new OCommandSQLParsingException("Expected <recordId>. Use " + this.getSyntax(), this.text, oldPos);
            }
            String recordIdString = word.toString();
            if (recordIdString == null || recordIdString.equals("")) {
                throw new OCommandSQLParsingException("Record to search cannot be null. Use " + this.getSyntax(), this.text, pos);
            }
            try {
                ORecordId rid = new ORecordId(recordIdString);
                if (!rid.isValid()) {
                    throw new OCommandSQLParsingException("Record ID " + recordIdString + " is not valid", this.text, pos);
                }
                this.recordIds.add(rid);
            }
            catch (IllegalArgumentException iae) {
                throw new OCommandSQLParsingException("Error reading record Id", this.text, pos, iae);
            }
        }
        oldPos = pos;
        pos = OSQLHelper.nextWord(this.text, this.textUpperCase, oldPos, word, true);
        if (pos != -1) {
            this.classList = word.toString().trim();
            if (!this.classList.startsWith("[") || !this.classList.endsWith("]")) {
                throw new OCommandSQLParsingException("Class list must be contained in []. Use " + this.getSyntax(), this.text, pos);
            }
            this.classList = this.classList.substring(1, this.classList.length() - 1);
        }
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        if (this.recordIds.isEmpty() && this.subQuery == null) {
            throw new OCommandExecutionException("Cannot execute the command because it has not been parsed yet");
        }
        if (this.subQuery != null) {
            List result = (List)new OCommandSQL(this.subQuery.toString()).execute(new Object[0]);
            for (OIdentifiable id : result) {
                this.recordIds.add(id.getIdentity());
            }
        }
        return OFindReferenceHelper.findReferences(this.recordIds, this.classList);
    }

    @Override
    public String getSyntax() {
        return "FIND REFERENCES <rid|<sub-query>> [class-list]";
    }
}

