/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.collection.OCompositeKey;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.common.util.OPair;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OCompositeIndexDefinition;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentHelper;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLResultsetAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OIndexProxy;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItem;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionRuntime;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMajorEquals;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinor;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorMinorEquals;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeRIDSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCommandExecutorSQLSelect
extends OCommandExecutorSQLResultsetAbstract {
    private static final String KEYWORD_AS = " AS ";
    public static final String KEYWORD_SELECT = "SELECT";
    public static final String KEYWORD_ASC = "ASC";
    public static final String KEYWORD_DESC = "DESC";
    public static final String KEYWORD_ORDER = "ORDER";
    public static final String KEYWORD_BY = "BY";
    public static final String KEYWORD_ORDER_BY = "ORDER BY";
    private Map<String, Object> projections = null;
    private List<OPair<String, String>> orderedFields;
    private Object flattenTarget;
    private boolean anyFunctionAggregates = false;
    private int fetchLimit = -1;
    private OIdentifiable lastRecord;
    private Iterator<OIdentifiable> subiterator;

    @Override
    public OCommandExecutorSQLSelect parse(OCommandRequest iRequest) {
        super.parse(iRequest);
        int pos = this.parseProjections();
        if (pos == -1) {
            return this;
        }
        int endPosition = this.text.length();
        if (this.context == null) {
            this.context = new OBasicCommandContext();
        }
        this.compiledFilter = OSQLEngine.getInstance().parseFromWhereCondition(this.text.substring(pos, endPosition), this.context);
        this.optimize();
        int n = this.currentPos = this.compiledFilter.currentPos < 0 ? endPosition : this.compiledFilter.currentPos + pos;
        if (this.currentPos > -1 && this.currentPos < this.text.length()) {
            this.currentPos = OStringParser.jump(this.text, this.currentPos, " \r\n");
            StringBuilder word = new StringBuilder();
            while (this.currentPos > -1) {
                this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
                if (this.currentPos <= -1) continue;
                String w = word.toString();
                if (w.equals(KEYWORD_ORDER)) {
                    this.parseOrderBy(word);
                    continue;
                }
                if (w.equals("LIMIT")) {
                    this.parseLimit(word);
                    continue;
                }
                if (w.equals("SKIP")) {
                    this.parseSkip(word);
                    continue;
                }
                throw new OCommandSQLParsingException("Invalid keyword '" + w + "'");
            }
        }
        if (this.limit == 0 || this.limit < -1) {
            throw new IllegalArgumentException("Limit must be > 0 or = -1 (no limit)");
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.lastRecord == null) {
            this.lastRecord = this.next();
        }
        return this.lastRecord != null;
    }

    @Override
    public OIdentifiable next() {
        if (this.lastRecord != null) {
            OIdentifiable result = this.lastRecord;
            this.lastRecord = null;
            return result;
        }
        if (this.subiterator == null) {
            if (this.target == null) {
                this.executeSearch(null);
                this.subiterator = this.getResult().iterator();
            } else {
                this.subiterator = this.target.iterator();
            }
        }
        while (this.subiterator.hasNext()) {
            if (!this.executeSearchRecord(this.subiterator.next())) break;
            if (this.lastRecord == null) continue;
            return this.lastRecord;
        }
        return this.lastRecord;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove()");
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return this;
    }

    @Override
    public Object execute(Map<Object, Object> iArgs) {
        this.fetchLimit = this.getQueryFetchLimit();
        this.executeSearch(iArgs);
        this.applyFlatten();
        this.applyProjections();
        this.applyOrderBy();
        this.applyLimit();
        return this.handleResult();
    }

    protected void executeSearch(Map<Object, Object> iArgs) {
        this.assignTarget(iArgs);
        if (this.target == null) {
            return;
        }
        for (OIdentifiable id : this.target) {
            if (!this.executeSearchRecord(id)) break;
        }
    }

    @Override
    protected boolean assignTarget(Map<Object, Object> iArgs) {
        if (!super.assignTarget(iArgs)) {
            if (this.compiledFilter.getTargetIndex() != null) {
                this.searchInIndex();
            } else {
                throw new OQueryParsingException("No source found in query: specify class, cluster(s), index or single record(s). Use " + this.getSyntax());
            }
        }
        return true;
    }

    protected boolean executeSearchRecord(OIdentifiable id) {
        ORecordInternal record = (ORecordInternal)id.getRecord();
        if (record == null || record.getRecordType() != 100) {
            return true;
        }
        return !this.filter(record) || this.addResult(record);
    }

    @Override
    protected boolean addResult(OIdentifiable iRecord) {
        this.lastRecord = null;
        if (this.skip > 0) {
            --this.skip;
            return true;
        }
        this.lastRecord = iRecord instanceof ORecord ? ((ORecord)iRecord).copy() : iRecord.getIdentity().copy();
        this.lastRecord = this.applyProjections(this.lastRecord);
        ++this.resultCount;
        if (this.lastRecord != null) {
            if (this.anyFunctionAggregates || this.orderedFields != null || this.flattenTarget != null) {
                if (this.tempResult == null) {
                    this.tempResult = new ArrayList();
                }
                this.tempResult.add(this.lastRecord);
            } else if (this.subiterator == null && this.request.getResultListener() != null) {
                this.request.getResultListener().result(this.lastRecord);
            }
        }
        return this.fetchLimit <= -1 || this.resultCount < this.fetchLimit;
    }

    private int getQueryFetchLimit() {
        if (this.orderedFields != null) {
            return -1;
        }
        int sqlLimit = this.limit > -1 ? this.limit : -1;
        int requestLimit = this.request.getLimit() > -1 ? this.request.getLimit() : -1;
        if (sqlLimit == -1) {
            return requestLimit;
        }
        if (requestLimit == -1) {
            return sqlLimit;
        }
        return Math.min(sqlLimit, requestLimit);
    }

    public Map<String, Object> getProjections() {
        return this.projections;
    }

    public List<OPair<String, String>> getOrderedFields() {
        return this.orderedFields;
    }

    protected void parseOrderBy(StringBuilder word) {
        int newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
        if (!KEYWORD_BY.equals(word.toString())) {
            throw new OQueryParsingException("Expected keyword BY");
        }
        this.currentPos = newPos;
        this.orderedFields = new ArrayList<OPair<String, String>>();
        while (this.currentPos != -1) {
            String fieldOrdering;
            this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, false, " =><");
            if (this.currentPos == -1) {
                throw new OCommandSQLParsingException("Field name expected", this.text, this.currentPos);
            }
            String fieldName = word.toString();
            this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
            if (this.currentPos == -1 || word.toString().equals("LIMIT")) {
                fieldOrdering = KEYWORD_ASC;
            } else {
                if (word.toString().endsWith(",")) {
                    --this.currentPos;
                    word.deleteCharAt(word.length() - 1);
                }
                if (word.toString().equals(KEYWORD_ASC)) {
                    fieldOrdering = KEYWORD_ASC;
                } else if (word.toString().equals(KEYWORD_DESC)) {
                    fieldOrdering = KEYWORD_DESC;
                } else {
                    throw new OCommandSQLParsingException("Ordering mode '" + word + "' not supported. Valid is 'ASC', 'DESC' or nothing ('ASC' by default)", this.text, this.currentPos);
                }
                this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
            }
            this.orderedFields.add(new OPair<String, String>(fieldName, fieldOrdering));
            if (word.toString().equals(",")) continue;
            this.currentPos -= word.length();
            break;
        }
        if (this.orderedFields.size() == 0) {
            throw new OCommandSQLParsingException("Order by field set was missed. Example: ORDER BY name ASC, salary DESC", this.text, this.currentPos);
        }
    }

    @Override
    protected void searchInClasses() {
        OClass cls = this.compiledFilter.getTargetClasses().keySet().iterator().next();
        if (this.searchForIndexes(cls)) {
            OProfiler.getInstance().updateCounter("Query.indexUsage", 1L);
        } else {
            super.searchInClasses();
        }
    }

    private boolean searchForIndexes(OClass iSchemaClass) {
        ODatabaseRecord database = OCommandExecutorSQLSelect.getDatabase();
        database.checkSecurity("database.class", ORole.PERMISSION_READ, (Object)iSchemaClass.getName().toLowerCase());
        ArrayList<OIndexSearchResult> indexSearchResults = new ArrayList<OIndexSearchResult>();
        this.analyzeQueryBranch(iSchemaClass, this.compiledFilter.getRootCondition(), indexSearchResults);
        Collections.sort(indexSearchResults, new Comparator<OIndexSearchResult>(){

            @Override
            public int compare(OIndexSearchResult searchResultOne, OIndexSearchResult searchResultTwo) {
                return searchResultTwo.getFieldCount() - searchResultOne.getFieldCount();
            }
        });
        for (OIndexSearchResult searchResult : indexSearchResults) {
            int searchResultFieldsCount = searchResult.fields().size();
            List<OIndex<?>> involvedIndexes = this.getInvolvedIndexes(iSchemaClass, searchResult);
            Collections.sort(involvedIndexes, new Comparator<OIndex>(){

                @Override
                public int compare(OIndex indexOne, OIndex indexTwo) {
                    return indexOne.getDefinition().getParamCount() - indexTwo.getDefinition().getParamCount();
                }
            });
            for (OIndex<?> index : involvedIndexes) {
                String relatedIndexField;
                String lastFiled;
                OIndexDefinition indexDefinition = index.getDefinition();
                OQueryOperator operator = searchResult.lastOperator;
                if (!(operator instanceof OQueryOperatorEquals) && !(lastFiled = searchResult.lastField.getItemName(searchResult.lastField.getItemCount() - 1)).equals(relatedIndexField = indexDefinition.getFields().get(searchResult.fieldValuePairs.size()))) continue;
                ArrayList<Object> keyParams = new ArrayList<Object>(searchResultFieldsCount);
                for (String fieldName : indexDefinition.getFields().subList(0, searchResultFieldsCount)) {
                    Object fieldValue = searchResult.fieldValuePairs.get(fieldName);
                    if (fieldValue != null) {
                        keyParams.add(fieldValue);
                        continue;
                    }
                    keyParams.add(searchResult.lastValue);
                }
                Collection<OIdentifiable> result = operator.executeIndexQuery(index, keyParams, this.fetchLimit);
                if (result == null) continue;
                this.fillSearchIndexResultSet(result);
                return true;
            }
        }
        return false;
    }

    private List<OIndex<?>> getInvolvedIndexes(OClass iSchemaClass, OIndexSearchResult searchResultFields) {
        Set<OIndex<?>> involvedIndexes = iSchemaClass.getInvolvedIndexes(searchResultFields.fields());
        ArrayList result = new ArrayList(involvedIndexes.size());
        for (OIndex<?> involvedIndex : involvedIndexes) {
            if (searchResultFields.lastField.isLong()) {
                result.addAll(OIndexProxy.createdProxy(involvedIndex, searchResultFields.lastField, OCommandExecutorSQLSelect.getDatabase()));
                continue;
            }
            result.add(involvedIndex);
        }
        return result;
    }

    private OIndexSearchResult analyzeQueryBranch(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults) {
        if (iCondition == null) {
            return null;
        }
        OQueryOperator operator = iCondition.getOperator();
        if (operator == null) {
            if (iCondition.getRight() == null && iCondition.getLeft() instanceof OSQLFilterCondition) {
                return this.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getLeft(), iIndexSearchResults);
            }
            return null;
        }
        OIndexReuseType indexReuseType = operator.getIndexReuseType(iCondition.getLeft(), iCondition.getRight());
        if (indexReuseType.equals((Object)OIndexReuseType.INDEX_INTERSECTION)) {
            OIndexSearchResult leftResult = this.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getLeft(), iIndexSearchResults);
            OIndexSearchResult rightResult = this.analyzeQueryBranch(iSchemaClass, (OSQLFilterCondition)iCondition.getRight(), iIndexSearchResults);
            if (leftResult != null && rightResult != null && leftResult.canBeMerged(rightResult)) {
                OIndexSearchResult mergeResult = leftResult.merge(rightResult);
                if (iSchemaClass.areIndexed(mergeResult.fields())) {
                    iIndexSearchResults.add(mergeResult);
                }
                return leftResult.merge(rightResult);
            }
            return null;
        }
        if (indexReuseType.equals((Object)OIndexReuseType.INDEX_METHOD)) {
            OIndexSearchResult result = this.createIndexedProperty(iCondition, iCondition.getLeft());
            if (result == null) {
                result = this.createIndexedProperty(iCondition, iCondition.getRight());
            }
            if (result == null) {
                return null;
            }
            if (this.checkIndexExistence(iSchemaClass, result)) {
                iIndexSearchResults.add(result);
            }
            return result;
        }
        return null;
    }

    private OIndexSearchResult createIndexedProperty(OSQLFilterCondition iCondition, Object iItem) {
        Object origValue;
        if (iItem == null || !(iItem instanceof OSQLFilterItemField)) {
            return null;
        }
        if (iCondition.getLeft() instanceof OSQLFilterItemField && iCondition.getRight() instanceof OSQLFilterItemField) {
            return null;
        }
        OSQLFilterItemField item = (OSQLFilterItemField)iItem;
        if (item.hasChainOperators() && !item.isFieldChain()) {
            return null;
        }
        Object object = origValue = iCondition.getLeft() == iItem ? iCondition.getRight() : iCondition.getLeft();
        if (iCondition.getOperator() instanceof OQueryOperatorBetween || iCondition.getOperator() instanceof OQueryOperatorIn) {
            return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), origValue);
        }
        Object value = OSQLHelper.getValue(origValue);
        if (value == null) {
            return null;
        }
        return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), value);
    }

    private void fillSearchIndexResultSet(Object indexResult) {
        if (indexResult != null) {
            if (indexResult instanceof Collection) {
                Collection indexResultSet = (Collection)indexResult;
                for (OIdentifiable identifiable : indexResultSet) {
                    boolean continueResultParsing;
                    Object record = identifiable.getRecord();
                    if (record.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                        try {
                            record = record.load();
                        }
                        catch (ORecordNotFoundException e) {
                            throw new OException("Error during loading record with id : " + record.getIdentity());
                        }
                    }
                    if (!this.filter((ORecordInternal)record) || (continueResultParsing = this.addResult((OIdentifiable)record))) {
                        continue;
                    }
                    break;
                }
            } else {
                Object record = ((OIdentifiable)indexResult).getRecord();
                if (this.filter((ORecordInternal)record)) {
                    this.addResult((OIdentifiable)record);
                }
            }
        }
    }

    protected int parseProjections() {
        int currentPos = 0;
        StringBuilder word = new StringBuilder();
        currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, currentPos, word, true);
        if (!word.toString().equals(KEYWORD_SELECT)) {
            return -1;
        }
        int fromPosition = this.textUpperCase.indexOf(" FROM ", currentPos);
        if (fromPosition == -1) {
            throw new OQueryParsingException("Missed FROM", this.text, currentPos);
        }
        String projectionString = this.text.substring(currentPos, fromPosition).trim();
        if (projectionString.length() > 0 && !projectionString.equals("*")) {
            this.projections = new LinkedHashMap<String, Object>();
            List<String> items = OStringSerializerHelper.smartSplit(projectionString, ',', new char[0]);
            for (String projection : items) {
                projection = projection.trim();
                if (this.projections == null) {
                    throw new OCommandSQLParsingException("Projection not allowed with FLATTEN() operator");
                }
                String fieldName = null;
                int endPos = projection.toUpperCase(Locale.ENGLISH).indexOf(KEYWORD_AS);
                if (endPos > -1) {
                    fieldName = projection.substring(endPos + KEYWORD_AS.length()).trim();
                    projection = projection.substring(0, endPos).trim();
                    if (this.projections.containsKey(fieldName)) {
                        throw new OCommandSQLParsingException("Field '" + fieldName + "' is duplicated in current SELECT, choose a different name");
                    }
                } else {
                    int beginPos = projection.charAt(0) == '@' ? 1 : 0;
                    endPos = this.extractProjectionNameSubstringEndPosition(projection);
                    fieldName = endPos > -1 ? projection.substring(beginPos, endPos) : projection.substring(beginPos);
                    fieldName = OStringSerializerHelper.getStringContent(fieldName);
                    int fieldIndex = 2;
                    while (this.projections.containsKey(fieldName)) {
                        fieldName = String.valueOf(fieldName) + fieldIndex;
                        ++fieldIndex;
                    }
                }
                if (projection.toUpperCase(Locale.ENGLISH).startsWith("FLATTEN(")) {
                    List<String> pars = OStringSerializerHelper.getParameters(projection);
                    if (pars.size() != 1) {
                        throw new OCommandSQLParsingException("FLATTEN operator expects the field name as parameter. Example FLATTEN( out )");
                    }
                    this.flattenTarget = OSQLHelper.parseValue(this, pars.get(0).trim(), this.context);
                    this.projections = null;
                    if (this.anyFunctionAggregates || !(this.flattenTarget instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)this.flattenTarget).aggregateResults()) continue;
                    this.anyFunctionAggregates = true;
                    continue;
                }
                Object projectionValue = OSQLHelper.parseValue(this, projection, this.context);
                this.projections.put(fieldName, projectionValue);
                if (this.anyFunctionAggregates || !(projectionValue instanceof OSQLFunctionRuntime) || !((OSQLFunctionRuntime)projectionValue).aggregateResults()) continue;
                this.anyFunctionAggregates = true;
            }
        }
        currentPos = fromPosition + "FROM".length() + 1;
        return currentPos;
    }

    protected int extractProjectionNameSubstringEndPosition(String projection) {
        int endPos;
        int pos1 = projection.indexOf(46);
        int pos2 = projection.indexOf(40);
        int pos3 = projection.indexOf(91);
        if (pos1 > -1 && pos2 == -1 && pos3 == -1) {
            endPos = pos1;
        } else if (pos2 > -1 && pos1 == -1 && pos3 == -1) {
            endPos = pos2;
        } else if (pos3 > -1 && pos1 == -1 && pos2 == -1) {
            endPos = pos3;
        } else if (pos1 > -1 && pos2 > -1 && pos3 == -1) {
            endPos = Math.min(pos1, pos2);
        } else if (pos2 > -1 && pos3 > -1 && pos1 == -1) {
            endPos = Math.min(pos2, pos3);
        } else if (pos1 > -1 && pos3 > -1 && pos2 == -1) {
            endPos = Math.min(pos1, pos3);
        } else if (pos1 > -1 && pos2 > -1 && pos3 > -1) {
            endPos = Math.min(pos1, pos2);
            endPos = Math.min(endPos, pos3);
        } else {
            endPos = -1;
        }
        return endPos;
    }

    private void applyOrderBy() {
        if (this.orderedFields == null) {
            return;
        }
        ODocumentHelper.sort(this.getResult(), this.orderedFields);
        this.orderedFields.clear();
    }

    private void applyFlatten() {
        if (this.flattenTarget == null) {
            return;
        }
        ArrayList<Object> finalResult = new ArrayList<Object>();
        if (this.tempResult != null) {
            for (OIdentifiable id : this.tempResult) {
                Object fieldValue = this.flattenTarget instanceof OSQLFilterItem ? ((OSQLFilterItem)this.flattenTarget).getValue((OIdentifiable)id.getRecord(), this.context) : (this.flattenTarget instanceof OSQLFunctionRuntime ? ((OSQLFunctionRuntime)this.flattenTarget).getResult() : this.flattenTarget.toString());
                if (fieldValue == null) continue;
                if (fieldValue instanceof Collection) {
                    for (Object o : (Collection)fieldValue) {
                        if (!(o instanceof OIdentifiable)) continue;
                        finalResult.add(((OIdentifiable)o).getRecord());
                    }
                    continue;
                }
                finalResult.add((OIdentifiable)fieldValue);
            }
        }
        this.tempResult = finalResult;
    }

    private OIdentifiable applyProjections(OIdentifiable iRecord) {
        if (this.projections != null) {
            ODocument doc = (ODocument)iRecord.getRecord();
            ODocument result = new ODocument().setOrdered(true);
            ((ORecordId)result.getIdentity()).clusterId = -2;
            ((ORecordId)result.getIdentity()).clusterPosition = this.resultCount;
            boolean canExcludeResult = false;
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                Object value;
                if (projection.getValue().equals("*")) {
                    doc.copy(result);
                    value = null;
                } else if (projection.getValue().toString().startsWith("$")) {
                    value = this.context != null ? this.context.getVariable(projection.getValue().toString().substring(1)) : null;
                } else if (projection.getValue() instanceof OSQLFilterItemField) {
                    value = ((OSQLFilterItemField)projection.getValue()).getValue(doc, null);
                } else if (projection.getValue() instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                    canExcludeResult = f.filterResult();
                    value = f.execute(doc, this);
                } else {
                    value = projection.getValue();
                }
                if (value == null) continue;
                result.field(projection.getKey(), value);
            }
            if (canExcludeResult && result.isEmpty()) {
                return null;
            }
            if (this.anyFunctionAggregates) {
                return null;
            }
            return result;
        }
        return iRecord;
    }

    /*
     * WARNING - void declaration
     */
    private void searchInIndex() {
        OIndex index = OCommandExecutorSQLSelect.getDatabase().getMetadata().getIndexManager().getIndex(this.compiledFilter.getTargetIndex());
        if (index == null) {
            throw new OCommandExecutionException("Target index '" + this.compiledFilter.getTargetIndex() + "' not found");
        }
        if (index.getDefinition() == null) {
            return;
        }
        if (this.compiledFilter.getRootCondition() != null) {
            Object value;
            Collection<ODocument> entries;
            if (!"KEY".equalsIgnoreCase(this.compiledFilter.getRootCondition().getLeft().toString())) {
                throw new OCommandExecutionException("'Key' field is required for queries against indexes");
            }
            OQueryOperator indexOperator = this.compiledFilter.getRootCondition().getOperator();
            if (indexOperator instanceof OQueryOperatorBetween) {
                Object[] values = (Object[])this.compiledFilter.getRootCondition().getRight();
                entries = index.getEntriesBetween(this.getIndexKey(index.getDefinition(), values[0]), this.getIndexKey(index.getDefinition(), values[2]));
                for (OIdentifiable oIdentifiable : entries) {
                    boolean continueResultParsing = this.addResult(oIdentifiable);
                    if (continueResultParsing) {
                        continue;
                    }
                    break;
                }
            } else if (indexOperator instanceof OQueryOperatorMajor) {
                value = this.compiledFilter.getRootCondition().getRight();
                entries = index.getEntriesMajor(this.getIndexKey(index.getDefinition(), value), false);
                this.parseIndexSearchResult(entries);
            } else if (indexOperator instanceof OQueryOperatorMajorEquals) {
                value = this.compiledFilter.getRootCondition().getRight();
                entries = index.getEntriesMajor(this.getIndexKey(index.getDefinition(), value), true);
                this.parseIndexSearchResult(entries);
            } else if (indexOperator instanceof OQueryOperatorMinor) {
                value = this.compiledFilter.getRootCondition().getRight();
                entries = index.getEntriesMinor(this.getIndexKey(index.getDefinition(), value), false);
                this.parseIndexSearchResult(entries);
            } else if (indexOperator instanceof OQueryOperatorMinorEquals) {
                value = this.compiledFilter.getRootCondition().getRight();
                entries = index.getEntriesMinor(this.getIndexKey(index.getDefinition(), value), true);
                this.parseIndexSearchResult(entries);
            } else if (indexOperator instanceof OQueryOperatorIn) {
                List origValues = (List)this.compiledFilter.getRootCondition().getRight();
                ArrayList<Object> values = new ArrayList<Object>(origValues.size());
                for (ODocument oDocument : origValues) {
                    if (index.getDefinition() instanceof OCompositeIndexDefinition) {
                        throw new OCommandExecutionException("Operator IN not supported yet.");
                    }
                    Object object = this.getIndexKey(index.getDefinition(), oDocument);
                    values.add(object);
                }
                Collection<ODocument> collection = index.getEntries(values);
                this.parseIndexSearchResult(collection);
            } else {
                void var5_13;
                Object right = this.compiledFilter.getRootCondition().getRight();
                Object keyValue = this.getIndexKey(index.getDefinition(), right);
                if (index.getDefinition().getParamCount() == 1) {
                    Object obj = index.get(keyValue);
                } else {
                    Object secondKey = this.getIndexKey(index.getDefinition(), right);
                    Collection<OIdentifiable> collection = index.getValuesBetween(keyValue, secondKey);
                }
                if (var5_13 != null) {
                    if (var5_13 instanceof Collection) {
                        for (OIdentifiable r : (Collection)var5_13) {
                            this.addResult(this.createIndexEntryAsDocument(keyValue, r.getIdentity()));
                        }
                    } else {
                        this.addResult(this.createIndexEntryAsDocument(keyValue, ((OIdentifiable)var5_13).getIdentity()));
                    }
                }
            }
        } else {
            Map.Entry<String, Object> projection;
            if (this.anyFunctionAggregates && this.projections.entrySet().size() == 1 && (projection = this.projections.values().iterator().next()) instanceof OSQLFunctionRuntime && ((OSQLFunctionRuntime)((Object)projection)).getRoot().equals("count")) {
                OSQLFunctionRuntime f = (OSQLFunctionRuntime)((Object)projection);
                f.setResult(index.getSize());
                return;
            }
            OIndexInternal<?> indexInternal = index.getInternal();
            if (indexInternal instanceof OSharedResource) {
                ((OSharedResource)((Object)indexInternal)).acquireExclusiveLock();
            }
            try {
                Iterator<Map.Entry<Object, ?>> it = index.iterator();
                while (it.hasNext()) {
                    Map.Entry<Object, ?> current = it.next();
                    if (current.getValue() instanceof Collection) {
                        for (OIdentifiable oIdentifiable : (OMVRBTreeRIDSet)current.getValue()) {
                            this.addResult(this.createIndexEntryAsDocument(current.getKey(), oIdentifiable.getIdentity()));
                        }
                        continue;
                    }
                    this.addResult(this.createIndexEntryAsDocument(current.getKey(), (OIdentifiable)current.getValue()));
                }
            }
            finally {
                if (indexInternal instanceof OSharedResource) {
                    ((OSharedResource)((Object)indexInternal)).releaseExclusiveLock();
                }
            }
        }
        if (this.anyFunctionAggregates) {
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                if (!(projection.getValue() instanceof OSQLFunctionRuntime)) continue;
                OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                f.setResult(index.getSize());
            }
        }
    }

    private Object getIndexKey(OIndexDefinition indexDefinition, Object value) {
        if (indexDefinition instanceof OCompositeIndexDefinition) {
            if (value instanceof List) {
                List values = (List)value;
                ArrayList<Object> keyParams = new ArrayList<Object>(values.size());
                for (Object o : values) {
                    keyParams.add(OSQLHelper.getValue(o));
                }
                return indexDefinition.createValue(keyParams);
            }
            if ((value = OSQLHelper.getValue(value)) instanceof OCompositeKey) {
                return value;
            }
            return indexDefinition.createValue(value);
        }
        return OSQLHelper.getValue(value);
    }

    protected void parseIndexSearchResult(Collection<ODocument> entries) {
        for (ODocument document : entries) {
            boolean continueResultParsing = this.addResult(document);
            if (!continueResultParsing) break;
        }
    }

    private ODocument createIndexEntryAsDocument(Object iKey, OIdentifiable iValue) {
        ODocument doc = new ODocument().setOrdered(true);
        doc.field("key", iKey);
        doc.field("rid", iValue);
        doc.unsetDirty();
        return doc;
    }

    private void applyProjections() {
        if (this.anyFunctionAggregates) {
            ODocument result = new ODocument().setOrdered(true);
            for (Map.Entry<String, Object> projection : this.projections.entrySet()) {
                Object value;
                if (projection.getValue() instanceof OSQLFilterItemField) {
                    value = ((OSQLFilterItemField)projection.getValue()).getValue(result, null);
                } else if (projection.getValue() instanceof OSQLFunctionRuntime) {
                    OSQLFunctionRuntime f = (OSQLFunctionRuntime)projection.getValue();
                    value = f.getResult();
                } else {
                    value = projection.getValue();
                }
                result.field(projection.getKey(), value);
            }
            this.request.getResultListener().result(result);
        }
    }

    private boolean checkIndexExistence(OClass iSchemaClass, OIndexSearchResult result) {
        if (!iSchemaClass.areIndexed(result.fields())) {
            return false;
        }
        if (result.lastField.isLong()) {
            int fieldCount = result.lastField.getItemCount();
            OClass oClass = iSchemaClass.getProperty(result.lastField.getItemName(0)).getLinkedClass();
            int i = 1;
            while (i < fieldCount) {
                if (!oClass.areIndexed(result.lastField.getItemName(i))) {
                    return false;
                }
                oClass = oClass.getProperty(result.lastField.getItemName(i)).getLinkedClass();
                ++i;
            }
        }
        return true;
    }

    @Override
    public String getSyntax() {
        return "SELECT [<Projections>] FROM <Target> [WHERE <Condition>*] [ORDER BY <Fields>* [ASC|DESC]*] [LIMIT <MaxRecords>]";
    }
}

