/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterDatabase;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAlterProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateLink;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLCreateProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDelete;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLDropProperty;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFindReferences;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLGrant;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLInsert;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRebuildIndex;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLRevoke;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLSelect;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTraverse;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateClass;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateCluster;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLTruncateRecord;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLUpdate;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ODefaultCommandExecutorSQLFactory
implements OCommandExecutorSQLFactory {
    private static final Map<String, Class<? extends OCommandExecutorSQLAbstract>> COMMANDS;

    static {
        HashMap<String, Class<OCommandExecutorSQLAlterCluster>> commands = new HashMap<String, Class<OCommandExecutorSQLAlterCluster>>();
        commands.put("ALTER DATABASE", OCommandExecutorSQLAlterDatabase.class);
        commands.put("SELECT", OCommandExecutorSQLSelect.class);
        commands.put("TRAVERSE", OCommandExecutorSQLTraverse.class);
        commands.put("INSERT", OCommandExecutorSQLInsert.class);
        commands.put("UPDATE", OCommandExecutorSQLUpdate.class);
        commands.put("DELETE", OCommandExecutorSQLDelete.class);
        commands.put("GRANT", OCommandExecutorSQLGrant.class);
        commands.put("REVOKE", OCommandExecutorSQLRevoke.class);
        commands.put("CREATE LINK", OCommandExecutorSQLCreateLink.class);
        commands.put("CREATE INDEX", OCommandExecutorSQLCreateIndex.class);
        commands.put("DROP INDEX", OCommandExecutorSQLDropIndex.class);
        commands.put("REBUILD INDEX", OCommandExecutorSQLRebuildIndex.class);
        commands.put("CREATE CLASS", OCommandExecutorSQLCreateClass.class);
        commands.put("ALTER CLASS", OCommandExecutorSQLAlterClass.class);
        commands.put("CREATE PROPERTY", OCommandExecutorSQLCreateProperty.class);
        commands.put("ALTER PROPERTY", OCommandExecutorSQLAlterProperty.class);
        commands.put("DROP CLASS", OCommandExecutorSQLDropClass.class);
        commands.put("DROP PROPERTY", OCommandExecutorSQLDropProperty.class);
        commands.put("FIND REFERENCES", OCommandExecutorSQLFindReferences.class);
        commands.put("TRUNCATE CLASS", OCommandExecutorSQLTruncateClass.class);
        commands.put("TRUNCATE CLUSTER", OCommandExecutorSQLTruncateCluster.class);
        commands.put("TRUNCATE RECORD", OCommandExecutorSQLTruncateRecord.class);
        commands.put("ALTER CLUSTER", OCommandExecutorSQLAlterCluster.class);
        COMMANDS = Collections.unmodifiableMap(commands);
    }

    @Override
    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    @Override
    public OCommandExecutorSQLAbstract createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutorSQLAbstract> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknowned command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors", e);
        }
    }
}

