/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql;

import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexOneValue;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OIndexProxy<T>
implements OIndex<T> {
    private final OIndex<T> index;
    private final List<OIndex<?>> indexChain;
    private final OIndex<?> lastIndex;

    public static <T> Collection<OIndexProxy<T>> createdProxy(OIndex<T> index, OSQLFilterItemField.FieldChain longChain, ODatabaseComplex<?> database) {
        ArrayList<OIndexProxy<T>> proxies = new ArrayList<OIndexProxy<T>>();
        for (List<OIndex<?>> list : OIndexProxy.getIndexesForChain(index, longChain, database)) {
            proxies.add(new OIndexProxy<T>(index, list));
        }
        return proxies;
    }

    private OIndexProxy(OIndex<T> index, List<OIndex<?>> indexChain) {
        this.index = index;
        this.indexChain = Collections.unmodifiableList(indexChain);
        this.lastIndex = indexChain.get(indexChain.size() - 1);
    }

    @Override
    public T get(Object iKey) {
        Object result = this.lastIndex.get(iKey);
        Collection<T> resultSet = this.applyTailIndexes(result, -1);
        if (this.getInternal() instanceof OIndexOneValue && resultSet.size() == 1) {
            return resultSet.iterator().next();
        }
        return (T)resultSet;
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, Object iRangeTo) {
        Collection<OIdentifiable> result = this.lastIndex.getValuesBetween(iRangeFrom, iRangeTo);
        return this.applyTailIndexes(result, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive) {
        Collection<OIdentifiable> result = this.lastIndex.getValuesBetween(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive);
        return this.applyTailIndexes(result, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesBetween(Object iRangeFrom, boolean iFromInclusive, Object iRangeTo, boolean iToInclusive, int maxValuesToFetch) {
        Collection<OIdentifiable> result = this.lastIndex.getValuesBetween(iRangeFrom, iFromInclusive, iRangeTo, iToInclusive);
        return this.applyTailIndexes(result, maxValuesToFetch);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive) {
        Collection<OIdentifiable> result = this.lastIndex.getValuesMajor(fromKey, isInclusive);
        return this.applyTailIndexes(result, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesMajor(Object fromKey, boolean isInclusive, int maxValuesToFetch) {
        Collection<OIdentifiable> result = this.lastIndex.getValuesMajor(fromKey, isInclusive);
        return this.applyTailIndexes(result, maxValuesToFetch);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive) {
        Collection<OIdentifiable> result = this.lastIndex.getValuesMinor(toKey, isInclusive);
        return this.applyTailIndexes(result, -1);
    }

    @Override
    public Collection<OIdentifiable> getValuesMinor(Object toKey, boolean isInclusive, int maxValuesToFetch) {
        Collection<OIdentifiable> result = this.lastIndex.getValuesMinor(toKey, isInclusive);
        return this.applyTailIndexes(result, maxValuesToFetch);
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys) {
        Collection<OIdentifiable> result = this.lastIndex.getValues(iKeys);
        return this.applyTailIndexes(result, -1);
    }

    @Override
    public Collection<OIdentifiable> getValues(Collection<?> iKeys, int maxValuesToFetch) {
        Collection<OIdentifiable> result = this.lastIndex.getValues(iKeys);
        return this.applyTailIndexes(result, maxValuesToFetch);
    }

    @Override
    public OIndexInternal<T> getInternal() {
        return this.lastIndex.getInternal();
    }

    @Override
    public OIndexDefinition getDefinition() {
        return this.indexChain.get(this.indexChain.size() - 1).getDefinition();
    }

    private Collection<T> applyTailIndexes(Object result, int maxValuesToFetch) {
        OIndex<?> previousIndex = this.indexChain.get(this.indexChain.size() - 2);
        Set<Comparable> currentKeys = this.prepareKeys(previousIndex, result);
        int j = this.indexChain.size() - 2;
        while (j > 0) {
            TreeSet<Comparable> newKeys = new TreeSet<Comparable>();
            OIndex<?> currentIndex = this.indexChain.get(j);
            for (Comparable currentKey : currentKeys) {
                Object currentResult = currentIndex.get(currentKey);
                Set<Comparable> preparedKeys = this.prepareKeys(this.indexChain.get(j - 1), currentResult);
                newKeys.addAll(preparedKeys);
            }
            this.updateStatistic(currentIndex);
            currentKeys = newKeys;
            --j;
        }
        return this.applyMainIndex(currentKeys, maxValuesToFetch);
    }

    private Set<Comparable> convertResult(Object result, Class<?> targetType) {
        if (result instanceof Set) {
            TreeSet<Comparable> newKeys = new TreeSet<Comparable>();
            for (Object o : (Set)result) {
                newKeys.add((Comparable)OType.convert(o, targetType));
            }
            return newKeys;
        }
        return Collections.singleton((Comparable)OType.convert(result, targetType));
    }

    private Set<Comparable> prepareKeys(OIndex<?> index, Object keys) {
        Class<?> targetType = index.getKeyTypes()[0].getDefaultJavaType();
        return this.convertResult(keys, targetType);
    }

    private Collection<T> applyMainIndex(Iterable<Comparable> currentKeys, int maxValuesToFetch) {
        TreeSet<Object> resultSet = new TreeSet<Object>();
        for (Comparable key : currentKeys) {
            T result = this.index.get(this.index.getDefinition().createValue(key));
            if (result instanceof Set) {
                for (Object o : (Set)result) {
                    resultSet.add(o);
                    if (maxValuesToFetch == -1 || resultSet.size() < maxValuesToFetch) {
                        continue;
                    }
                    break;
                }
            } else {
                resultSet.add(result);
            }
            if (maxValuesToFetch != -1 && resultSet.size() >= maxValuesToFetch) break;
        }
        this.updateStatistic(this.index);
        return resultSet;
    }

    private static Iterable<List<OIndex<?>>> getIndexesForChain(OIndex<?> index, OSQLFilterItemField.FieldChain fieldChain, ODatabaseComplex<?> database) {
        List<OIndex<?>> baseIndexes = OIndexProxy.prepareBaseIndexes(index, fieldChain, database);
        Collection<OIndex<?>> lastIndexes = OIndexProxy.prepareLastIndexVariants(index, fieldChain, database);
        ArrayList result = new ArrayList();
        for (OIndex<?> lastIndex : lastIndexes) {
            ArrayList indexes = new ArrayList(fieldChain.getItemCount());
            indexes.addAll(baseIndexes);
            indexes.add(lastIndex);
            result.add(indexes);
        }
        return result;
    }

    private static Collection<OIndex<?>> prepareLastIndexVariants(OIndex<?> index, OSQLFilterItemField.FieldChain fieldChain, ODatabaseComplex<?> database) {
        OClass oClass = database.getMetadata().getSchema().getClass(index.getDefinition().getClassName());
        int i = 0;
        while (i < fieldChain.getItemCount() - 1) {
            oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass();
            ++i;
        }
        Set<OIndex<?>> involvedIndexes = oClass.getInvolvedIndexes(fieldChain.getItemName(fieldChain.getItemCount() - 1));
        HashSet indexTypes = new HashSet(3);
        ArrayList result = new ArrayList();
        for (OIndex<?> involvedIndex : involvedIndexes) {
            if (indexTypes.contains(involvedIndex.getInternal().getClass())) continue;
            result.add(involvedIndex);
            indexTypes.add(involvedIndex.getInternal().getClass());
        }
        return result;
    }

    private static List<OIndex<?>> prepareBaseIndexes(OIndex<?> index, OSQLFilterItemField.FieldChain fieldChain, ODatabaseComplex<?> database) {
        ArrayList result = new ArrayList(fieldChain.getItemCount() - 2);
        result.add(index);
        OClass oClass = database.getMetadata().getSchema().getClass(index.getDefinition().getClassName());
        oClass = oClass.getProperty(fieldChain.getItemName(0)).getLinkedClass();
        int i = 1;
        while (i < fieldChain.getItemCount() - 1) {
            Set<OIndex<?>> involvedIndexes = oClass.getInvolvedIndexes(fieldChain.getItemName(i));
            OIndex<?> bestIndex = OIndexProxy.findBestIndex(involvedIndexes);
            result.add(bestIndex);
            oClass = oClass.getProperty(fieldChain.getItemName(i)).getLinkedClass();
            ++i;
        }
        return result;
    }

    private static OIndex<?> findBestIndex(Iterable<OIndex<?>> involvedIndexes) {
        OIndex<?> bestIndex = null;
        Iterator<OIndex<?>> iterator = involvedIndexes.iterator();
        while (iterator.hasNext()) {
            OIndex<?> index;
            bestIndex = index = iterator.next();
            OIndexInternal<?> bestInternalIndex = index.getInternal();
            if (!(bestInternalIndex instanceof OIndexUnique) && !(bestInternalIndex instanceof OIndexNotUnique)) continue;
            return index;
        }
        return bestIndex;
    }

    private void updateStatistic(OIndex<?> index) {
        if (OProfiler.getInstance().isRecording()) {
            OProfiler.getInstance().updateCounter("Query.indexUsage", 1L);
            int paramCount = index.getDefinition().getParamCount();
            if (paramCount > 1) {
                OProfiler.getInstance().updateCounter("Query.compositeIndexUsage", 1L);
                OProfiler.getInstance().updateCounter("Query.compositeIndexUsage." + paramCount, 1L);
            }
        }
    }

    @Override
    public void checkEntry(OIdentifiable iRecord, Object iKey) {
        this.index.checkEntry(iRecord, iKey);
    }

    @Override
    public OIndex<T> create(String iName, OIndexDefinition iIndexDefinition, ODatabaseRecord iDatabase, String iClusterIndexName, int[] iClusterIdsToIndex, OProgressListener iProgressListener) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntriesMajor(Object fromKey, boolean isInclusive, int maxEntriesToFetch) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntriesMinor(Object toKey, boolean isInclusive, int maxEntriesToFetch) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo, boolean iInclusive, int maxEntriesToFetch) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntriesBetween(Object iRangeFrom, Object iRangeTo) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Collection<ODocument> getEntries(Collection<?> iKeys, int maxEntriesToFetch) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean contains(Object iKey) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void unload() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OType[] getKeyTypes() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Iterator<Map.Entry<Object, T>> iterator() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<T> put(Object iKey, OIdentifiable iValue) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean remove(Object iKey) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean remove(Object iKey, OIdentifiable iRID) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public int remove(OIdentifiable iRID) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<T> clear() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Iterable<Object> keys() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long getSize() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<T> lazySave() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public OIndex<T> delete() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getName() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public String getType() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public boolean isAutomatic() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long rebuild() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public long rebuild(OProgressListener iProgressListener) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ODocument getConfiguration() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public ORID getIdentity() {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public void commit(ODocument iDocument) {
        throw new UnsupportedOperationException("Not allowed operation");
    }

    @Override
    public Set<String> getClusters() {
        throw new UnsupportedOperationException("Not allowed operation");
    }
}

