/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.OCommandSQLResultset;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLPredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLFilter
extends OSQLPredicate
implements OCommandPredicate {
    protected Iterable<? extends OIdentifiable> targetRecords;
    protected Map<String, String> targetClusters;
    protected Map<OClass, String> targetClasses;
    protected String targetIndex;

    public OSQLFilter(String iText, OCommandContext iContext) {
        block7: {
            this.context = iContext;
            this.text = iText;
            this.textUpperCase = iText.toUpperCase();
            try {
                StringBuilder word;
                int newPos;
                if (!this.extractTargets() || (newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word = new StringBuilder(), true)) <= -1) break block7;
                if (word.toString().equals("WHERE")) {
                    int lastPos = newPos;
                    String lastText = this.text;
                    String lastTextUpperCase = this.textUpperCase;
                    this.text(this.text.substring(newPos));
                    if (this.currentPos > -1) {
                        this.currentPos += lastPos;
                    }
                    this.text = lastText;
                    this.textUpperCase = lastTextUpperCase;
                    break block7;
                }
                if (word.toString().equals("LIMIT") || word.toString().equals("ORDER") || word.toString().equals("SKIP")) {
                    return;
                }
                throw new OQueryParsingException("Found invalid keyword '" + word + "'", this.text, newPos);
            }
            catch (OQueryParsingException e) {
                if (e.getText() == null) {
                    throw new OQueryParsingException("Error on parsing query", this.text, this.currentPos, e);
                }
                throw e;
            }
            catch (Throwable t) {
                throw new OQueryParsingException("Error on parsing query", this.text, this.currentPos, t);
            }
        }
    }

    @Override
    public boolean evaluate(ORecord<?> iRecord, OCommandContext iContext) {
        ORecordSchemaAware recordSchemaAware = (ORecordSchemaAware)iRecord;
        if (this.targetClasses != null && !this.targetClasses.isEmpty()) {
            for (OClass targetClass : this.targetClasses.keySet()) {
                if (targetClass.isSuperClassOf(recordSchemaAware.getSchemaClass())) continue;
                return false;
            }
        }
        if (this.rootCondition == null) {
            return true;
        }
        return (Boolean)this.rootCondition.evaluate(recordSchemaAware, iContext);
    }

    private boolean extractTargets() {
        this.currentPos = OStringParser.jumpWhiteSpaces(this.text, this.currentPos);
        if (this.currentPos == -1) {
            throw new OQueryParsingException("No query target found", this.text, 0);
        }
        char c = this.text.charAt(this.currentPos);
        if (c == '#' || Character.isDigit(c)) {
            StringBuilder word = new StringBuilder();
            this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
            this.targetRecords = new ArrayList<OIdentifiable>();
            ((List)this.targetRecords).add(new ORecordId(word.toString()));
        } else if (c == '(') {
            StringBuilder subText = new StringBuilder();
            this.currentPos = OStringSerializerHelper.getEmbedded(this.text, this.currentPos, -1, subText);
            OCommandSQLResultset subCommand = new OCommandSQLResultset(subText.toString());
            OCommandExecutor executor = OCommandManager.instance().getExecutor(subCommand);
            executor.setProgressListener(subCommand.getProgressListener());
            executor.parse(subCommand);
            subCommand.setContext(executor.getContext());
            if (!(executor instanceof Iterable)) {
                throw new OCommandSQLParsingException("Sub-query cannot be iterated because doesn't implement the Iterable interface: " + subCommand);
            }
            this.targetRecords = (Iterable)((Object)executor);
            OCommandContext subContext = subCommand.getContext();
            if (this.context != null) {
                this.context.merge(subContext);
            } else {
                this.context = subContext;
            }
        } else if (c == '[') {
            ArrayList<String> rids = new ArrayList<String>();
            this.currentPos = OStringSerializerHelper.getCollection(this.text, this.currentPos, rids);
            this.targetRecords = new ArrayList<OIdentifiable>();
            for (String rid : rids) {
                ((List)this.targetRecords).add(new ORecordId(rid));
            }
            if (this.currentPos > -1) {
                ++this.currentPos;
            }
        } else {
            StringBuilder word = new StringBuilder();
            this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
            while (this.currentPos > -1 && this.targetClasses == null && this.targetClusters == null && this.targetIndex == null) {
                OClass cls;
                String alias;
                String subjectName = word.toString();
                int newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
                if (newPos > -1 && word.toString().equals("AS")) {
                    this.currentPos = newPos;
                    newPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, true);
                    if (newPos == -1) {
                        throw new OQueryParsingException("No alias found. Example: SELECT FROM Customer AS c", this.text, this.currentPos);
                    }
                    this.currentPos = newPos;
                    alias = word.toString();
                } else {
                    alias = subjectName;
                }
                String subjectToMatch = subjectName;
                if (subjectToMatch.startsWith("CLUSTER:")) {
                    if (this.targetClusters == null) {
                        this.targetClusters = new HashMap<String, String>();
                    }
                    this.targetClusters.put(subjectName.substring("CLUSTER:".length()), alias);
                    continue;
                }
                if (subjectToMatch.startsWith("INDEX:")) {
                    this.targetIndex = subjectName.substring("INDEX:".length());
                    continue;
                }
                if (subjectToMatch.startsWith("CLASS:")) {
                    subjectName = subjectName.substring("CLASS:".length());
                }
                if (this.targetClasses == null) {
                    this.targetClasses = new HashMap<OClass, String>();
                }
                if ((cls = ODatabaseRecordThreadLocal.INSTANCE.get().getMetadata().getSchema().getClass(subjectName)) == null) {
                    throw new OCommandExecutionException("Class '" + subjectName + "' was not found in current database");
                }
                this.targetClasses.put(cls, alias);
            }
        }
        return this.currentPos > -1;
    }

    public Map<String, String> getTargetClusters() {
        return this.targetClusters;
    }

    public Map<OClass, String> getTargetClasses() {
        return this.targetClasses;
    }

    public Iterable<? extends OIdentifiable> getTargetRecords() {
        return this.targetRecords;
    }

    public String getTargetIndex() {
        return this.targetIndex;
    }

    @Override
    public OSQLFilterCondition getRootCondition() {
        return this.rootCondition;
    }

    @Override
    public String toString() {
        if (this.rootCondition != null) {
            return "Parsed: " + this.rootCondition.toString();
        }
        return "Unparsed: " + this.text;
    }
}

