/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.filter;

import com.orientechnologies.common.parser.OStringParser;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.OCommandPredicate;
import com.orientechnologies.orient.core.command.OCommandToParse;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordSchemaAware;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.sql.OSQLEngine;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemFieldAll;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemFieldAny;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemParameter;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorNot;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSQLPredicate
extends OCommandToParse
implements OCommandPredicate {
    protected Set<OProperty> properties = new HashSet<OProperty>();
    protected OSQLFilterCondition rootCondition;
    protected List<String> recordTransformed;
    protected List<OSQLFilterItemParameter> parameterItems;
    protected int braces;
    protected OCommandContext context;

    public OSQLPredicate() {
    }

    public OSQLPredicate(String iText) {
        this.text(iText);
    }

    public OSQLPredicate text(String iText) {
        try {
            this.text = iText;
            this.textUpperCase = this.text.toUpperCase(Locale.ENGLISH);
            this.currentPos = 0;
            this.jumpWhiteSpaces();
            this.rootCondition = (OSQLFilterCondition)this.extractConditions(null);
        }
        catch (OQueryParsingException e) {
            if (e.getText() == null) {
                throw new OQueryParsingException("Error on parsing query", this.text, this.currentPos, e);
            }
            throw e;
        }
        catch (Throwable t) {
            throw new OQueryParsingException("Error on parsing query", this.text, this.currentPos, t);
        }
        return this;
    }

    @Override
    public boolean evaluate(ORecord<?> iRecord, OCommandContext iContext) {
        if (this.rootCondition == null) {
            return true;
        }
        return (Boolean)this.rootCondition.evaluate((ORecordSchemaAware)iRecord, iContext);
    }

    private Object extractConditions(OSQLFilterCondition iParentCondition) {
        int oldPosition = this.currentPos;
        String[] words = this.nextValue(true);
        if (words != null && words.length > 0 && (words[0].equalsIgnoreCase("SELECT") || words[0].equalsIgnoreCase("TRAVERSE"))) {
            StringBuilder embedded = new StringBuilder();
            OStringSerializerHelper.getEmbedded(this.text, oldPosition - 1, -1, embedded);
            this.currentPos += embedded.length() + 1;
            return new OSQLSynchQuery(embedded.toString());
        }
        this.currentPos = oldPosition;
        OSQLFilterCondition currentCondition = this.extractCondition();
        if (!this.jumpWhiteSpaces()) {
            return currentCondition;
        }
        if (this.currentPos > -1 && this.text.charAt(this.currentPos) == ')') {
            return currentCondition;
        }
        OQueryOperator nextOperator = this.extractConditionOperator();
        if (nextOperator == null) {
            return currentCondition;
        }
        if (nextOperator.precedence > currentCondition.getOperator().precedence) {
            OSQLFilterCondition subCondition = new OSQLFilterCondition(currentCondition.right, nextOperator);
            currentCondition.right = subCondition;
            subCondition.right = this.extractConditions(subCondition);
            return currentCondition;
        }
        OSQLFilterCondition parentCondition = new OSQLFilterCondition(currentCondition, nextOperator);
        parentCondition.right = this.extractConditions(parentCondition);
        return parentCondition;
    }

    protected OSQLFilterCondition extractCondition() {
        Object right;
        OQueryOperator oper;
        if (!this.jumpWhiteSpaces()) {
            return null;
        }
        Object left = this.extractConditionItem(true, 1);
        if (this.checkForEnd(left.toString())) {
            return null;
        }
        if (left instanceof OQueryOperator && ((OQueryOperator)left).isUnary()) {
            oper = (OQueryOperator)left;
            left = this.extractConditionItem(false, 1);
            right = null;
        } else {
            oper = this.extractConditionOperator();
            right = oper != null ? this.extractConditionItem(false, oper.expectedRightWords) : null;
        }
        return new OSQLFilterCondition(left, oper, right);
    }

    protected boolean checkForEnd(String iWord) {
        if (iWord != null && (iWord.equals("ORDER") || iWord.equals("LIMIT") || iWord.equals("SKIP"))) {
            this.currentPos -= iWord.length();
            return true;
        }
        return false;
    }

    private OQueryOperator extractConditionOperator() {
        if (!this.jumpWhiteSpaces()) {
            return null;
        }
        if (this.text.charAt(this.currentPos) == ')') {
            return null;
        }
        String word = this.nextWord(true, " 0123456789'\"");
        if (this.checkForEnd(word)) {
            return null;
        }
        OQueryOperator[] oQueryOperatorArray = OSQLEngine.getInstance().getRecordOperators();
        int n = oQueryOperatorArray.length;
        int n2 = 0;
        while (n2 < n) {
            OQueryOperator op = oQueryOperatorArray[n2];
            if (word.startsWith(op.keyword)) {
                ArrayList<String> params = new ArrayList<String>();
                if (word.length() > op.keyword.length() && word.charAt(op.keyword.length()) == '(') {
                    int paramBeginPos = this.currentPos - (word.length() - op.keyword.length());
                    this.currentPos = OStringSerializerHelper.getParameters(this.text, paramBeginPos, -1, params);
                } else if (!word.equals(op.keyword)) {
                    throw new OQueryParsingException("Malformed usage of operator '" + op.toString() + "'. Parsed operator is: " + word);
                }
                try {
                    return op.configure(params);
                }
                catch (Exception e) {
                    throw new OQueryParsingException("Syntax error using the operator '" + op.toString() + "'. Syntax is: " + op.getSyntax());
                }
            }
            ++n2;
        }
        throw new OQueryParsingException("Unknown operator " + word, this.text, this.currentPos);
    }

    private Object extractConditionItem(boolean iAllowOperator, int iExpectedWords) {
        Object[] result = new Object[iExpectedWords];
        int i = 0;
        while (i < iExpectedWords) {
            String[] words = this.nextValue(true);
            if (words == null) break;
            if (words[0].length() > 0 && words[0].charAt(0) == '(') {
                ++this.braces;
                this.currentPos = this.currentPos - words[0].length() + 1;
                Object subCondition = this.extractConditions(null);
                if (!this.jumpWhiteSpaces() || this.text.charAt(this.currentPos) == ')') {
                    --this.braces;
                }
                if (this.currentPos > -1) {
                    ++this.currentPos;
                }
                result[i] = subCondition;
            } else if (words[0].charAt(0) == '[') {
                this.currentPos -= words[0].length();
                ArrayList<String> stringItems = new ArrayList<String>();
                this.currentPos = OStringSerializerHelper.getCollection(this.text, this.currentPos, stringItems);
                if (((String)stringItems.get(0)).charAt(0) == '[') {
                    ArrayList<List<Object>> coll = new ArrayList<List<Object>>();
                    for (String stringItem : stringItems) {
                        ArrayList<String> stringSubItems = new ArrayList<String>();
                        OStringSerializerHelper.getCollection(stringItem, 0, stringSubItems);
                        coll.add(this.convertCollectionItems(stringSubItems));
                    }
                    result[i] = coll;
                } else {
                    result[i] = this.convertCollectionItems(stringItems);
                }
                ++this.currentPos;
            } else if (words[0].startsWith("ALL(")) {
                result[i] = new OSQLFilterItemFieldAll(this, words[1]);
            } else if (words[0].startsWith("ANY(")) {
                result[i] = new OSQLFilterItemFieldAny(this, words[1]);
            } else {
                int openParenthesis;
                if (words[0].equals("NOT")) {
                    if (iAllowOperator) {
                        return new OQueryOperatorNot();
                    }
                    String[] nextWord = this.nextValue(true);
                    if (nextWord != null && nextWord.length == 2) {
                        words[1] = String.valueOf(words[1]) + " " + nextWord[1];
                        if (words[1].endsWith(")")) {
                            words[1] = words[1].substring(0, words[1].length() - 1);
                        }
                    }
                }
                if (words[1].endsWith(")") && (openParenthesis = words[1].indexOf(40)) == -1) {
                    words[1] = words[1].substring(0, words[1].length() - 1);
                }
                result[i] = OSQLHelper.parseValue(this, this, words[1], this.context);
            }
            ++i;
        }
        return iExpectedWords == 1 ? result[0] : result;
    }

    private List<Object> convertCollectionItems(List<String> stringItems) {
        ArrayList<Object> coll = new ArrayList<Object>();
        for (String s : stringItems) {
            coll.add(OSQLHelper.parseValue(this, this, s, this.context));
        }
        return coll;
    }

    public OSQLFilterCondition getRootCondition() {
        return this.rootCondition;
    }

    private String[] nextValue(boolean iAdvanceWhenNotFound) {
        if (!this.jumpWhiteSpaces()) {
            return null;
        }
        int begin = this.currentPos;
        char stringBeginCharacter = ' ';
        int openBraces = 0;
        int openBraket = 0;
        boolean escaped = false;
        boolean escapingOn = false;
        while (this.currentPos < this.text.length()) {
            block17: {
                char c;
                block18: {
                    block19: {
                        block16: {
                            c = this.text.charAt(this.currentPos);
                            if (stringBeginCharacter != 32 || c != '\"' && c != '\'') break block16;
                            stringBeginCharacter = c;
                            break block17;
                        }
                        if (stringBeginCharacter == 32) break block18;
                        if (c != '\\') break block19;
                        escapingOn = true;
                        escaped = true;
                        break block17;
                    }
                    if (c == stringBeginCharacter && !escapingOn) {
                        stringBeginCharacter = ' ';
                        if (openBraket == 0 && openBraces == 0) {
                            if (!iAdvanceWhenNotFound) break;
                            ++this.currentPos;
                            break;
                        }
                    }
                    if (!escapingOn) break block17;
                    escapingOn = false;
                    break block17;
                }
                if (c != '#' || this.currentPos != begin) {
                    if (c == '(') {
                        ++openBraces;
                    } else if (c == ')' && openBraces > 0) {
                        --openBraces;
                    } else if (c == '[') {
                        ++openBraket;
                    } else if (c == ']') {
                        if (--openBraket == 0) {
                            // empty if block
                        }
                    } else {
                        if (c == ' ' && openBraces == 0) break;
                        if (!Character.isLetter(c) && !Character.isDigit(c) && c != '.' && c != '$' && c != ':' && c != '-' && c != '_' && c != '+' && c != '@' && openBraces == 0 && openBraket == 0) {
                            if (!iAdvanceWhenNotFound) break;
                            ++this.currentPos;
                            break;
                        }
                    }
                }
            }
            ++this.currentPos;
        }
        if (escaped) {
            return new String[]{OStringSerializerHelper.decode(this.textUpperCase.substring(begin, this.currentPos)), OStringSerializerHelper.decode(this.text.substring(begin, this.currentPos))};
        }
        return new String[]{this.textUpperCase.substring(begin, this.currentPos), this.text.substring(begin, this.currentPos)};
    }

    private String nextWord(boolean iForceUpperCase, String iSeparators) {
        StringBuilder word = new StringBuilder();
        this.currentPos = OSQLHelper.nextWord(this.text, this.textUpperCase, this.currentPos, word, iForceUpperCase, iSeparators);
        return word.toString();
    }

    private boolean jumpWhiteSpaces() {
        this.currentPos = OStringParser.jumpWhiteSpaces(this.text, this.currentPos);
        return this.currentPos > -1;
    }

    public String toString() {
        if (this.rootCondition != null) {
            return "Parsed: " + this.rootCondition.toString();
        }
        return "Unparsed: " + this.text;
    }

    public void bindParameters(Map<Object, Object> iArgs) {
        if (this.parameterItems == null || iArgs == null || iArgs.size() == 0) {
            return;
        }
        block0: for (Map.Entry<Object, Object> entry : iArgs.entrySet()) {
            if (entry.getKey() instanceof Integer) {
                this.parameterItems.get((Integer)entry.getKey()).setValue(entry.setValue(entry.getValue()));
                continue;
            }
            String paramName = entry.getKey().toString();
            for (OSQLFilterItemParameter value : this.parameterItems) {
                if (!value.getName().equalsIgnoreCase(paramName)) continue;
                value.setValue(entry.getValue());
                continue block0;
            }
        }
    }

    public OSQLFilterItemParameter addParameter(String iName) {
        String name;
        if (iName.charAt(0) == ':') {
            name = iName.substring(1);
            if (!OStringSerializerHelper.isAlphanumeric(name)) {
                throw new OQueryParsingException("Parameter name '" + name + "' is invalid, only alphanumeric characters are allowed");
            }
        } else {
            name = iName;
        }
        OSQLFilterItemParameter param = new OSQLFilterItemParameter(name);
        if (this.parameterItems == null) {
            this.parameterItems = new ArrayList<OSQLFilterItemParameter>();
        }
        this.parameterItems.add(param);
        return param;
    }

    public void setRootCondition(OSQLFilterCondition iCondition) {
        this.rootCondition = iCondition;
    }
}

