/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions;

import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunction;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionFactory;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDifference;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionDistinct;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionIntersect;
import com.orientechnologies.orient.core.sql.functions.coll.OSQLFunctionUnion;
import com.orientechnologies.orient.core.sql.functions.geo.OSQLFunctionDistance;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionAverage;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMax;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionMin;
import com.orientechnologies.orient.core.sql.functions.math.OSQLFunctionSum;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionCount;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionDate;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionFormat;
import com.orientechnologies.orient.core.sql.functions.misc.OSQLFunctionSysdate;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ODefaultSQLFunctionFactory
implements OSQLFunctionFactory {
    private static final Map<String, Object> FUNCTIONS = new HashMap<String, Object>();

    static {
        FUNCTIONS.put("format".toUpperCase(Locale.ENGLISH), new OSQLFunctionFormat());
        FUNCTIONS.put("date".toUpperCase(Locale.ENGLISH), OSQLFunctionDate.class);
        FUNCTIONS.put("sysdate".toUpperCase(Locale.ENGLISH), OSQLFunctionSysdate.class);
        FUNCTIONS.put("count".toUpperCase(Locale.ENGLISH), OSQLFunctionCount.class);
        FUNCTIONS.put("distinct".toUpperCase(Locale.ENGLISH), OSQLFunctionDistinct.class);
        FUNCTIONS.put("union".toUpperCase(Locale.ENGLISH), OSQLFunctionUnion.class);
        FUNCTIONS.put("intersect".toUpperCase(Locale.ENGLISH), OSQLFunctionIntersect.class);
        FUNCTIONS.put("difference".toUpperCase(Locale.ENGLISH), OSQLFunctionDifference.class);
        FUNCTIONS.put("min".toUpperCase(Locale.ENGLISH), OSQLFunctionMin.class);
        FUNCTIONS.put("max".toUpperCase(Locale.ENGLISH), OSQLFunctionMax.class);
        FUNCTIONS.put("sum".toUpperCase(Locale.ENGLISH), OSQLFunctionSum.class);
        FUNCTIONS.put("avg".toUpperCase(Locale.ENGLISH), OSQLFunctionAverage.class);
        FUNCTIONS.put("distance".toUpperCase(Locale.ENGLISH), new OSQLFunctionDistance());
    }

    @Override
    public Set<String> getFunctionNames() {
        return FUNCTIONS.keySet();
    }

    @Override
    public OSQLFunction createFunction(String name) {
        Object obj = FUNCTIONS.get(name);
        if (obj == null) {
            throw new OCommandExecutionException("Unknowned function name :" + name);
        }
        if (obj instanceof OSQLFunction) {
            return (OSQLFunction)obj;
        }
        Class clazz = (Class)obj;
        try {
            return (OSQLFunction)clazz.newInstance();
        }
        catch (Exception e) {
            throw new OCommandExecutionException("Error in creation of function " + name + "(). Probably there is not an empty constructor or the constructor generates errors", e);
        }
    }
}

