/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OQueryParsingException;
import com.orientechnologies.orient.core.sql.OCommandSQLParsingException;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OSQLFunctionDate
extends OSQLFunctionAbstract {
    public static final String NAME = "date";
    private Date date = new Date();
    private SimpleDateFormat format;

    public OSQLFunctionDate() {
        super(NAME, 0, 2);
    }

    public Object execute(OIdentifiable iCurrentRecord, Object[] iParameters, OCommandExecutor iRequester) {
        if (iParameters.length == 0) {
            return this.date;
        }
        if (iParameters.length != 2) {
            throw new OCommandSQLParsingException(this.getSyntax());
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat((String)iParameters[1]);
        }
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            try {
                return this.format.parse((String)iParameters[0]);
            }
            catch (ParseException e) {
                throw new OQueryParsingException("Error on formatting date '" + iParameters[0] + "' using the format: " + iParameters[1], e);
            }
        }
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    public String getSyntax() {
        return "Syntax error: date([<date-as-string>, <format>])";
    }

    public Object getResult() {
        this.format = null;
        return null;
    }
}

