/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.functions.misc;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OSQLFunctionSysdate
extends OSQLFunctionAbstract {
    public static final String NAME = "sysdate";
    private final Date now = new Date();
    private SimpleDateFormat format;

    public OSQLFunctionSysdate() {
        super(NAME, 0, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(OIdentifiable iCurrentRecord, Object[] iParameters, OCommandExecutor iRequester) {
        if (iParameters.length == 0) {
            return this.now;
        }
        if (this.format == null) {
            this.format = new SimpleDateFormat((String)iParameters[0]);
        }
        SimpleDateFormat simpleDateFormat = this.format;
        synchronized (simpleDateFormat) {
            return this.format.format(this.now);
        }
    }

    public boolean aggregateResults(Object[] configuredParameters) {
        return false;
    }

    public String getSyntax() {
        return "Syntax error: sysdate([<format>])";
    }

    public Object getResult() {
        this.format = null;
        return null;
    }
}

