/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexDefinitionMultiValue;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OPropertyMapIndexDefinition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorContainsKey
extends OQueryOperatorEqualityNotNulls {
    public OQueryOperatorContainsKey() {
        super("CONTAINSKEY", 5, false);
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iLeft instanceof Map) {
            Map map = (Map)iLeft;
            return map.containsKey(iRight);
        }
        if (iRight instanceof Map) {
            Map map = (Map)iRight;
            return map.containsKey(iLeft);
        }
        return false;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.INDEX_METHOD;
    }

    @Override
    public Collection<OIdentifiable> executeIndexQuery(OIndex<?> index, List<Object> keyParams, int fetchLimit) {
        OIndexDefinition indexDefinition = index.getDefinition();
        if (!(index.getDefinition() instanceof OPropertyMapIndexDefinition) || ((OPropertyMapIndexDefinition)index.getDefinition()).getIndexBy() != OPropertyMapIndexDefinition.INDEX_BY.KEY) {
            return null;
        }
        OIndexInternal<?> internalIndex = index.getInternal();
        if (!internalIndex.canBeUsedInEqualityOperators()) {
            return null;
        }
        if (indexDefinition.getParamCount() == 1) {
            Object key = indexDefinition instanceof OIndexDefinitionMultiValue ? ((OIndexDefinitionMultiValue)indexDefinition).createSingleValue(keyParams.get(0)) : indexDefinition.createValue(keyParams);
            if (key == null) {
                return null;
            }
            Object indexResult = index.get(key);
            if (indexResult instanceof Collection) {
                return (Collection)indexResult;
            }
            return indexResult == null ? null : Collections.singletonList((OIdentifiable)indexResult);
        }
        return null;
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

