/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;

public class OQueryOperatorOr
extends OQueryOperator {
    public OQueryOperatorOr() {
        super("OR", 3, false);
    }

    public Object evaluateRecord(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        if (iLeft == null) {
            return false;
        }
        if (!((Boolean)iLeft).booleanValue() && !((Boolean)iRight).booleanValue()) {
            return false;
        }
        return true;
    }

    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        if (iLeft == null || iRight == null) {
            return OIndexReuseType.NO_INDEX;
        }
        return OIndexReuseType.INDEX_UNION;
    }

    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        ORID leftRange = iLeft instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iLeft).getBeginRidRange() : null;
        ORID rightRange = iRight instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iRight).getBeginRidRange() : null;
        if (leftRange == null || rightRange == null) {
            return null;
        }
        return leftRange.compareTo(rightRange) <= 0 ? leftRange : rightRange;
    }

    public ORID getEndRidRange(Object iLeft, Object iRight) {
        ORID leftRange = iLeft instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iLeft).getEndRidRange() : null;
        ORID rightRange = iRight instanceof OSQLFilterCondition ? ((OSQLFilterCondition)iRight).getEndRidRange() : null;
        if (leftRange == null || rightRange == null) {
            return null;
        }
        return leftRange.compareTo(rightRange) >= 0 ? leftRange : rightRange;
    }
}

