/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.sql.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.query.OQueryRuntimeValueMulti;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.operator.OIndexReuseType;
import com.orientechnologies.orient.core.sql.operator.OQueryOperator;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorEqualityNotNulls;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OQueryOperatorTraverse
extends OQueryOperatorEqualityNotNulls {
    private int startDeepLevel = 0;
    private int endDeepLevel = -1;
    private String[] cfgFields;

    public OQueryOperatorTraverse() {
        super("TRAVERSE", 5, false);
    }

    public OQueryOperatorTraverse(int startDeepLevel, int endDeepLevel, String[] iFieldList) {
        this();
        this.startDeepLevel = startDeepLevel;
        this.endDeepLevel = endDeepLevel;
        this.cfgFields = iFieldList;
    }

    @Override
    public String getSyntax() {
        return "<left> TRAVERSE[(<begin-deep-level> [,<maximum-deep-level> [,<fields>]] )] ( <conditions> )";
    }

    @Override
    protected boolean evaluateExpression(OIdentifiable iRecord, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext) {
        Object target;
        OSQLFilterCondition condition;
        if (iCondition.getLeft() instanceof OSQLFilterCondition) {
            condition = (OSQLFilterCondition)iCondition.getLeft();
            target = iRight;
        } else {
            condition = (OSQLFilterCondition)iCondition.getRight();
            target = iLeft;
        }
        HashSet<ORID> evaluatedRecords = new HashSet<ORID>();
        return this.traverse(target, condition, 0, evaluatedRecords, iContext);
    }

    private boolean traverse(Object iTarget, OSQLFilterCondition iCondition, int iLevel, Set<ORID> iEvaluatedRecords, OCommandContext iContext) {
        block23: {
            block25: {
                block24: {
                    block22: {
                        if (this.endDeepLevel > -1 && iLevel > this.endDeepLevel) {
                            return false;
                        }
                        if (iTarget instanceof ORID) {
                            if (iEvaluatedRecords.contains(iTarget)) {
                                return false;
                            }
                            iTarget = new ODocument((ORID)iTarget);
                        } else if (iTarget instanceof ODocument && iEvaluatedRecords.contains(((ODocument)iTarget).getIdentity())) {
                            return false;
                        }
                        if (!(iTarget instanceof ODocument)) break block22;
                        ODocument target = (ODocument)iTarget;
                        iEvaluatedRecords.add(target.getIdentity());
                        if (target.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
                            try {
                                target.load();
                            }
                            catch (ORecordNotFoundException e) {
                                return false;
                            }
                        }
                        if (iLevel >= this.startDeepLevel && (Boolean)iCondition.evaluate(target, iContext) == Boolean.TRUE) {
                            return true;
                        }
                        String[] stringArray = this.cfgFields;
                        int n = this.cfgFields.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String fieldName;
                            int n3;
                            int n4;
                            String[] stringArray2;
                            String cfgField = stringArray[n2];
                            if (cfgField.equalsIgnoreCase("ANY()")) {
                                stringArray2 = target.fieldNames();
                                n4 = stringArray2.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    fieldName = stringArray2[n3];
                                    if (this.traverse(target.rawField(fieldName), iCondition, iLevel + 1, iEvaluatedRecords, iContext)) {
                                        return true;
                                    }
                                    ++n3;
                                }
                            } else {
                                if (cfgField.equalsIgnoreCase("ANY()")) {
                                    stringArray2 = target.fieldNames();
                                    n4 = stringArray2.length;
                                    n3 = 0;
                                    while (n3 < n4) {
                                        fieldName = stringArray2[n3];
                                        if (!this.traverse(target.rawField(fieldName), iCondition, iLevel + 1, iEvaluatedRecords, iContext)) {
                                            return false;
                                        }
                                        ++n3;
                                    }
                                    return true;
                                }
                                if (this.traverse(target.rawField(cfgField), iCondition, iLevel + 1, iEvaluatedRecords, iContext)) {
                                    return true;
                                }
                            }
                            ++n2;
                        }
                        break block23;
                    }
                    if (!(iTarget instanceof OQueryRuntimeValueMulti)) break block24;
                    OQueryRuntimeValueMulti multi = (OQueryRuntimeValueMulti)iTarget;
                    Object[] objectArray = multi.values;
                    int n = multi.values.length;
                    int n5 = 0;
                    while (n5 < n) {
                        Object o = objectArray[n5];
                        if (this.traverse(o, iCondition, iLevel + 1, iEvaluatedRecords, iContext) == Boolean.TRUE.booleanValue()) {
                            return true;
                        }
                        ++n5;
                    }
                    break block23;
                }
                if (!(iTarget instanceof Collection)) break block25;
                Collection collection = (Collection)iTarget;
                for (Object o : collection) {
                    if (this.traverse(o, iCondition, iLevel + 1, iEvaluatedRecords, iContext) != Boolean.TRUE.booleanValue()) continue;
                    return true;
                }
                break block23;
            }
            if (!(iTarget instanceof Map)) break block23;
            Map map = (Map)iTarget;
            for (Object o : map.values()) {
                if (this.traverse(o, iCondition, iLevel + 1, iEvaluatedRecords, iContext) != Boolean.TRUE.booleanValue()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public OQueryOperator configure(List<String> iParams) {
        if (iParams == null) {
            return this;
        }
        int start = !iParams.isEmpty() ? Integer.parseInt(iParams.get(0)) : this.startDeepLevel;
        int end = iParams.size() > 1 ? Integer.parseInt(iParams.get(1)) : this.endDeepLevel;
        String[] fields = new String[]{"any()"};
        if (iParams.size() > 2) {
            String f = iParams.get(2);
            if (f.startsWith("'") || f.startsWith("\"")) {
                f = f.substring(1, f.length() - 1);
            }
            fields = f.split(",");
        }
        return new OQueryOperatorTraverse(start, end, fields);
    }

    public int getStartDeepLevel() {
        return this.startDeepLevel;
    }

    public int getEndDeepLevel() {
        return this.endDeepLevel;
    }

    public String[] getCfgFields() {
        return this.cfgFields;
    }

    @Override
    public OIndexReuseType getIndexReuseType(Object iLeft, Object iRight) {
        return OIndexReuseType.NO_INDEX;
    }

    @Override
    public String toString() {
        return String.format("%s(%d,%d,%s)", this.keyword, this.startDeepLevel, this.endDeepLevel, Arrays.toString(this.cfgFields));
    }

    @Override
    public ORID getBeginRidRange(Object iLeft, Object iRight) {
        return null;
    }

    @Override
    public ORID getEndRidRange(Object iLeft, Object iRight) {
        return null;
    }
}

