/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.storage.OCluster;
import java.io.IOException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OClusterPositionIterator
implements Iterator<Long> {
    private final OCluster cluster;
    private long current;
    private final long max;

    public OClusterPositionIterator(OCluster iCluster) {
        this.cluster = iCluster;
        this.current = this.cluster.getFirstEntryPosition();
        this.max = this.cluster.getLastEntryPosition();
    }

    public OClusterPositionIterator(OCluster iCluster, long iBeginRange, long iEndRange) throws IOException {
        this.cluster = iCluster;
        this.current = iBeginRange;
        this.max = iEndRange > -1L ? iEndRange : this.cluster.getLastEntryPosition();
    }

    @Override
    public boolean hasNext() {
        return this.max > -1L && this.current <= this.max;
    }

    @Override
    public Long next() {
        return this.current++;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

