/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.config.OStorageMemoryClusterConfiguration;
import com.orientechnologies.orient.core.config.OStoragePhysicalClusterConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterFactory;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import java.util.Arrays;

public class ODefaultClusterFactory
implements OClusterFactory {
    protected static final String[] TYPES = new String[]{"PHYSICAL", "MEMORY"};

    public OCluster createCluster(String iType) {
        if (iType.equalsIgnoreCase("PHYSICAL")) {
            return new OClusterLocal();
        }
        if (iType.equalsIgnoreCase("MEMORY")) {
            return new OClusterMemory();
        }
        OLogManager.instance().exception("Cluster type '" + iType + "' is not supported. Supported types are: " + Arrays.toString(TYPES), null, OStorageException.class, new Object[0]);
        return null;
    }

    public OCluster createCluster(OStorageClusterConfiguration iConfig) {
        if (iConfig instanceof OStoragePhysicalClusterConfiguration) {
            return new OClusterLocal();
        }
        if (iConfig instanceof OStorageMemoryClusterConfiguration) {
            return new OClusterMemory();
        }
        OLogManager.instance().exception("Cluster type '" + iConfig + "' is not supported. Supported types are: " + Arrays.toString(TYPES), null, OStorageException.class, new Object[0]);
        return null;
    }

    public String[] getSupported() {
        return TYPES;
    }
}

