/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.serialization.OBinaryProtocol;
import com.orientechnologies.orient.core.serialization.OSerializableStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPhysicalPosition
implements OSerializableStream,
Comparable<OPhysicalPosition> {
    public long clusterPosition;
    public int dataSegmentId;
    public long dataSegmentPos;
    public byte recordType;
    public int recordVersion = 0;
    public int recordSize;
    private static final int BINARY_SIZE = 29;

    public OPhysicalPosition() {
    }

    public OPhysicalPosition(long iClusterPosition) {
        this.clusterPosition = iClusterPosition;
    }

    public OPhysicalPosition(int iDataSegmentId, long iDataSegmentPosition, byte iRecordType) {
        this.dataSegmentId = iDataSegmentId;
        this.dataSegmentPos = iDataSegmentPosition;
        this.recordType = iRecordType;
    }

    public void copyTo(OPhysicalPosition iDest) {
        iDest.clusterPosition = this.clusterPosition;
        iDest.dataSegmentId = this.dataSegmentId;
        iDest.dataSegmentPos = this.dataSegmentPos;
        iDest.recordType = this.recordType;
        iDest.recordVersion = this.recordVersion;
        iDest.recordSize = this.recordSize;
    }

    public void copyFrom(OPhysicalPosition iSource) {
        iSource.copyTo(this);
    }

    public String toString() {
        return "cluster-pos=" + this.clusterPosition + " data-segment-id=" + this.dataSegmentId + " data-segment-pos=" + this.dataSegmentPos + " record-type=" + this.recordType + " record-size=" + this.recordSize + " v=" + this.recordVersion;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        int pos = 0;
        this.clusterPosition = OBinaryProtocol.bytes2long(iStream, pos);
        this.dataSegmentId = OBinaryProtocol.bytes2int(iStream, pos += 8);
        this.dataSegmentPos = OBinaryProtocol.bytes2long(iStream, pos += 4);
        this.recordType = iStream[pos += 8];
        this.recordSize = OBinaryProtocol.bytes2int(iStream, ++pos);
        this.recordVersion = OBinaryProtocol.bytes2int(iStream, pos += 4);
        return this;
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        byte[] buffer = new byte[29];
        int pos = 0;
        OBinaryProtocol.long2bytes(this.clusterPosition, buffer, pos);
        OBinaryProtocol.int2bytes(this.dataSegmentId, buffer, pos += 8);
        OBinaryProtocol.long2bytes(this.dataSegmentPos, buffer, pos += 4);
        buffer[pos += 8] = this.recordType;
        OBinaryProtocol.int2bytes(this.recordSize, buffer, ++pos);
        OBinaryProtocol.int2bytes(this.recordVersion, buffer, pos += 4);
        return buffer;
    }

    @Override
    public int compareTo(OPhysicalPosition iOther) {
        return (int)(this.dataSegmentPos - iOther.dataSegmentPos);
    }
}

