/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage;

import com.orientechnologies.common.concur.resource.OCloseable;
import com.orientechnologies.common.concur.resource.OSharedContainerImpl;
import com.orientechnologies.common.concur.resource.OSharedResource;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.common.concur.resource.OSharedResourceAdaptiveExternal;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OLevel2RecordCache;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OStorageAbstract
extends OSharedContainerImpl
implements OStorage {
    protected final String url;
    protected final String mode;
    protected OStorageConfiguration configuration;
    protected String name;
    protected AtomicLong version = new AtomicLong();
    protected OLevel2RecordCache level2Cache;
    protected volatile STATUS status = STATUS.CLOSED;
    protected OSharedResourceAdaptiveExternal lock = new OSharedResourceAdaptiveExternal(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean(), 0, true);

    public OStorageAbstract(String iName, String iURL, String iMode) {
        this.name = OStringSerializerHelper.contains(iName, '/') ? iName.substring(iName.lastIndexOf("/") + 1) : iName;
        if (OStringSerializerHelper.contains(iName, ',')) {
            throw new IllegalArgumentException("Invalid character in storage name: " + this.name);
        }
        this.level2Cache = new OLevel2RecordCache(this);
        this.level2Cache.startup();
        this.url = iURL;
        this.mode = iMode;
    }

    @Override
    public OStorageConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public boolean isClosed() {
        return this.status == STATUS.CLOSED;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        return ppos != null && ppos.recordVersion > -1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OLevel2RecordCache getLevel2Cache() {
        return this.level2Cache;
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public void close() {
        this.close(false);
    }

    @Override
    public void close(boolean iForce) {
        if (!this.checkForClose(iForce)) {
            return;
        }
        for (Object resource : this.sharedResources.values()) {
            if (resource instanceof OSharedResource) {
                ((OSharedResource)resource).releaseExclusiveLock();
            }
            if (!(resource instanceof OCloseable)) continue;
            ((OCloseable)resource).close();
        }
        this.sharedResources.clear();
        Orient.instance().unregisterStorage(this);
    }

    @Override
    public long getVersion() {
        return this.version.get();
    }

    @Override
    public boolean dropCluster(String iClusterName) {
        return this.dropCluster(this.getClusterIdByName(iClusterName));
    }

    protected boolean checkForClose(boolean iForce) {
        int remainingUsers;
        if (this.status == STATUS.CLOSED) {
            return false;
        }
        int n = remainingUsers = this.getUsers() > 0 ? this.removeUser() : 0;
        return iForce || !OGlobalConfiguration.STORAGE_KEEP_OPEN.getValueAsBoolean() && remainingUsers == 0;
    }

    @Override
    public int getUsers() {
        return this.lock.getUsers();
    }

    @Override
    public int addUser() {
        return this.lock.addUser();
    }

    @Override
    public int removeUser() {
        return this.lock.removeUser();
    }

    public OSharedResourceAdaptive getLock() {
        return this.lock;
    }

    @Override
    public long countRecords() {
        long tot = 0L;
        for (OCluster oCluster : this.getClusterInstances()) {
            if (oCluster == null) continue;
            tot += oCluster.getEntries();
        }
        return tot;
    }

    @Override
    public <V> V callInLock(Callable<V> iCallable, boolean iExclusiveLock) {
        if (iExclusiveLock) {
            this.lock.acquireExclusiveLock();
        } else {
            this.lock.acquireSharedLock();
        }
        try {
            V v = iCallable.call();
            return v;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OException("Error on nested call in lock", e);
        }
        finally {
            if (iExclusiveLock) {
                this.lock.releaseExclusiveLock();
            } else {
                this.lock.releaseSharedLock();
            }
        }
    }

    public String toString() {
        return this.url != null ? this.url : "?";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum STATUS {
        CLOSED,
        OPEN,
        CLOSING;

    }
}

