/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.fs;

import com.orientechnologies.common.concur.resource.OSharedResourceAbstract;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.fs.OFileMMap;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMMapBufferEntry
extends OSharedResourceAbstract
implements Comparable<OMMapBufferEntry> {
    private static final int FORCE_DELAY;
    private static final int FORCE_RETRY;
    static Class<?> sunClass;
    OFileMMap file;
    MappedByteBuffer buffer;
    long beginOffset;
    int size;
    long counter;
    volatile boolean dirty;

    static {
        sunClass = null;
        FORCE_DELAY = OGlobalConfiguration.FILE_MMAP_FORCE_DELAY.getValueAsInteger();
        FORCE_RETRY = OGlobalConfiguration.FILE_MMAP_FORCE_RETRY.getValueAsInteger();
        try {
            sunClass = Class.forName("sun.nio.ch.DirectBuffer");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public OMMapBufferEntry(OFileMMap iFile, MappedByteBuffer buffer, long beginOffset, int size) {
        this.file = iFile;
        this.buffer = buffer;
        this.beginOffset = beginOffset;
        this.size = size;
        this.counter = 0L;
        this.dirty = false;
    }

    boolean flush() {
        if (!this.dirty) {
            return true;
        }
        this.acquireExclusiveLock();
        try {
            long timer = OProfiler.getInstance().startChrono();
            int i = 0;
            while (i < FORCE_RETRY) {
                try {
                    this.buffer.force();
                    this.dirty = false;
                    break;
                }
                catch (Exception e) {
                    OLogManager.instance().debug((Object)this, "Cannot write memory buffer to disk. Retrying (" + (i + 1) + "/" + FORCE_RETRY + ")...", new Object[0]);
                    OMemoryWatchDog.freeMemory(FORCE_DELAY);
                    ++i;
                }
            }
            if (this.dirty) {
                OLogManager.instance().debug((Object)this, "Cannot commit memory buffer to disk after %d retries", FORCE_RETRY);
            } else {
                OProfiler.getInstance().updateCounter("OMMapManager.pagesCommitted", 1L);
            }
            OProfiler.getInstance().stopChrono("OMMapManager.commitPages", timer);
            boolean bl = !this.dirty;
            return bl;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("OMMapBufferEntry [file=").append(this.file).append(", beginOffset=").append(this.beginOffset).append(", size=").append(this.size).append("]");
        return builder.toString();
    }

    void close() {
        this.acquireExclusiveLock();
        try {
            if (this.buffer != null) {
                if (this.dirty) {
                    this.buffer.force();
                }
                if (sunClass != null) {
                    try {
                        Method m = sunClass.getMethod("cleaner", new Class[0]);
                        Object cleaner = m.invoke((Object)this.buffer, new Object[0]);
                        cleaner.getClass().getMethod("clean", new Class[0]).invoke(cleaner, new Object[0]);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error((Object)this, "Error on calling Sun's MMap buffer clean", (Throwable)e, new Object[0]);
                    }
                }
                this.buffer = null;
            }
            this.counter = 0L;
            this.file = null;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public int compareTo(OMMapBufferEntry iOther) {
        return (int)(this.beginOffset - iOther.beginOffset);
    }

    boolean isValid() {
        return this.buffer != null;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void setDirty() {
        this.dirty = true;
    }

    void acquire() {
        super.acquireExclusiveLock();
    }

    void release() {
        super.releaseExclusiveLock();
    }
}

