/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.memory.OMemoryWatchDog;
import com.orientechnologies.orient.core.storage.impl.local.OClusterLocal;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.File;
import java.io.IOException;

public class OClusterLocalHole
extends OSingleFileSegment {
    private static final int DEF_START_SIZE = 262144;
    private static final int RECORD_SIZE = 8;
    private OClusterLocal owner;

    public OClusterLocalHole(OClusterLocal iClusterLocal, OStorageLocal iStorage, OStorageFileConfiguration iConfig) throws IOException {
        super(iStorage, iConfig);
        this.owner = iClusterLocal;
    }

    public void defrag() throws IOException {
        OLogManager.instance().debug((Object)this, "Starting to defragment the segment %s of size=%d and filled=%d", this.file, this.file.getFileSize(), this.file.getFilledUpTo());
        OLogManager.instance().debug((Object)this, "Defragmentation ended for segment %s. Current size=%d and filled=%d", this.file, this.file.getFileSize(), this.file.getFilledUpTo());
    }

    public void create() throws IOException {
        this.file.create(262144);
    }

    public long pushPosition(long iPosition) throws IOException {
        int position = this.getHoles() * 8;
        this.file.allocateSpace(8);
        this.file.writeLong(position, iPosition);
        if (OLogManager.instance().isDebugEnabled()) {
            OLogManager.instance().debug((Object)this, "Pushed new hole %s/#%d -> #%d:%d", this.owner.getName(), position / 8, this.owner.getId(), iPosition);
        }
        return position;
    }

    public long popLastEntryPosition() throws IOException {
        int pos = this.getHoles() - 1;
        while (pos >= 0) {
            long recycledPosition = this.file.readLong(pos * 8);
            if (recycledPosition > -1L) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Recycled hole %s/#%d -> #%d:%d", this.owner.getName(), pos, this.owner.getId(), recycledPosition);
                }
                this.file.removeTail((this.getHoles() - pos) * 8);
                return recycledPosition;
            }
            --pos;
        }
        return -1L;
    }

    public long getEntryPosition(int iPosition) throws IOException {
        return this.file.readLong(iPosition * 8);
    }

    public boolean removeEntryWithPosition(long iPosition) throws IOException {
        boolean canShrink = true;
        int pos = this.getHoles() - 1;
        while (pos >= 0) {
            long recycledPosition = this.file.readLong(pos * 8);
            if (recycledPosition == iPosition) {
                if (OLogManager.instance().isDebugEnabled()) {
                    OLogManager.instance().debug((Object)this, "Removing hole #%d containing the position #%d:%d", pos, this.owner.getId(), recycledPosition);
                }
                this.file.writeLong(pos * 8, -1L);
                if (canShrink) {
                    this.file.removeTail((this.getHoles() - pos) * 8);
                }
                return true;
            }
            if (iPosition != -1L) {
                canShrink = false;
            }
            --pos;
        }
        return false;
    }

    public void rename(String iOldName, String iNewName) {
        String osFileName = this.file.getName();
        if (osFileName.startsWith(iOldName)) {
            File newFile = new File(String.valueOf(this.storage.getStoragePath()) + "/" + iNewName + osFileName.substring(osFileName.lastIndexOf(iOldName) + iOldName.length()));
            boolean renamed = this.file.renameTo(newFile);
            while (!renamed) {
                OMemoryWatchDog.freeMemory(100L);
                renamed = this.file.renameTo(newFile);
            }
        }
    }

    public int getHoles() {
        return this.file.getFilledUpTo() / 8;
    }
}

