/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local;

import com.orientechnologies.common.collection.OMVRBTreeMemory;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.config.OStorageFileConfiguration;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.OSingleFileSegment;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class ODataLocalHole
extends OSingleFileSegment {
    private static final int DEF_START_SIZE = 262144;
    private static final int RECORD_SIZE = 12;
    private int maxHoleSize = -1;
    private final List<Integer> freeHoles = new ArrayList<Integer>();
    private final ODataHoleInfo cursor = new ODataHoleInfo();
    private final List<ODataHoleInfo> availableHolesList = new ArrayList<ODataHoleInfo>();
    private final OMVRBTreeMemory<ODataHoleInfo, ODataHoleInfo> availableHolesBySize;
    private final OMVRBTreeMemory<ODataHoleInfo, ODataHoleInfo> availableHolesByPosition;
    private final String PROFILER_DATA_RECYCLED_COMPLETE = "storage." + this.storage.getName() + ".data.recycled.complete";
    private final String PROFILER_DATA_RECYCLED_PARTIAL = "storage." + this.storage.getName() + ".data.recycled.partial";
    private final String PROFILER_DATA_RECYCLED_NOTFOUND = "storage." + this.storage.getName() + ".data.recycled.notFound";
    private final String PROFILER_DATA_HOLE_CREATE = "storage." + this.storage.getName() + ".data.createHole";
    private final String PROFILER_DATA_HOLE_UPDATE = "storage." + this.storage.getName() + ".data.updateHole";

    public ODataLocalHole(OStorageLocal iStorage, OStorageFileConfiguration iConfig) throws IOException {
        super(iStorage, iConfig);
        this.availableHolesBySize = new OMVRBTreeMemory(512, 0.7f);
        this.availableHolesByPosition = new OMVRBTreeMemory(new Comparator<ODataHoleInfo>(){

            @Override
            public int compare(ODataHoleInfo o1, ODataHoleInfo o2) {
                if (o1.dataOffset == o2.dataOffset) {
                    return 0;
                }
                if (o1.dataOffset > o2.dataOffset) {
                    return 1;
                }
                return -1;
            }
        });
    }

    public synchronized boolean open() throws IOException {
        boolean status = super.open();
        this.loadHolesInMemory();
        return status;
    }

    public synchronized void create(int iStartSize) throws IOException {
        super.create(iStartSize > -1 ? iStartSize : 262144);
    }

    public synchronized void createHole(long iRecordOffset, int iRecordSize) throws IOException {
        ODataHoleInfo hole;
        int recycledPosition;
        long timer = OProfiler.getInstance().startChrono();
        if (!this.freeHoles.isEmpty()) {
            recycledPosition = this.freeHoles.remove(0);
            hole = this.availableHolesList.get(recycledPosition);
            hole.dataOffset = iRecordOffset;
            hole.size = iRecordSize;
        } else {
            recycledPosition = this.getHoles();
            hole = new ODataHoleInfo(iRecordSize, iRecordOffset, recycledPosition);
            this.availableHolesList.add(hole);
            this.file.allocateSpace(12);
        }
        this.availableHolesBySize.put(hole, hole);
        this.availableHolesByPosition.put(hole, hole);
        if (this.maxHoleSize < iRecordSize) {
            this.maxHoleSize = iRecordSize;
        }
        long p = recycledPosition * 12;
        this.file.writeLong(p, iRecordOffset);
        this.file.writeInt(p + 8L, iRecordSize);
        OProfiler.getInstance().stopChrono(this.PROFILER_DATA_HOLE_CREATE, timer);
    }

    public synchronized ODataHoleInfo getCloserHole(long iHolePosition, int iHoleSize, long iLowerRange, long iHigherRange) {
        this.cursor.dataOffset = iHolePosition;
        ODataHoleInfo lowerHole = this.availableHolesByPosition.lowerKey(this.cursor);
        this.cursor.dataOffset = iHolePosition + (long)iHoleSize;
        ODataHoleInfo higherHole = this.availableHolesByPosition.higherKey(this.cursor);
        if (lowerHole != null && higherHole != null && lowerHole != higherHole && lowerHole.dataOffset >= higherHole.dataOffset) {
            throw new OStorageException("Found bad order in hole list: " + lowerHole + " is higher than " + higherHole);
        }
        if (lowerHole != null && lowerHole.dataOffset + (long)lowerHole.size < iLowerRange) {
            lowerHole = null;
        }
        if (higherHole != null && higherHole.dataOffset > iHigherRange) {
            higherHole = null;
        }
        ODataHoleInfo closestHole = lowerHole == higherHole ? higherHole : (lowerHole == null && higherHole != null ? higherHole : (lowerHole != null && higherHole == null ? lowerHole : (iHolePosition - (lowerHole.dataOffset + (long)lowerHole.size) > higherHole.dataOffset - iHolePosition ? higherHole : lowerHole)));
        return closestHole;
    }

    protected synchronized long popFirstAvailableHole(int iRecordSize) throws IOException {
        if (this.maxHoleSize > -1 && iRecordSize + 14 + 50 > this.maxHoleSize) {
            return -1L;
        }
        long timer = OProfiler.getInstance().startChrono();
        if (!this.availableHolesBySize.isEmpty()) {
            this.cursor.size = iRecordSize;
            ODataHoleInfo hole = (ODataHoleInfo)this.availableHolesBySize.get(this.cursor);
            if (hole != null && hole.size == iRecordSize) {
                OProfiler.getInstance().stopChrono(this.PROFILER_DATA_RECYCLED_COMPLETE, timer);
                long pos = hole.dataOffset;
                this.deleteHole(hole.holeOffset);
                return pos;
            }
            hole = (ODataHoleInfo)this.availableHolesBySize.lastKey();
            if (hole.size > iRecordSize + 14 + 50) {
                long pos = hole.dataOffset;
                OProfiler.getInstance().stopChrono(this.PROFILER_DATA_RECYCLED_PARTIAL, timer);
                this.updateHole(hole, hole.dataOffset + (long)iRecordSize, hole.size - iRecordSize);
                return pos;
            }
        }
        OProfiler.getInstance().stopChrono(this.PROFILER_DATA_RECYCLED_NOTFOUND, timer);
        return -1L;
    }

    public synchronized ODataHoleInfo getHole(int iPosition) {
        ODataHoleInfo hole = this.availableHolesList.get(iPosition);
        if (hole.dataOffset == -1L) {
            return null;
        }
        return hole;
    }

    public synchronized void updateHole(ODataHoleInfo iHole, long iNewDataOffset, int iNewRecordSize) throws IOException {
        boolean sizeChanged;
        long timer = OProfiler.getInstance().startChrono();
        boolean offsetChanged = iNewDataOffset != iHole.dataOffset;
        boolean bl = sizeChanged = iNewRecordSize != iHole.size;
        if (this.maxHoleSize < iNewRecordSize) {
            this.maxHoleSize = iNewRecordSize;
        }
        if (offsetChanged) {
            this.availableHolesByPosition.remove(iHole);
        }
        if (sizeChanged) {
            this.availableHolesBySize.remove(iHole);
        }
        if (offsetChanged) {
            iHole.dataOffset = iNewDataOffset;
        }
        if (sizeChanged) {
            iHole.size = iNewRecordSize;
        }
        if (offsetChanged) {
            this.availableHolesByPosition.put(iHole, iHole);
        }
        if (sizeChanged) {
            this.availableHolesBySize.put(iHole, iHole);
        }
        long holePosition = iHole.holeOffset * 12;
        if (offsetChanged) {
            this.file.writeLong(holePosition, iNewDataOffset);
        }
        if (sizeChanged) {
            this.file.writeInt(holePosition + 8L, iNewRecordSize);
        }
        OProfiler.getInstance().stopChrono(this.PROFILER_DATA_HOLE_UPDATE, timer);
    }

    public synchronized void deleteHole(int iHolePosition) throws IOException {
        ODataHoleInfo hole = this.availableHolesList.get(iHolePosition);
        this.availableHolesBySize.remove(hole);
        this.availableHolesByPosition.remove(hole);
        hole.dataOffset = -1L;
        this.freeHoles.add(iHolePosition);
        this.file.writeLong(iHolePosition *= 12, -1L);
    }

    public synchronized int getHoles() {
        return this.file.getFilledUpTo() / 12;
    }

    private void loadHolesInMemory() throws IOException {
        int holes = this.getHoles();
        int pos = 0;
        while (pos < holes) {
            long dataOffset = this.file.readLong(pos * 12);
            int recordSize = this.file.readInt(pos * 12 + 8);
            ODataHoleInfo hole = new ODataHoleInfo(recordSize, dataOffset, pos);
            this.availableHolesList.add(hole);
            if (dataOffset == -1L) {
                this.freeHoles.add(pos);
            } else {
                this.availableHolesBySize.put(hole, hole);
                this.availableHolesByPosition.put(hole, hole);
                if (this.maxHoleSize < recordSize) {
                    this.maxHoleSize = recordSize;
                }
            }
            ++pos;
        }
    }
}

