/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.resource.OSharedResourceAdaptive;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageClusterConfiguration;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.OClusterPositionIterator;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.OStorage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class OClusterMemory
extends OSharedResourceAdaptive
implements OCluster {
    public static final String TYPE = "MEMORY";
    private OStorage storage;
    private int id;
    private String name;
    private int dataSegmentId;
    private List<OPhysicalPosition> entries = new ArrayList<OPhysicalPosition>();
    private List<OPhysicalPosition> removed = new ArrayList<OPhysicalPosition>();

    public OClusterMemory() {
        super(OGlobalConfiguration.ENVIRONMENT_CONCURRENT.getValueAsBoolean());
    }

    public void configure(OStorage iStorage, OStorageClusterConfiguration iConfig) throws IOException {
        this.configure(iStorage, iConfig.getId(), iConfig.getName(), iConfig.getLocation(), iConfig.getDataSegmentId(), new Object[0]);
    }

    public void configure(OStorage iStorage, int iId, String iClusterName, String iLocation, int iDataSegmentId, Object ... iParameters) {
        this.storage = iStorage;
        this.id = iId;
        this.name = iClusterName;
        this.dataSegmentId = iDataSegmentId;
    }

    public int getDataSegmentId() {
        this.acquireSharedLock();
        try {
            int n = this.dataSegmentId;
            return n;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public OClusterPositionIterator absoluteIterator() {
        return new OClusterPositionIterator(this);
    }

    public OClusterPositionIterator absoluteIterator(long iBeginRange, long iEndRange) throws IOException {
        return new OClusterPositionIterator(this, iBeginRange, iEndRange);
    }

    public void close() {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            this.removed.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void open() throws IOException {
    }

    public void create(int iStartSize) throws IOException {
    }

    public void delete() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.close();
            this.entries.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void truncate() throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.clear();
            this.removed.clear();
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void set(OCluster.ATTRIBUTES iAttribute, Object iValue) throws IOException {
        if (iAttribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        String stringValue = iValue != null ? iValue.toString() : null;
        switch (iAttribute) {
            case NAME: {
                this.name = stringValue;
                break;
            }
            case DATASEGMENT: {
                this.dataSegmentId = this.storage.getDataSegmentIdByName(stringValue);
            }
        }
    }

    public long getEntries() {
        this.acquireSharedLock();
        try {
            long l = this.entries.size() - this.removed.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public long getRecordsSize() {
        this.acquireSharedLock();
        try {
            long size = 0L;
            for (OPhysicalPosition e : this.entries) {
                if (e == null) continue;
                size += (long)e.recordSize;
            }
            long l = size;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public long getFirstEntryPosition() {
        this.acquireSharedLock();
        try {
            long l = this.entries.size() == 0 ? -1 : 0;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public long getLastEntryPosition() {
        this.acquireSharedLock();
        try {
            long l = this.entries.size() - 1;
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public long getAvailablePosition() throws IOException {
        this.acquireSharedLock();
        try {
            long l = this.entries.size();
            return l;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void addPhysicalPosition(OPhysicalPosition iPPosition) {
        this.acquireExclusiveLock();
        try {
            if (!this.removed.isEmpty()) {
                OPhysicalPosition recycledPosition = this.removed.remove(this.removed.size() - 1);
                iPPosition.clusterPosition = recycledPosition.clusterPosition;
                iPPosition.recordVersion = recycledPosition.recordVersion + 1;
                this.entries.set((int)recycledPosition.clusterPosition, iPPosition);
            } else {
                iPPosition.clusterPosition = this.entries.size();
                iPPosition.recordVersion = 0;
                this.entries.add(iPPosition);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void updateRecordType(long iPosition, byte iRecordType) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)((int)iPosition)).recordType = iRecordType;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void updateVersion(long iPosition, int iVersion) throws IOException {
        this.acquireExclusiveLock();
        try {
            this.entries.get((int)((int)iPosition)).recordVersion = iVersion;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public OPhysicalPosition getPhysicalPosition(OPhysicalPosition iPPosition) {
        this.acquireSharedLock();
        try {
            OPhysicalPosition oPhysicalPosition = this.entries.get((int)iPPosition.clusterPosition);
            return oPhysicalPosition;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    public void removePhysicalPosition(long iPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition ppos = this.entries.get((int)iPosition);
            this.removed.add(ppos);
            this.entries.set((int)iPosition, null);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void updateDataSegmentPosition(long iPosition, int iDataSegmentId, long iDataPosition) {
        this.acquireExclusiveLock();
        try {
            OPhysicalPosition ppos = this.entries.get((int)iPosition);
            ppos.dataSegmentId = iDataSegmentId;
            ppos.dataSegmentPos = iDataPosition;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    public void synch() {
    }

    public void lock() {
        this.acquireSharedLock();
    }

    public void unlock() {
        this.releaseSharedLock();
    }

    public String getType() {
        return TYPE;
    }

    public String toString() {
        return "OClusterMemory [name=" + this.name + ", id=" + this.id + ", entries=" + this.entries.size() + ", removed=" + this.removed + "]";
    }
}

