/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.memory;

import com.orientechnologies.common.concur.lock.OLockManager;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageConfiguration;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.exception.OConcurrentModificationException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.hook.ORecordHook;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.OCluster;
import com.orientechnologies.orient.core.storage.ODataSegment;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageAbstract;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.impl.local.OStorageConfigurationSegment;
import com.orientechnologies.orient.core.storage.impl.memory.OClusterMemory;
import com.orientechnologies.orient.core.storage.impl.memory.ODataSegmentMemory;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionAbstract;
import com.orientechnologies.orient.core.tx.OTxListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OStorageMemory
extends OStorageEmbedded {
    private final List<ODataSegmentMemory> dataSegments = new ArrayList<ODataSegmentMemory>();
    private final List<OClusterMemory> clusters = new ArrayList<OClusterMemory>();
    private final Map<String, OClusterMemory> clusterMap = new HashMap<String, OClusterMemory>();
    private int defaultClusterId = 0;

    public OStorageMemory(String iURL) {
        super(iURL, iURL, "rw");
        this.configuration = new OStorageConfiguration(this);
    }

    @Override
    public void create(Map<String, Object> iOptions) {
        this.addUser();
        this.lock.acquireExclusiveLock();
        try {
            try {
                this.addDataSegment("default");
                this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "internal", null, null, new Object[0]);
                this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "index", null, null, new Object[0]);
                this.defaultClusterId = this.addCluster(OStorage.CLUSTER_TYPE.PHYSICAL.toString(), "default", null, null, new Object[0]);
                this.configuration.create();
                this.status = OStorageAbstract.STATUS.OPEN;
            }
            catch (OStorageException e) {
                this.close();
                throw e;
            }
            catch (IOException e) {
                this.close();
                throw new OStorageException("Error on creation of storage: " + this.name, e);
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void open(String iUserName, String iUserPassword, Map<String, Object> iOptions) {
        this.addUser();
        if (this.status == OStorageAbstract.STATUS.OPEN) {
            return;
        }
        this.lock.acquireExclusiveLock();
        try {
            if (!this.exists()) {
                throw new OStorageException("Cannot open the storage '" + this.name + "' because it does not exist in path: " + this.url);
            }
            this.status = OStorageAbstract.STATUS.OPEN;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void close(boolean iForce) {
        this.lock.acquireExclusiveLock();
        try {
            if (!this.checkForClose(iForce)) {
                return;
            }
            this.status = OStorageAbstract.STATUS.CLOSING;
            for (OClusterMemory c : this.clusters) {
                if (c == null) continue;
                c.close();
            }
            this.clusters.clear();
            this.clusterMap.clear();
            for (ODataSegmentMemory d : this.dataSegments) {
                if (d == null) continue;
                d.close();
            }
            this.dataSegments.clear();
            this.level2Cache.shutdown();
            super.close(iForce);
            Orient.instance().unregisterStorage(this);
            this.status = OStorageAbstract.STATUS.CLOSED;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void delete() {
        this.close(true);
    }

    @Override
    public void reload() {
    }

    @Override
    public int addCluster(String iClusterType, String iClusterName, String iLocation, String iDataSegmentName, Object ... iParameters) {
        iClusterName = iClusterName.toLowerCase();
        this.lock.acquireExclusiveLock();
        try {
            int clusterId = this.clusters.size();
            int i = 0;
            while (i < this.clusters.size()) {
                if (this.clusters.get(i) == null) {
                    clusterId = i;
                    break;
                }
                ++i;
            }
            OClusterMemory cluster = new OClusterMemory();
            cluster.configure(this, clusterId, iClusterName, iLocation, this.getDataSegmentIdByName(iDataSegmentName), iParameters);
            if (clusterId == this.clusters.size()) {
                this.clusters.add(cluster);
            } else {
                this.clusters.set(clusterId, cluster);
            }
            this.clusterMap.put(iClusterName, cluster);
            int n = clusterId;
            return n;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public boolean dropCluster(int iClusterId) {
        this.lock.acquireExclusiveLock();
        try {
            try {
                OCluster c = this.clusters.get(iClusterId);
                if (c != null) {
                    c.delete();
                    this.clusters.set(iClusterId, null);
                    this.getLevel2Cache().freeCluster(iClusterId);
                    this.clusterMap.remove(c.getName());
                }
            }
            catch (IOException iOException) {
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    @Override
    public boolean dropDataSegment(String iName) {
        this.lock.acquireExclusiveLock();
        try {
            int id = this.getDataSegmentIdByName(iName);
            ODataSegment data = this.dataSegments.get(id);
            if (data == null) {
                return false;
            }
            data.drop();
            this.dataSegments.set(id, null);
            this.configuration.dropCluster(id);
            return true;
        }
        catch (Exception e) {
            OLogManager.instance().exception("Error while removing data segment '" + iName + "'", e, OStorageException.class, new Object[0]);
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
        return false;
    }

    @Override
    public int addDataSegment(String iDataSegmentName) {
        this.lock.acquireExclusiveLock();
        try {
            this.dataSegments.add(new ODataSegmentMemory(iDataSegmentName, this.dataSegments.size()));
            int n = this.dataSegments.size() - 1;
            return n;
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public int addDataSegment(String iSegmentName, String iLocation) {
        return this.addDataSegment(iSegmentName);
    }

    @Override
    public OPhysicalPosition createRecord(int iDataSegmentId, ORecordId iRid, byte[] iContent, int iRecordVersion, byte iRecordType, int iMode, ORecordCallback<Long> iCallback) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            ODataSegmentMemory data = (ODataSegmentMemory)this.getDataSegmentById(iDataSegmentId);
            long offset = data.createRecord(iContent);
            OCluster cluster = this.getClusterById(iRid.clusterId);
            OPhysicalPosition ppos = new OPhysicalPosition(iDataSegmentId, offset, iRecordType);
            cluster.addPhysicalPosition(ppos);
            iRid.clusterPosition = ppos.clusterPosition;
            if (iCallback != null) {
                iCallback.call(iRid, iRid.clusterPosition);
            }
            OPhysicalPosition oPhysicalPosition = ppos;
            return oPhysicalPosition;
        }
        catch (IOException e) {
            throw new OStorageException("Error on create record in cluster: " + iRid.clusterId, e);
        }
        finally {
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.createRecord", timer);
        }
    }

    @Override
    public ORawBuffer readRecord(ORecordId iRid, String iFetchPlan, boolean iIgnoreCache, ORecordCallback<ORawBuffer> iCallback) {
        return this.readRecord(this.getClusterById(iRid.clusterId), iRid, true);
    }

    @Override
    protected ORawBuffer readRecord(OCluster iClusterSegment, ORecordId iRid, boolean iAtomicLock) {
        long timer = OProfiler.getInstance().startChrono();
        this.lock.acquireSharedLock();
        try {
            OPhysicalPosition ppos;
            block11: {
                this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                long lastPos = iClusterSegment.getLastEntryPosition();
                if (iRid.clusterPosition > lastPos) {
                    throw new ORecordNotFoundException("Record " + iRid + " is outside cluster size. Valid range for cluster '" + iClusterSegment.getName() + "' is 0-" + lastPos);
                }
                try {
                    ppos = iClusterSegment.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                    if (ppos != null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new OStorageException("Error on read record in cluster: " + iClusterSegment.getId(), e);
                    }
                }
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
                return null;
            }
            ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
            ORawBuffer oRawBuffer = new ORawBuffer(dataSegment.readRecord(ppos.dataSegmentPos), ppos.recordVersion, ppos.recordType);
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.SHARED);
            return oRawBuffer;
        }
        finally {
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.readRecord", timer);
        }
    }

    @Override
    public int updateRecord(ORecordId iRid, byte[] iContent, int iVersion, byte iRecordType, int iMode, ORecordCallback<Integer> iCallback) {
        long timer = OProfiler.getInstance().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lock.acquireSharedLock();
        try {
            OPhysicalPosition ppos;
            block15: {
                block16: {
                    this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    try {
                        ppos = cluster.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                        if (ppos != null) break block15;
                        if (iCallback == null) break block16;
                        iCallback.call(iRid, -1);
                    }
                    catch (Throwable throwable) {
                        try {
                            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                            throw throwable;
                        }
                        catch (IOException e) {
                            throw new OStorageException("Error on update record " + iRid, e);
                        }
                    }
                }
                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                return -1;
            }
            if (iVersion != -1) {
                if (iVersion > -1) {
                    if (iVersion != ppos.recordVersion) {
                        throw new OConcurrentModificationException("Cannot update record " + iRid + " because the version is not the latest. Probably you are updating an old record or it has been modified by another user (db=v" + ppos.recordVersion + " your=v" + iVersion + ")", iRid, ppos.recordVersion, iVersion);
                    }
                    ++ppos.recordVersion;
                } else {
                    --ppos.recordVersion;
                }
            }
            ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
            dataSegment.updateRecord(ppos.dataSegmentPos, iContent);
            if (iCallback != null) {
                iCallback.call(null, ppos.recordVersion);
            }
            int n = ppos.recordVersion;
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.updateRecord", timer);
        }
    }

    @Override
    public boolean deleteRecord(ORecordId iRid, int iVersion, int iMode, ORecordCallback<Boolean> iCallback) {
        long timer = OProfiler.getInstance().startChrono();
        OCluster cluster = this.getClusterById(iRid.clusterId);
        this.lock.acquireSharedLock();
        try {
            block13: {
                OPhysicalPosition ppos;
                block11: {
                    block12: {
                        this.lockManager.acquireLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                        try {
                            ppos = cluster.getPhysicalPosition(new OPhysicalPosition(iRid.clusterPosition));
                            if (ppos != null) break block11;
                            if (iCallback == null) break block12;
                            iCallback.call(iRid, false);
                        }
                        catch (Throwable throwable) {
                            try {
                                this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                                throw throwable;
                            }
                            catch (IOException e) {
                                throw new OStorageException("Error on delete record " + iRid, e);
                            }
                        }
                    }
                    this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
                    return false;
                }
                if (iVersion > -1 && ppos.recordVersion != iVersion) {
                    throw new OConcurrentModificationException("Cannot delete record " + iRid + " because the version is not the latest. Probably you are deleting an old record or it has been modified by another user (db=v" + ppos.recordVersion + " your=v" + iVersion + ")", iRid, ppos.recordVersion, iVersion);
                }
                cluster.removePhysicalPosition(iRid.clusterPosition);
                ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
                dataSegment.deleteRecord(ppos.dataSegmentPos);
                if (iCallback == null) break block13;
                iCallback.call(null, true);
            }
            this.lockManager.releaseLock(Thread.currentThread(), iRid, OLockManager.LOCK.EXCLUSIVE);
            return true;
        }
        finally {
            this.lock.releaseSharedLock();
            OProfiler.getInstance().stopChrono("OStorageMemory.deleteRecord", timer);
        }
    }

    @Override
    public long count(int iClusterId) {
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            long l = cluster.getEntries();
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public long[] getClusterDataRange(int iClusterId) {
        OCluster cluster = this.getClusterById(iClusterId);
        this.lock.acquireSharedLock();
        try {
            long[] lArray = new long[]{cluster.getFirstEntryPosition(), cluster.getLastEntryPosition()};
            return lArray;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public long count(int[] iClusterIds) {
        this.lock.acquireSharedLock();
        try {
            long tot = 0L;
            int i = 0;
            while (i < iClusterIds.length) {
                OCluster cluster = this.clusters.get(iClusterIds[i]);
                if (cluster != null) {
                    tot += cluster.getEntries();
                }
                ++i;
            }
            long l = tot;
            return l;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OCluster getClusterByName(String iClusterName) {
        this.lock.acquireSharedLock();
        try {
            OCluster oCluster = this.clusterMap.get(iClusterName.toLowerCase());
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getClusterIdByName(String iClusterName) {
        iClusterName = iClusterName.toLowerCase();
        this.lock.acquireSharedLock();
        try {
            OCluster cluster = this.clusterMap.get(iClusterName.toLowerCase());
            if (cluster == null) {
                return -1;
            }
            int n = cluster.getId();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public String getClusterTypeByName(String iClusterName) {
        return "MEMORY";
    }

    @Override
    public String getPhysicalClusterNameById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            int i = 0;
            while (i < this.clusters.size()) {
                OCluster cluster = this.clusters.get(i);
                if (cluster != null && cluster.getId() == iClusterId) {
                    String string = cluster.getName();
                    return string;
                }
                ++i;
            }
            return null;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public Set<String> getClusterNames() {
        this.lock.acquireSharedLock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.clusterMap.keySet());
            return hashSet;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public void commit(OTransaction iTx) {
        this.lock.acquireExclusiveLock();
        try {
            try {
                ArrayList<ORecordOperation> tmpEntries = new ArrayList<ORecordOperation>();
                while (iTx.getCurrentRecordEntries().iterator().hasNext()) {
                    for (ORecordOperation oRecordOperation : iTx.getCurrentRecordEntries()) {
                        tmpEntries.add(oRecordOperation);
                    }
                    iTx.clearRecordEntries();
                    for (ORecordOperation oRecordOperation : tmpEntries) {
                        this.commitEntry(iTx, oRecordOperation);
                    }
                    tmpEntries.clear();
                }
                OTransactionAbstract.updateCacheFromEntries(this, iTx, iTx.getAllRecordEntries(), true);
            }
            catch (IOException e) {
                this.rollback(iTx);
                this.lock.releaseExclusiveLock();
            }
        }
        finally {
            this.lock.releaseExclusiveLock();
        }
    }

    @Override
    public void rollback(OTransaction iTx) {
    }

    @Override
    public void synch() {
    }

    @Override
    public boolean exists() {
        this.lock.acquireSharedLock();
        try {
            boolean bl = !this.clusters.isEmpty();
            return bl;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public ODataSegment getDataSegmentById(int iDataId) {
        this.lock.acquireSharedLock();
        try {
            if (iDataId < 0 || iDataId > this.dataSegments.size() - 1) {
                throw new IllegalArgumentException("Invalid data segment id " + iDataId + ". Range is 0-" + (this.dataSegments.size() - 1));
            }
            ODataSegment oDataSegment = this.dataSegments.get(iDataId);
            return oDataSegment;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getDataSegmentIdByName(String iDataSegmentName) {
        if (iDataSegmentName == null) {
            return 0;
        }
        this.lock.acquireSharedLock();
        try {
            for (ODataSegmentMemory d : this.dataSegments) {
                if (!d.getName().equalsIgnoreCase(iDataSegmentName)) continue;
                int n = d.getId();
                return n;
            }
            throw new IllegalArgumentException("Data segment '" + iDataSegmentName + "' does not exist in storage '" + this.name + "'");
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public OCluster getClusterById(int iClusterId) {
        this.lock.acquireSharedLock();
        try {
            if (iClusterId == -1) {
                iClusterId = this.defaultClusterId;
            }
            OCluster oCluster = this.clusters.get(iClusterId);
            return oCluster;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getClusters() {
        this.lock.acquireSharedLock();
        try {
            int n = this.clusterMap.size();
            return n;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public Collection<? extends OCluster> getClusterInstances() {
        this.lock.acquireSharedLock();
        try {
            Collection<OClusterMemory> collection = Collections.unmodifiableCollection(this.clusters);
            return collection;
        }
        finally {
            this.lock.releaseSharedLock();
        }
    }

    @Override
    public int getDefaultClusterId() {
        return this.defaultClusterId;
    }

    @Override
    public long getSize() {
        long size = 0L;
        this.lock.acquireSharedLock();
        try {
            for (ODataSegmentMemory d : this.dataSegments) {
                if (d == null) continue;
                size += d.getSize();
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return size;
    }

    @Override
    public boolean checkForRecordValidity(OPhysicalPosition ppos) {
        if (ppos.dataSegmentId > 0) {
            return false;
        }
        this.lock.acquireSharedLock();
        try {
            ODataSegmentMemory dataSegment = (ODataSegmentMemory)this.getDataSegmentById(ppos.dataSegmentId);
            if (ppos.dataSegmentPos >= (long)dataSegment.count()) {
                return false;
            }
        }
        finally {
            this.lock.releaseSharedLock();
        }
        return true;
    }

    private void commitEntry(OTransaction iTx, ORecordOperation txEntry) throws IOException {
        ORecordId rid = (ORecordId)txEntry.getRecord().getIdentity();
        OCluster cluster = this.getClusterById(rid.clusterId);
        rid.clusterId = cluster.getId();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.BEFORE_COMMIT);
        }
        switch (txEntry.type) {
            case 0: {
                break;
            }
            case 3: {
                if (!rid.isNew()) break;
                byte[] stream = txEntry.getRecord().toStream();
                if (rid.isNew()) {
                    if (iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_CREATE, txEntry.getRecord())) {
                        stream = txEntry.getRecord().toStream();
                    }
                    txEntry.getRecord().onBeforeIdentityChanged(rid);
                    OPhysicalPosition ppos = this.createRecord(txEntry.dataSegmentId, rid, stream, 0, txEntry.getRecord().getRecordType(), 0, null);
                    txEntry.getRecord().setVersion(ppos.recordVersion);
                    txEntry.getRecord().onAfterIdentityChanged(txEntry.getRecord());
                    iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_CREATE, txEntry.getRecord());
                    break;
                }
                txEntry.getRecord().setVersion(this.updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                break;
            }
            case 1: {
                byte[] stream = txEntry.getRecord().toStream();
                if (iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_UPDATE, txEntry.getRecord())) {
                    stream = txEntry.getRecord().toStream();
                }
                txEntry.getRecord().setVersion(this.updateRecord(rid, stream, txEntry.getRecord().getVersion(), txEntry.getRecord().getRecordType(), 0, null));
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_UPDATE, txEntry.getRecord());
                break;
            }
            case 2: {
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.BEFORE_DELETE, txEntry.getRecord());
                this.deleteRecord(rid, txEntry.getRecord().getVersion(), 0, null);
                iTx.getDatabase().callbackHooks(ORecordHook.TYPE.AFTER_DELETE, txEntry.getRecord());
            }
        }
        txEntry.getRecord().unsetDirty();
        if (txEntry.getRecord() instanceof OTxListener) {
            ((OTxListener)((Object)txEntry.getRecord())).onEvent(txEntry, OTxListener.EVENT.AFTER_COMMIT);
        }
    }

    @Override
    public String getURL() {
        return "memory:" + this.url;
    }

    public OStorageConfigurationSegment getConfigurationSegment() {
        return null;
    }

    public void renameCluster(String iOldName, String iNewName) {
        OClusterMemory cluster = (OClusterMemory)this.getClusterByName(iOldName);
        if (cluster != null) {
            try {
                cluster.set(OCluster.ATTRIBUTES.NAME, iNewName);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

