/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseComplex;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexMVRBTreeAbstract;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.ORecordCallback;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionRealAbstract;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OTransactionOptimistic
extends OTransactionRealAbstract {
    private boolean usingLog = OGlobalConfiguration.TX_USE_LOG.getValueAsBoolean();
    private static AtomicInteger txSerial = new AtomicInteger();

    public OTransactionOptimistic(ODatabaseRecordTx iDatabase) {
        super(iDatabase, txSerial.incrementAndGet());
    }

    @Override
    public void begin() {
        this.status = OTransaction.TXSTATUS.BEGUN;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void commit() {
        block14: {
            this.checkTransaction();
            this.status = OTransaction.TXSTATUS.COMMITTING;
            if (!(this.database.getStorage() instanceof OStorageEmbedded)) {
                this.database.getStorage().commit(this);
            } else {
                involvedIndexes = this.getInvolvedIndexes();
                if (involvedIndexes != null) {
                    Collections.sort(involvedIndexes);
                }
                lockedIndexes = null;
                try {
                    if (involvedIndexes != null) {
                        for (String indexName : involvedIndexes) {
                            index = (OIndexMVRBTreeAbstract)this.database.getMetadata().getIndexManager().getIndexInternal(indexName);
                            if (lockedIndexes == null) {
                                lockedIndexes = new ArrayList<E>();
                            }
                            index.acquireExclusiveLock();
                            lockedIndexes.add(index);
                        }
                    }
                    indexes = this.database.getMetadata().getIndexManager().getIndexes();
                    indexesToLock = null;
                    if (indexes != null) {
                        indexesToLock = new ArrayList<OIndex<?>>(indexes);
                        Collections.sort(indexesToLock, new Comparator<OIndex<?>>(){

                            @Override
                            public int compare(OIndex<?> indexOne, OIndex<?> indexTwo) {
                                return indexOne.getName().compareTo(indexTwo.getName());
                            }
                        });
                    }
                    if (indexesToLock != null && !indexesToLock.isEmpty() && lockedIndexes == null) {
                        lockedIndexes = new ArrayList<OIndex<T>>();
                    }
                    for (OIndex<T> index : indexesToLock) {
                        for (Map.Entry<K, V> entry : this.recordEntries.entrySet()) {
                            record = ((ORecordOperation)entry.getValue()).record.getRecord();
                            if (!(record instanceof ODocument)) continue;
                            doc = (ODocument)record;
                            if (lockedIndexes.contains(index.getInternal()) || doc.getSchemaClass() == null || index.getDefinition() == null || !doc.getSchemaClass().isSubClassOf(index.getDefinition().getClassName())) continue;
                            ((OIndexMVRBTreeAbstract)index.getInternal()).acquireExclusiveLock();
                            lockedIndexes.add((OIndexMVRBTreeAbstract)index.getInternal());
                        }
                    }
                    this.database.getStorage().callInLock(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            OTransactionOptimistic.this.database.getStorage().commit(OTransactionOptimistic.this);
                            ODocument indexEntries = OTransactionOptimistic.this.getIndexChanges();
                            if (indexEntries != null) {
                                for (Map.Entry<String, Object> indexEntry : indexEntries) {
                                    OIndex<?> index = OTransactionOptimistic.this.database.getMetadata().getIndexManager().getIndexInternal(indexEntry.getKey());
                                    index.commit((ODocument)indexEntry.getValue());
                                }
                            }
                            return null;
                        }
                    }, true);
                }
                finally {
                    if (lockedIndexes == null) break block14;
                    ** for (index : lockedIndexes)
                }
lbl-1000:
                // 1 sources

                {
                    index.releaseExclusiveLock();
                    continue;
                }
            }
        }
    }

    @Override
    public void rollback() {
        this.checkTransaction();
        this.status = OTransaction.TXSTATUS.ROLLBACKING;
        this.database.getLevel1Cache().clear();
        for (ORecordOperation v : this.recordEntries.values()) {
            v.getRecord().unload();
        }
        for (ORecordOperation v : this.allEntries.values()) {
            v.getRecord().unload();
        }
        this.indexEntries.clear();
    }

    @Override
    public ORecordInternal<?> loadRecord(ORID iRid, ORecordInternal<?> iRecord, String iFetchPlan) {
        this.checkTransaction();
        ORecordInternal<?> txRecord = this.getRecord(iRid);
        if (txRecord == OTransactionRealAbstract.DELETED_RECORD) {
            return null;
        }
        if (txRecord != null) {
            return txRecord;
        }
        return this.database.executeReadRecord((ORecordId)iRid, iRecord, iFetchPlan, false);
    }

    @Override
    public void deleteRecord(ORecordInternal<?> iRecord, ODatabaseComplex.OPERATION_MODE iMode) {
        if (!iRecord.getIdentity().isValid()) {
            return;
        }
        this.addRecord(iRecord, (byte)2, null);
    }

    @Override
    public void saveRecord(ORecordInternal<?> iRecord, String iClusterName, ODatabaseComplex.OPERATION_MODE iMode, ORecordCallback<? extends Number> iCallback) {
        this.addRecord(iRecord, iRecord.getIdentity().isValid() ? (byte)1 : 3, iClusterName);
    }

    private void addRecord(ORecordInternal<?> iRecord, byte iStatus, String iClusterName) {
        this.checkTransaction();
        if (this.status == OTransaction.TXSTATUS.COMMITTING && this.database.getStorage() instanceof OStorageEmbedded) {
            switch (iStatus) {
                case 1: 
                case 3: {
                    this.database.executeSaveRecord(iRecord, iClusterName, iRecord.getVersion(), iRecord.getRecordType(), ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS, null);
                    break;
                }
                case 2: {
                    this.database.executeDeleteRecord(iRecord, iRecord.getVersion(), false, ODatabaseComplex.OPERATION_MODE.SYNCHRONOUS);
                }
            }
        } else {
            ORecordId rid = (ORecordId)iRecord.getIdentity();
            if (!rid.isValid()) {
                iRecord.onBeforeIdentityChanged(rid);
                if (rid.clusterId == -1) {
                    rid.clusterId = iClusterName != null ? this.database.getClusterIdByName(iClusterName) : this.database.getDefaultClusterId();
                }
                rid.clusterPosition = this.newObjectCounter--;
                iRecord.onAfterIdentityChanged(iRecord);
            } else {
                this.database.getLevel1Cache().freeRecord(rid);
            }
            ORecordOperation txEntry = this.getRecordEntry(rid);
            if (txEntry == null) {
                if (!rid.isTemporary() || iStatus == 3) {
                    txEntry = new ORecordOperation(iRecord, iStatus);
                    this.recordEntries.put(rid, txEntry);
                }
            } else {
                txEntry.record = iRecord;
                switch (txEntry.type) {
                    case 0: {
                        switch (iStatus) {
                            case 1: {
                                txEntry.type = 1;
                                break;
                            }
                            case 2: {
                                txEntry.type = (byte)2;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (iStatus) {
                            case 2: {
                                txEntry.type = (byte)2;
                            }
                        }
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        switch (iStatus) {
                            case 2: {
                                this.recordEntries.remove(rid);
                            }
                        }
                    }
                }
            }
        }
    }

    public String toString() {
        return "OTransactionOptimistic [id=" + this.id + ", status=" + (Object)((Object)this.status) + ", recEntries=" + this.recordEntries.size() + ", idxEntries=" + this.indexEntries.size() + "]";
    }

    @Override
    public boolean isUsingLog() {
        return this.usingLog;
    }

    @Override
    public void setUsingLog(boolean useLog) {
        this.usingLog = useLog;
    }
}

