/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree;

import com.orientechnologies.common.collection.OLazyIterator;
import com.orientechnologies.common.collection.OMVRBTreeEntry;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.OLazyRecordIterator;
import com.orientechnologies.orient.core.db.record.OLazyRecordMultiIterator;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.type.tree.OMVRBTreeEntryPersistent;
import com.orientechnologies.orient.core.type.tree.OMVRBTreePersistent;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDEntryProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeRIDProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeRID
extends OMVRBTreePersistent<OIdentifiable, OIdentifiable> {
    private IdentityHashMap<ORecord<?>, Object> newEntries;
    private boolean autoConvertToRecord = true;
    private static final Object NEWMAP_VALUE = new Object();
    private static final long serialVersionUID = 1L;

    public OMVRBTreeRID(Collection<OIdentifiable> iInitValues) {
        this();
        this.putAll(iInitValues);
    }

    public OMVRBTreeRID() {
        this(new OMVRBTreeRIDProvider(null, ODatabaseRecordThreadLocal.INSTANCE.get().getClusterIdByName("ORIDs")));
    }

    public OMVRBTreeRID(ODocument iRecord) {
        this(new OMVRBTreeRIDProvider(((OIdentifiable)iRecord.field("root")).getIdentity()));
        this.load();
    }

    public OMVRBTreeRID(String iClusterName) {
        this(new OMVRBTreeRIDProvider(iClusterName));
    }

    public OMVRBTreeRID(OMVRBTreeProvider<OIdentifiable, OIdentifiable> iProvider) {
        super(iProvider);
        ((OMVRBTreeRIDProvider)this.dataProvider).setTree(this);
    }

    public OMVRBTreeRID(OMVRBTreeRID iSource) {
        super(new OMVRBTreeRIDProvider((OMVRBTreeRIDProvider)iSource.getProvider()));
        ((OMVRBTreeRIDProvider)this.dataProvider).setTree(this);
        if (((OMVRBTreeRIDProvider)iSource.getProvider()).isEmbeddedStreaming()) {
            this.putAll(iSource.keySet());
        } else {
            this.load();
        }
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> load() {
        this.newEntries = null;
        super.load();
        if (this.root != null) {
            this.setSize(((OMVRBTreeRIDEntryProvider)((OMVRBTreeEntryPersistent)this.root).getProvider()).getTreeSize());
        } else {
            this.setSize(0);
        }
        return this;
    }

    @Override
    public OIdentifiable internalPut(OIdentifiable e, OIdentifiable v) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (e.getIdentity().isNew()) {
            Object record = e.getRecord();
            if (this.newEntries == null) {
                this.newEntries = new IdentityHashMap();
            } else if (this.newEntries.containsKey(record)) {
                return record;
            }
            this.newEntries.put((ORecord<?>)record, NEWMAP_VALUE);
            this.setDirty();
            return null;
        }
        return super.internalPut(e, null);
    }

    public void putAll(Collection<OIdentifiable> coll) {
        long timer = OProfiler.getInstance().startChrono();
        try {
            for (OIdentifiable rid : coll) {
                this.internalPut(rid, null);
            }
            this.commitChanges();
        }
        finally {
            OProfiler.getInstance().stopChrono("OMVRBTreePersistent.putAll", timer);
        }
    }

    @Override
    public OIdentifiable remove(Object o) {
        OIdentifiable removed;
        if (this.hasNewItems() && this.newEntries.containsKey(o)) {
            removed = (OIdentifiable)o;
            this.newEntries.remove(o);
            if (this.newEntries.size() == 0) {
                this.newEntries = null;
            }
            this.setDirty();
        } else if (this.containsKey(o)) {
            removed = (OIdentifiable)super.remove(o);
            this.setDirty();
        } else {
            removed = null;
        }
        return removed;
    }

    public boolean removeAll(Collection<?> c) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (this.hasNewItems()) {
            Set<ORecord<?>> v = this.newEntries.keySet();
            v.removeAll(c);
            if (this.newEntries.size() == 0) {
                this.newEntries = null;
            }
        }
        boolean modified = false;
        for (Object o : c) {
            if (this.remove(o) == null) continue;
            modified = true;
        }
        return modified;
    }

    public boolean retainAll(Collection<?> c) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (this.hasNewItems()) {
            Set<ORecord<?>> v = this.newEntries.keySet();
            v.retainAll(c);
            if (this.newEntries.size() == 0) {
                this.newEntries = null;
            }
        }
        boolean modified = false;
        OLazyIterator<OIdentifiable> e = this.iterator();
        while (e.hasNext()) {
            if (c.contains(e.next())) continue;
            e.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        if (this.newEntries != null) {
            this.newEntries.clear();
            this.newEntries = null;
        }
        this.setDirty();
        super.clear();
    }

    public boolean detach() {
        return this.saveAllNewEntries();
    }

    @Override
    public int size() {
        int tot = this.hashedSize();
        if (this.newEntries != null) {
            tot += this.newEntries.size();
        }
        return tot;
    }

    public int hashedSize() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        boolean empty = super.isEmpty();
        if (empty && this.newEntries != null) {
            empty = this.newEntries.isEmpty();
        }
        return empty;
    }

    @Override
    public boolean containsKey(Object o) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        boolean found = super.containsKey(o);
        if (!found && this.hasNewItems()) {
            found = this.newEntries.containsKey(o);
        }
        return found;
    }

    public OLazyIterator<OIdentifiable> iterator() {
        return this.iterator(this.autoConvertToRecord);
    }

    public OLazyIterator<OIdentifiable> iterator(boolean iAutoConvertToRecord) {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        if (this.hasNewItems()) {
            return new OLazyRecordMultiIterator(null, new Object[]{this.keySet().iterator(), this.newEntries.keySet().iterator()}, iAutoConvertToRecord);
        }
        return new OLazyRecordIterator(this.keySet().iterator(), iAutoConvertToRecord);
    }

    @Override
    public Set<OIdentifiable> keySet() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        return super.keySet();
    }

    @Override
    public Collection<OIdentifiable> values() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        return super.values();
    }

    public Object[] toArray() {
        Object[] result = this.keySet().toArray();
        if (this.newEntries != null && !this.newEntries.isEmpty()) {
            int start = result.length;
            result = Arrays.copyOf(result, start + this.newEntries.size());
            for (ORecord<?> r : this.newEntries.keySet()) {
                result[start++] = r;
            }
        }
        return result;
    }

    public <T> T[] toArray(T[] a) {
        T[] result = this.keySet().toArray(a);
        if (this.newEntries != null && !this.newEntries.isEmpty()) {
            int start = result.length;
            result = Arrays.copyOf(result, start + this.newEntries.size());
            for (ORecord<?> r : this.newEntries.keySet()) {
                result[start++] = r;
            }
        }
        return result;
    }

    @Override
    protected void saveTreeNode() {
    }

    @Override
    public int commitChanges() {
        if (!((OMVRBTreeRIDProvider)this.getProvider()).isEmbeddedStreaming()) {
            this.saveAllNewEntries();
            return super.commitChanges();
        }
        return 0;
    }

    @Override
    public OMVRBTreePersistent<OIdentifiable, OIdentifiable> save() {
        return this;
    }

    @Override
    protected void setSizeDelta(int iDelta) {
        this.setSize(this.hashedSize() + iDelta);
    }

    public void setDirtyOwner() {
        if (this.getOwner() != null) {
            this.getOwner().setDirty();
        }
    }

    public void onAfterTxCommit() {
        Set<ORID> nodesInMemory = this.getAllNodesInCache();
        if (nodesInMemory.isEmpty()) {
            return;
        }
        HashSet<ORID> keys = new HashSet<ORID>(nodesInMemory);
        for (ORID rid : keys) {
            if (rid.getClusterPosition() >= -1L) continue;
            OMVRBTreeEntryPersistent entry = this.searchNodeInCache(rid);
            this.removeNodeFromCache(rid);
            this.addNodeInCache(entry);
        }
    }

    public boolean saveAllNewEntries() {
        if (this.hasNewItems()) {
            HashSet temp = new HashSet(this.newEntries.keySet());
            for (ORecord oRecord : temp) {
                if (oRecord.getIdentity().isNew()) {
                    oRecord.save();
                }
                if (oRecord.getIdentity().isNew()) continue;
                if (this.newEntries != null) {
                    this.newEntries.remove(oRecord);
                    if (this.newEntries.size() == 0) {
                        this.newEntries = null;
                    }
                }
                this.internalPut(oRecord.getIdentity(), null);
            }
            if (!((OMVRBTreeRIDProvider)this.dataProvider).isEmbeddedStreaming()) {
                super.commitChanges();
            }
            if (this.newEntries != null) {
                return false;
            }
        }
        return true;
    }

    public boolean hasNewItems() {
        return this.newEntries != null && !this.newEntries.isEmpty();
    }

    public boolean isAutoConvert() {
        return this.autoConvertToRecord;
    }

    public OMVRBTreeRID setAutoConvert(boolean autoConvert) {
        this.autoConvertToRecord = autoConvert;
        return this;
    }

    @Override
    public String toString() {
        ((OMVRBTreeRIDProvider)this.dataProvider).lazyUnmarshall();
        StringBuilder buffer = new StringBuilder(super.toString());
        if (this.hasNewItems()) {
            buffer.append("{new items (");
            buffer.append(this.newEntries.size());
            buffer.append("): ");
            boolean first = true;
            for (ORecord<?> item : this.newEntries.keySet()) {
                if (!first) {
                    buffer.append(", ");
                    first = false;
                }
                buffer.append(item.toString());
            }
            buffer.append("}");
        }
        return buffer.toString();
    }

    @Override
    protected void setRoot(OMVRBTreeEntry<OIdentifiable, OIdentifiable> iRoot) {
        int size = 0;
        if (iRoot != null) {
            size = this.size();
        }
        super.setRoot(iRoot);
        if (iRoot != null) {
            this.setSize(size);
        }
    }

    protected <RET> RET setDirty() {
        ((OMVRBTreeRIDProvider)this.getProvider()).setDirty();
        if (((OMVRBTreeRIDProvider)this.getProvider()).isEmbeddedStreaming()) {
            this.setDirtyOwner();
        } else if (ODatabaseRecordThreadLocal.INSTANCE.get().getTransaction().getStatus() != OTransaction.TXSTATUS.BEGUN) {
            this.save();
        }
        return (RET)this;
    }

    public IdentityHashMap<ORecord<?>, Object> getTemporaryEntries() {
        return this.newEntries;
    }
}

