/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.type.tree.provider;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSerializationException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.serialization.OMemoryStream;
import com.orientechnologies.orient.core.serialization.OSerializableStream;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OBooleanSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OIntegerSerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.impl.OLinkSerializer;
import com.orientechnologies.orient.core.serialization.serializer.stream.OStreamSerializer;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProvider;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeEntryDataProviderAbstract;
import com.orientechnologies.orient.core.type.tree.provider.OMVRBTreeMapProvider;
import java.io.IOException;
import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMVRBTreeMapEntryProvider<K, V>
extends OMVRBTreeEntryDataProviderAbstract<K, V> {
    private static final int CURRENT_VERSION = -1;
    private static final long serialVersionUID = 1L;
    protected K[] keys;
    protected V[] values;
    protected int[] serializedKeys;
    protected int[] serializedValues;
    private byte[] buffer;

    public OMVRBTreeMapEntryProvider(OMVRBTreeMapProvider<K, V> iTreeDataProvider) {
        super(iTreeDataProvider, 1024);
        this.keys = new Object[this.pageSize];
        this.values = new Object[this.pageSize];
        this.serializedKeys = new int[this.pageSize];
        this.serializedValues = new int[this.pageSize];
    }

    public OMVRBTreeMapEntryProvider(OMVRBTreeMapProvider<K, V> iTreeDataProvider, ORID iRID) {
        super(iTreeDataProvider, iRID);
    }

    @Override
    public K getKeyAt(int iIndex) {
        Object k = this.keys[iIndex];
        if (k == null) {
            try {
                OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.unserializeKey", 1L);
                k = this.keyFromStream(iIndex);
                if (iIndex == 0 || iIndex == this.size || ((OMVRBTreeMapProvider)this.treeDataProvider).keepKeysInMemory) {
                    this.keys[iIndex] = k;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot lazy load the key #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return k;
    }

    @Override
    public V getValueAt(int iIndex) {
        Object v = this.values[iIndex];
        if (v == null) {
            try {
                OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.unserializeValue", 1L);
                v = this.valueFromStream(iIndex);
                if (((OMVRBTreeMapProvider)this.treeDataProvider).keepValuesInMemory) {
                    this.values[iIndex] = v;
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Cannot lazy load the value #" + iIndex + " in tree node " + this, (Throwable)e, OSerializationException.class, new Object[0]);
            }
        }
        return v;
    }

    @Override
    public boolean setValueAt(int iIndex, V iValue) {
        this.values[iIndex] = iValue;
        this.serializedValues[iIndex] = 0;
        return this.setDirty();
    }

    @Override
    public boolean insertAt(int iIndex, K iKey, V iValue) {
        if (iIndex < this.size) {
            System.arraycopy(this.keys, iIndex, this.keys, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.values, iIndex, this.values, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.serializedKeys, iIndex, this.serializedKeys, iIndex + 1, this.size - iIndex);
            System.arraycopy(this.serializedValues, iIndex, this.serializedValues, iIndex + 1, this.size - iIndex);
        }
        this.keys[iIndex] = iKey;
        this.values[iIndex] = iValue;
        this.serializedKeys[iIndex] = 0;
        this.serializedValues[iIndex] = 0;
        ++this.size;
        return this.setDirty();
    }

    @Override
    public boolean removeAt(int iIndex) {
        if (iIndex != this.size - 1 && iIndex > -1) {
            System.arraycopy(this.keys, iIndex + 1, this.keys, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.values, iIndex + 1, this.values, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.serializedKeys, iIndex + 1, this.serializedKeys, iIndex, this.size - iIndex - 1);
            System.arraycopy(this.serializedValues, iIndex + 1, this.serializedValues, iIndex, this.size - iIndex - 1);
        }
        --this.size;
        this.serializedKeys[this.size] = 0;
        this.serializedValues[this.size] = 0;
        this.keys[this.size] = null;
        this.values[this.size] = null;
        return this.setDirty();
    }

    @Override
    public boolean copyDataFrom(OMVRBTreeEntryDataProvider<K, V> iFrom, int iStartPosition) {
        OMVRBTreeMapEntryProvider parent = (OMVRBTreeMapEntryProvider)iFrom;
        this.size = iFrom.getSize() - iStartPosition;
        System.arraycopy(parent.serializedKeys, iStartPosition, this.serializedKeys, 0, this.size);
        System.arraycopy(parent.serializedValues, iStartPosition, this.serializedValues, 0, this.size);
        System.arraycopy(parent.keys, iStartPosition, this.keys, 0, this.size);
        System.arraycopy(parent.values, iStartPosition, this.values, 0, this.size);
        if (this.buffer == null && parent.buffer == null) {
            this.stream = null;
            return this.setDirty();
        }
        if (parent.buffer == null) {
            this.buffer = null;
            this.stream = null;
            return this.setDirty();
        }
        if (this.buffer == null || this.buffer.length < parent.buffer.length) {
            this.buffer = new byte[parent.buffer.length];
        }
        System.arraycopy(parent.buffer, 0, this.buffer, 0, parent.buffer.length);
        if (this.buffer == null) {
            this.stream = null;
        } else if (this.stream != null) {
            this.stream.setSource(this.buffer);
        } else {
            this.stream = new OMemoryStream(this.buffer);
        }
        return this.setDirty();
    }

    @Override
    public boolean truncate(int iNewSize) {
        Arrays.fill(this.serializedKeys, iNewSize, this.pageSize, 0);
        Arrays.fill(this.serializedValues, iNewSize, this.pageSize, 0);
        Arrays.fill(this.keys, iNewSize, this.size, null);
        Arrays.fill(this.values, iNewSize, this.size, null);
        this.size = iNewSize;
        return this.setDirty();
    }

    @Override
    public boolean copyFrom(OMVRBTreeEntryDataProvider<K, V> iSource) {
        OMVRBTreeMapEntryProvider source = (OMVRBTreeMapEntryProvider)iSource;
        this.serializedKeys = new int[source.serializedKeys.length];
        System.arraycopy(source.serializedKeys, 0, this.serializedKeys, 0, source.serializedKeys.length);
        this.serializedValues = new int[source.serializedValues.length];
        System.arraycopy(source.serializedValues, 0, this.serializedValues, 0, source.serializedValues.length);
        this.keys = new Object[source.keys.length];
        System.arraycopy(source.keys, 0, this.keys, 0, source.keys.length);
        this.values = new Object[source.values.length];
        System.arraycopy(source.values, 0, this.values, 0, source.values.length);
        this.size = source.size;
        if (this.buffer == null && source.buffer == null) {
            this.stream = null;
            return this.setDirty();
        }
        if (source.buffer == null) {
            this.buffer = null;
            this.stream = null;
            return this.setDirty();
        }
        if (this.buffer == null || this.buffer.length < source.buffer.length) {
            this.buffer = new byte[source.buffer.length];
        }
        System.arraycopy(source.buffer, 0, this.buffer, 0, source.buffer.length);
        if (this.buffer == null) {
            this.stream = null;
        } else if (this.stream != null) {
            this.stream.setSource(this.buffer);
        } else {
            this.stream = new OMemoryStream(this.buffer);
        }
        return this.setDirty();
    }

    @Override
    public void delete() {
        super.delete();
        this.keys = null;
        this.values = null;
        this.serializedKeys = null;
        this.serializedValues = null;
    }

    @Override
    public void clear() {
        super.clear();
        this.buffer = null;
        this.keys = null;
        this.values = null;
        this.serializedKeys = null;
        this.serializedValues = null;
    }

    @Override
    public OSerializableStream fromStream(byte[] iStream) throws OSerializationException {
        long timer = OProfiler.getInstance().startChrono();
        try {
            if (OIntegerSerializer.INSTANCE.deserialize(iStream, 0) >= 0) {
                OLogManager.instance().warn((Object)this, "Previous version of serialization format was found for node with id " + this.record.getIdentity() + " conversion to new format will be performed." + " It will take some time. If this message is shown constantly please recreate indexes.", new Object[0]);
                iStream = this.convertIntoNewSerializationFormat(iStream);
                OLogManager.instance().warn((Object)this, "Conversion of data to new serialization format for node " + this.record.getIdentity() + " was finished. ", new Object[0]);
            }
            if (((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer instanceof OBinarySerializer) {
                this.fromStreamUsingBinarySerializer(iStream);
            } else {
                this.fromStreamUsingBinaryStreamSerializer(iStream);
            }
            OMVRBTreeMapEntryProvider oMVRBTreeMapEntryProvider = this;
            return oMVRBTreeMapEntryProvider;
        }
        catch (IOException e) {
            throw new OSerializationException("Can not unmarshall tree node with id ", e);
        }
        finally {
            OProfiler.getInstance().stopChrono("OMVRBTreeMapEntry.fromStream", timer);
        }
    }

    @Override
    public byte[] toStream() throws OSerializationException {
        long timer = OProfiler.getInstance().startChrono();
        try {
            if (((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer instanceof OBinarySerializer) {
                this.toStreamUsingBinarySerializer();
            } else {
                this.toStreamUsingBinaryStreamSerializer();
            }
            this.record.fromStream(this.buffer);
            byte[] byArray = this.buffer;
            return byArray;
        }
        catch (IOException e) {
            throw new OSerializationException("Cannot marshall RB+Tree node", e);
        }
        finally {
            OProfiler.getInstance().stopChrono("OMVRBTreeMapEntry.toStream", timer);
        }
    }

    private void toStreamUsingBinarySerializer() {
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(this.parentRid) * 3;
        ++bufferSize;
        bufferSize += 4;
        int i = 0;
        while (i < this.size) {
            bufferSize += this.getKeySize(i);
            ++i;
        }
        i = 0;
        while (i < this.size) {
            bufferSize += this.getBinaryValueSize(i);
            ++i;
        }
        byte[] outBuffer = new byte[bufferSize];
        int offset = this.serializeMetadata(outBuffer, this.size, this.pageSize, this.parentRid, this.leftRid, this.rightRid, this.color);
        int i2 = 0;
        while (i2 < this.size) {
            offset = this.serializeKey(outBuffer, offset, i2);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.size) {
            offset = this.serializeBinaryValue(outBuffer, offset, i2);
            ++i2;
        }
        this.buffer = outBuffer;
    }

    private int serializeMetadata(byte[] newBuffer, int iSize, int iPageSize, ORID iParentId, ORID iLeftRid, ORID iRightRid, boolean iColor) {
        int offset = 0;
        OIntegerSerializer.INSTANCE.serialize(-1, newBuffer, offset);
        OIntegerSerializer.INSTANCE.serialize(iPageSize, newBuffer, offset += 4);
        OLinkSerializer.INSTANCE.serialize(iParentId, newBuffer, offset += 4);
        OLinkSerializer.INSTANCE.serialize(iLeftRid, newBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(iParentId));
        OLinkSerializer.INSTANCE.serialize(iRightRid, newBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(iLeftRid));
        OBooleanSerializer.INSTANCE.serialize(iColor, newBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(iRightRid));
        OIntegerSerializer.INSTANCE.serialize(iSize, newBuffer, ++offset);
        return offset += 4;
    }

    private int deserializeMetadata(byte[] inBuffer) {
        int offset = 0;
        int currentVersion = OIntegerSerializer.INSTANCE.deserialize(inBuffer, offset);
        offset += 4;
        if (currentVersion != -1) {
            throw new OSerializationException("MVRBTree node is stored using " + currentVersion + " version of serialization format but current version is " + -1 + ".");
        }
        this.pageSize = OIntegerSerializer.INSTANCE.deserialize(inBuffer, offset);
        this.parentRid = OLinkSerializer.INSTANCE.deserialize(inBuffer, offset += 4);
        this.leftRid = OLinkSerializer.INSTANCE.deserialize(inBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(this.parentRid));
        this.rightRid = OLinkSerializer.INSTANCE.deserialize(inBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(this.leftRid));
        this.color = OBooleanSerializer.INSTANCE.deserialize(inBuffer, offset += OLinkSerializer.INSTANCE.getObjectSize(this.rightRid));
        this.size = OIntegerSerializer.INSTANCE.deserialize(inBuffer, ++offset);
        offset += 4;
        if (this.size > this.pageSize) {
            throw new OConfigurationException("Loaded index with page size set to " + this.pageSize + " while the loaded was built with: " + this.size);
        }
        return offset;
    }

    private int serializeBinaryValue(byte[] newBuffer, int offset, int i) {
        OBinarySerializer valueSerializer = (OBinarySerializer)((Object)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer);
        if (this.serializedValues[i] <= 0) {
            OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.serializeValue", 1L);
            valueSerializer.serialize(this.values[i], newBuffer, offset);
            offset += valueSerializer.getObjectSize(this.values[i]);
        } else {
            int size = valueSerializer.getObjectSize(this.buffer, this.serializedValues[i]);
            System.arraycopy(this.buffer, this.serializedValues[i], newBuffer, offset, size);
            this.serializedValues[i] = offset;
            offset += size;
        }
        return offset;
    }

    private int serializeKey(byte[] newBuffer, int offset, int i) {
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        if (this.serializedKeys[i] <= 0) {
            OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.serializeKey", 1L);
            keySerializer.serialize(this.keys[i], newBuffer, offset);
            offset += keySerializer.getObjectSize(this.keys[i]);
        } else {
            int size = keySerializer.getObjectSize(this.buffer, this.serializedKeys[i]);
            System.arraycopy(this.buffer, this.serializedKeys[i], newBuffer, offset, size);
            this.serializedKeys[i] = offset;
            offset += size;
        }
        return offset;
    }

    private int getKeySize(int iIndex) {
        OBinarySerializer serializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        if (this.serializedKeys[iIndex] <= 0) {
            return serializer.getObjectSize(this.keys[iIndex]);
        }
        return serializer.getObjectSize(this.buffer, this.serializedKeys[iIndex]);
    }

    private int getBinaryValueSize(int iIndex) {
        OBinarySerializer serializer = (OBinarySerializer)((Object)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer);
        if (this.serializedValues[iIndex] <= 0) {
            return serializer.getObjectSize(this.values[iIndex]);
        }
        return serializer.getObjectSize(this.buffer, this.serializedValues[iIndex]);
    }

    private void toStreamUsingBinaryStreamSerializer() throws IOException {
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(this.parentRid) * 3;
        ++bufferSize;
        bufferSize += 4;
        int i = 0;
        while (i < this.size) {
            bufferSize += this.getKeySize(i);
            ++i;
        }
        byte[] outBuffer = new byte[bufferSize * 2];
        int offset = this.serializeMetadata(outBuffer, this.size, this.pageSize, this.parentRid, this.leftRid, this.rightRid, this.color);
        int i2 = 0;
        while (i2 < this.size) {
            offset = this.serializeKey(outBuffer, offset, i2);
            ++i2;
        }
        OMemoryStream outStream = new OMemoryStream(outBuffer);
        outStream.jump(offset);
        int i3 = 0;
        while (i3 < this.size) {
            this.serializedValues[i3] = outStream.set(this.serializeStreamValue(i3));
            ++i3;
        }
        this.buffer = outStream.toByteArray();
        if (this.stream == null) {
            this.stream = new OMemoryStream(this.buffer);
        } else {
            this.stream.setSource(this.buffer);
        }
    }

    private void fromStreamUsingBinarySerializer(byte[] inBuffer) {
        int offset = this.deserializeMetadata(inBuffer);
        this.serializedKeys = new int[this.pageSize];
        this.keys = new Object[this.pageSize];
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        if (keySerializer == null) {
            throw new IllegalStateException("key serializer wasn't found");
        }
        int i = 0;
        while (i < this.size) {
            this.serializedKeys[i] = offset;
            offset += keySerializer.getObjectSize(inBuffer, offset);
            ++i;
        }
        this.serializedValues = new int[this.pageSize];
        this.values = new Object[this.pageSize];
        OBinarySerializer valueSerializer = (OBinarySerializer)((Object)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer);
        if (valueSerializer == null) {
            throw new IllegalStateException("value serializer wasn't found");
        }
        int i2 = 0;
        while (i2 < this.size) {
            this.serializedValues[i2] = offset;
            offset += valueSerializer.getObjectSize(inBuffer, offset);
            ++i2;
        }
        this.buffer = inBuffer;
    }

    private void fromStreamUsingBinaryStreamSerializer(byte[] inBuffer) {
        int offset = this.deserializeMetadata(inBuffer);
        this.serializedKeys = new int[this.pageSize];
        this.keys = new Object[this.pageSize];
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        int i = 0;
        while (i < this.size) {
            this.serializedKeys[i] = offset;
            offset += keySerializer.getObjectSize(inBuffer, offset);
            ++i;
        }
        this.serializedValues = new int[this.pageSize];
        this.values = new Object[this.pageSize];
        if (this.stream == null) {
            this.stream = new OMemoryStream(inBuffer);
        } else {
            this.stream.setSource(inBuffer);
        }
        this.stream.jump(offset);
        i = 0;
        while (i < this.size) {
            this.serializedValues[i] = this.stream.getAsByteArrayOffset();
            ++i;
        }
        this.buffer = inBuffer;
    }

    protected byte[] serializeStreamValue(int iIndex) throws IOException {
        if (this.serializedValues[iIndex] <= 0) {
            OProfiler.getInstance().updateCounter("OMVRBTreeMapEntry.serializeValue", 1L);
            return ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer.toStream(this.values[iIndex]);
        }
        return this.stream.getAsByteArray(this.serializedValues[iIndex]);
    }

    protected Object keyFromStream(int iIndex) throws IOException {
        return ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer.deserialize(this.buffer, this.serializedKeys[iIndex]);
    }

    protected Object valueFromStream(int iIndex) throws IOException {
        OStreamSerializer valueSerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        if (valueSerializer instanceof OBinarySerializer) {
            return ((OBinarySerializer)((Object)valueSerializer)).deserialize(this.buffer, this.serializedValues[iIndex]);
        }
        return valueSerializer.fromStream(this.stream.getAsByteArray(this.serializedValues[iIndex]));
    }

    private byte[] convertIntoNewSerializationFormat(byte[] stream) throws IOException {
        OMemoryStream oldStream = new OMemoryStream(stream);
        int oldPageSize = oldStream.getAsInteger();
        ORecordId oldParentRid = new ORecordId().fromStream(oldStream.getAsByteArrayFixed(10));
        ORecordId oldLeftRid = new ORecordId().fromStream(oldStream.getAsByteArrayFixed(10));
        ORecordId oldRightRid = new ORecordId().fromStream(oldStream.getAsByteArrayFixed(10));
        boolean oldColor = oldStream.getAsBoolean();
        int oldSize = oldStream.getAsInteger();
        if (oldSize > oldPageSize) {
            throw new OConfigurationException("Loaded index with page size set to " + oldPageSize + " while the loaded was built with: " + oldSize);
        }
        Object[] oldKeys = new Object[oldPageSize];
        int i = 0;
        while (i < oldSize) {
            oldKeys[i] = ((OMVRBTreeMapProvider)this.treeDataProvider).streamKeySerializer.fromStream(oldStream.getAsByteArray());
            ++i;
        }
        Object[] oldValues = new Object[oldPageSize];
        int i2 = 0;
        while (i2 < oldSize) {
            oldValues[i2] = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer.fromStream(oldStream.getAsByteArray());
            ++i2;
        }
        byte[] result = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer instanceof OBinarySerializer ? this.convertNewSerializationFormatBinarySerializer(oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor, oldKeys, oldValues) : this.convertNewSerializationFormatStreamSerializer(oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor, oldKeys, oldValues);
        return result;
    }

    private byte[] convertNewSerializationFormatBinarySerializer(int oldSize, int oldPageSize, ORecordId oldParentRid, ORecordId oldLeftRid, ORecordId oldRightRid, boolean oldColor, K[] oldKeys, V[] oldValues) {
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(oldParentRid) * 3;
        ++bufferSize;
        bufferSize += 4;
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        OBinarySerializer valueSerializer = (OBinarySerializer)((Object)((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer);
        int i = 0;
        while (i < oldSize) {
            bufferSize += keySerializer.getObjectSize(oldKeys[i]);
            ++i;
        }
        i = 0;
        while (i < oldSize) {
            bufferSize += valueSerializer.getObjectSize(oldValues[i]);
            ++i;
        }
        byte[] outBuffer = new byte[bufferSize];
        int offset = this.serializeMetadata(outBuffer, oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor);
        int i2 = 0;
        while (i2 < oldSize) {
            keySerializer.serialize(oldKeys[i2], outBuffer, offset);
            offset += keySerializer.getObjectSize(oldKeys[i2]);
            ++i2;
        }
        i2 = 0;
        while (i2 < oldSize) {
            valueSerializer.serialize(oldValues[i2], outBuffer, offset);
            offset += valueSerializer.getObjectSize(oldValues[i2]);
            ++i2;
        }
        return outBuffer;
    }

    private byte[] convertNewSerializationFormatStreamSerializer(int oldSize, int oldPageSize, ORecordId oldParentRid, ORecordId oldLeftRid, ORecordId oldRightRid, boolean oldColor, K[] oldKeys, V[] oldValues) throws IOException {
        int bufferSize = 8;
        bufferSize += OLinkSerializer.INSTANCE.getObjectSize(oldParentRid) * 3;
        ++bufferSize;
        bufferSize += 4;
        OBinarySerializer keySerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).keySerializer;
        OStreamSerializer valueSerializer = ((OMVRBTreeMapProvider)this.treeDataProvider).valueSerializer;
        int i = 0;
        while (i < oldSize) {
            bufferSize += keySerializer.getObjectSize(oldKeys[i]);
            ++i;
        }
        byte[] outBuffer = new byte[bufferSize * 2];
        int offset = this.serializeMetadata(outBuffer, oldSize, oldPageSize, oldParentRid, oldLeftRid, oldRightRid, oldColor);
        int i2 = 0;
        while (i2 < oldSize) {
            keySerializer.serialize(oldKeys[i2], outBuffer, offset);
            offset += keySerializer.getObjectSize(oldKeys[i2]);
            ++i2;
        }
        OMemoryStream outStream = new OMemoryStream(outBuffer);
        outStream.jump(offset);
        int i3 = 0;
        while (i3 < oldSize) {
            outStream.set(valueSerializer.toStream(oldValues[i3]));
            ++i3;
        }
        return outStream.toByteArray();
    }
}

