/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Query;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.MultiIterable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class DefaultQuery
implements Query {
    private static final String[] EMPTY_LABELS = new String[0];
    private final Vertex vertex;
    public Query.Direction direction = Query.Direction.BOTH;
    public String[] labels = EMPTY_LABELS;
    public long limit = Long.MAX_VALUE;
    public List<HasContainer> hasContainers = new ArrayList<HasContainer>();

    public DefaultQuery(Vertex vertex) {
        this.vertex = vertex;
    }

    @Override
    public Query has(String key, Object value) {
        this.hasContainers.add(new HasContainer(key, value, Query.Compare.EQUAL));
        return this;
    }

    @Override
    public Query has(String key, Object value, Query.Compare compare) {
        this.hasContainers.add(new HasContainer(key, value, compare));
        return this;
    }

    @Override
    public Query interval(String key, Object startValue, Object endValue) {
        this.hasContainers.add(new HasContainer(key, startValue, Query.Compare.GREATER_THAN_EQUAL));
        this.hasContainers.add(new HasContainer(key, endValue, Query.Compare.LESS_THAN));
        return this;
    }

    @Override
    public Query direction(Query.Direction direction) {
        this.direction = direction;
        return this;
    }

    @Override
    public Query labels(String ... labels) {
        this.labels = labels;
        return this;
    }

    @Override
    public Query limit(long max) {
        this.limit = max;
        return this;
    }

    @Override
    public Iterable<Edge> edges() {
        return new QueryIterable<Edge>(false);
    }

    @Override
    public Iterable<Vertex> vertices() {
        return new QueryIterable<Vertex>(true);
    }

    @Override
    public long count() {
        long count = 0L;
        for (Edge edge : this.edges()) {
            ++count;
        }
        return count;
    }

    @Override
    public Object vertexIds() {
        ArrayList<Object> list = new ArrayList<Object>();
        for (Vertex vertex : this.vertices()) {
            list.add(vertex.getId());
        }
        return list;
    }

    private class QueryIterable<T extends Element>
    implements Iterable<T> {
        private Iterable<Edge> iterable;
        private boolean forVertex;

        public QueryIterable(boolean forVertex) {
            this.forVertex = forVertex;
            ArrayList temp = new ArrayList(2);
            if (DefaultQuery.this.direction == Query.Direction.OUT || DefaultQuery.this.direction == Query.Direction.BOTH) {
                temp.add(DefaultQuery.this.vertex.getOutEdges(DefaultQuery.this.labels));
            }
            if (DefaultQuery.this.direction == Query.Direction.IN || DefaultQuery.this.direction == Query.Direction.BOTH) {
                temp.add(DefaultQuery.this.vertex.getInEdges(DefaultQuery.this.labels));
            }
            this.iterable = new MultiIterable<Edge>(temp);
        }

        @Override
        public Iterator<T> iterator() {
            return new QueryIterator();
        }

        private class QueryIterator<T extends Element>
        implements Iterator<T> {
            Edge nextEdge = null;
            final Iterator<Edge> itty;
            long count = 0L;

            public QueryIterator() {
                this.itty = QueryIterable.this.iterable.iterator();
            }

            @Override
            public boolean hasNext() {
                if (null != this.nextEdge) {
                    return true;
                }
                return this.loadNext();
            }

            @Override
            public T next() {
                do {
                    if (this.nextEdge == null) continue;
                    Edge temp = this.nextEdge;
                    this.nextEdge = null;
                    if (QueryIterable.this.forVertex) {
                        if (DefaultQuery.this.direction == Query.Direction.OUT) {
                            return (T)temp.getInVertex();
                        }
                        if (DefaultQuery.this.direction == Query.Direction.IN) {
                            return (T)temp.getOutVertex();
                        }
                        if (temp.getInVertex().equals(DefaultQuery.this.vertex)) {
                            return (T)temp.getOutVertex();
                        }
                        return (T)temp.getInVertex();
                    }
                    return (T)temp;
                } while (this.loadNext());
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean loadNext() {
                this.nextEdge = null;
                if (this.count >= DefaultQuery.this.limit) {
                    return false;
                }
                while (this.itty.hasNext()) {
                    Edge edge = this.itty.next();
                    boolean filter = false;
                    for (HasContainer hasContainer : DefaultQuery.this.hasContainers) {
                        if (hasContainer.isLegal(edge)) continue;
                        filter = true;
                        break;
                    }
                    if (filter) continue;
                    this.nextEdge = edge;
                    ++this.count;
                    return true;
                }
                return false;
            }
        }
    }

    private class HasContainer {
        public String key;
        public Object value;
        public Query.Compare compare;

        public HasContainer(String key, Object value, Query.Compare compare) {
            this.key = key;
            this.value = value;
            this.compare = compare;
        }

        public boolean isLegal(Element element) {
            Object elementValue = element.getProperty(this.key);
            switch (this.compare) {
                case EQUAL: {
                    if (null == elementValue) {
                        return this.value == null;
                    }
                    return elementValue.equals(this.value);
                }
                case NOT_EQUAL: {
                    if (null == elementValue) {
                        return this.value != null;
                    }
                    return !elementValue.equals(this.value);
                }
                case GREATER_THAN: {
                    if (null == elementValue || this.value == null) {
                        return false;
                    }
                    return ((Comparable)elementValue).compareTo(this.value) >= 1;
                }
                case LESS_THAN: {
                    if (null == elementValue || this.value == null) {
                        return false;
                    }
                    return ((Comparable)elementValue).compareTo(this.value) <= -1;
                }
                case GREATER_THAN_EQUAL: {
                    if (null == elementValue || this.value == null) {
                        return false;
                    }
                    return ((Comparable)elementValue).compareTo(this.value) >= 0;
                }
                case LESS_THAN_EQUAL: {
                    if (null == elementValue || this.value == null) {
                        return false;
                    }
                    return ((Comparable)elementValue).compareTo(this.value) <= 0;
                }
            }
            throw new IllegalArgumentException("Invalid state as no valid filter was provided");
        }
    }
}

