/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.tg;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerAutomaticIndex;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerElement;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerGraph;
import java.io.Serializable;

public class TinkerEdge
extends TinkerElement
implements Edge,
Serializable {
    private final String label;
    private final Vertex inVertex;
    private final Vertex outVertex;

    protected TinkerEdge(String id, Vertex outVertex, Vertex inVertex, String label, TinkerGraph graph) {
        super(id, graph);
        this.label = label;
        this.outVertex = outVertex;
        this.inVertex = inVertex;
        for (TinkerAutomaticIndex index : this.graph.getAutoIndices()) {
            index.autoUpdate("label", this.label, null, this);
        }
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Vertex getOutVertex() {
        return this.outVertex;
    }

    @Override
    public Vertex getInVertex() {
        return this.inVertex;
    }

    public String toString() {
        return StringFactory.edgeString(this);
    }

    public boolean equals(Object object) {
        return object instanceof TinkerEdge && ((TinkerEdge)object).getId().equals(this.getId());
    }
}

