/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.impls.tg;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Query;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.DefaultQuery;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerElement;
import com.tinkerpop.blueprints.pgm.impls.tg.TinkerGraph;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TinkerVertex
extends TinkerElement
implements Vertex,
Serializable {
    protected Map<String, Set<Edge>> outEdges = new HashMap<String, Set<Edge>>();
    protected Map<String, Set<Edge>> inEdges = new HashMap<String, Set<Edge>>();

    protected TinkerVertex(String id, TinkerGraph graph) {
        super(id, graph);
    }

    @Override
    public Iterable<Edge> getInEdges(String ... labels) {
        if (labels.length == 0) {
            ArrayList<Edge> totalEdges = new ArrayList<Edge>();
            for (Collection collection : this.inEdges.values()) {
                totalEdges.addAll(collection);
            }
            return totalEdges;
        }
        if (labels.length == 1) {
            Set<Edge> edges = this.inEdges.get(labels[0]);
            if (null == edges) {
                return Collections.emptyList();
            }
            return new ArrayList<Edge>(edges);
        }
        ArrayList<Edge> totalEdges = new ArrayList<Edge>();
        for (String label : labels) {
            Set<Edge> edges = this.inEdges.get(label);
            if (null == edges) continue;
            totalEdges.addAll(edges);
        }
        return totalEdges;
    }

    @Override
    public Iterable<Edge> getOutEdges(String ... labels) {
        if (labels.length == 0) {
            ArrayList<Edge> totalEdges = new ArrayList<Edge>();
            for (Collection collection : this.outEdges.values()) {
                totalEdges.addAll(collection);
            }
            return totalEdges;
        }
        if (labels.length == 1) {
            Set<Edge> edges = this.outEdges.get(labels[0]);
            if (null == edges) {
                return Collections.emptyList();
            }
            return new ArrayList<Edge>(edges);
        }
        ArrayList<Edge> totalEdges = new ArrayList<Edge>();
        for (String label : labels) {
            Set<Edge> edges = this.outEdges.get(label);
            if (null == edges) continue;
            totalEdges.addAll(edges);
        }
        return totalEdges;
    }

    @Override
    public Query query() {
        return new DefaultQuery(this);
    }

    public String toString() {
        return StringFactory.vertexString(this);
    }

    public boolean equals(Object object) {
        return object instanceof TinkerVertex && ((TinkerVertex)object).getId().equals(this.getId());
    }

    protected void addOutEdge(String label, Edge edge) {
        Set<Edge> edges = this.outEdges.get(label);
        if (null == edges) {
            edges = new HashSet<Edge>();
            this.outEdges.put(label, edges);
        }
        edges.add(edge);
    }

    protected void addInEdge(String label, Edge edge) {
        Set<Edge> edges = this.inEdges.get(label);
        if (null == edges) {
            edges = new HashSet<Edge>();
            this.inEdges.put(label, edges);
        }
        edges.add(edge);
    }
}

