/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.IndexableGraph;
import com.tinkerpop.blueprints.pgm.Parameter;
import java.util.Set;

public class AutomaticIndexHelper {
    public static void addElement(AutomaticIndex index, Element element) {
        Set<String> indexKeys = index.getAutoIndexKeys();
        if ((indexKeys == null || indexKeys.contains("label")) && element instanceof Edge) {
            index.put("label", ((Edge)element).getLabel(), element);
        }
        for (String key : element.getPropertyKeys()) {
            if (indexKeys != null && !indexKeys.contains(key)) continue;
            index.put(key, element.getProperty(key), element);
        }
    }

    public static void addElement(IndexableGraph graph, Element element) {
        for (Index<? extends Element> index : graph.getIndices()) {
            if (!(index instanceof AutomaticIndex) || !index.getIndexClass().isAssignableFrom(element.getClass())) continue;
            AutomaticIndexHelper.addElement((AutomaticIndex)index, element);
        }
    }

    public static void removeElement(AutomaticIndex index, Element element) {
        Set<String> indexKeys = index.getAutoIndexKeys();
        if ((indexKeys == null || indexKeys.contains("label")) && element instanceof Edge) {
            index.remove("label", ((Edge)element).getLabel(), element);
        }
        for (String key : element.getPropertyKeys()) {
            if (indexKeys != null && !indexKeys.contains(key)) continue;
            index.remove(key, element.getProperty(key), element);
        }
    }

    public static void removeElement(IndexableGraph graph, Element element) {
        for (Index<? extends Element> index : graph.getIndices()) {
            if (!(index instanceof AutomaticIndex) || !index.getIndexClass().isAssignableFrom(element.getClass())) continue;
            AutomaticIndexHelper.removeElement((AutomaticIndex)index, element);
        }
    }

    public static void reIndexElements(IndexableGraph graph, Iterable<Element> elements) {
        for (Element element : elements) {
            AutomaticIndexHelper.removeElement(graph, element);
            AutomaticIndexHelper.addElement(graph, element);
        }
    }

    public static <T extends Element> AutomaticIndex<T> reIndexElements(IndexableGraph graph, AutomaticIndex<T> index, Iterable<Element> elements) {
        String indexName = index.getIndexName();
        Class indexClass = index.getIndexClass();
        Set<String> indexKeys = index.getAutoIndexKeys();
        graph.dropIndex(indexName);
        index = graph.createAutomaticIndex(indexName, indexClass, indexKeys, new Parameter[0]);
        for (Element element : elements) {
            AutomaticIndexHelper.addElement(index, element);
        }
        return index;
    }
}

