/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.io.gml;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.TransactionalGraph;
import com.tinkerpop.blueprints.pgm.Vertex;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class GMLReader {
    public static final String DEFAULT_LABEL = "undefined";
    private static final int DEFAULT_BUFFER_SIZE = 1000;
    private Map<Object, Object> vertexIds = new HashMap<Object, Object>();
    private final Graph graph;
    private final String defaultEdgeLabel;
    private boolean directed = false;
    private int edgeCount = 0;
    private String vertexIdKey;
    private String edgeIdKey;
    private String edgeLabelKey = "label";

    public GMLReader(Graph graph) {
        this(graph, DEFAULT_LABEL);
    }

    public GMLReader(Graph graph, String defaultEdgeLabel) {
        this.graph = graph;
        this.defaultEdgeLabel = defaultEdgeLabel;
    }

    public void setVertexIdKey(String vertexIdKey) {
        this.vertexIdKey = vertexIdKey;
    }

    public void setEdgeIdKey(String edgeIdKey) {
        this.edgeIdKey = edgeIdKey;
    }

    public void setEdgeLabelKey(String edgeLabelKey) {
        this.edgeLabelKey = edgeLabelKey;
    }

    public void inputGraph(InputStream inputStream) throws IOException {
        this.inputGraph(inputStream, 1000);
    }

    public void inputGraph(InputStream inputStream, int bufferSize) throws IOException {
        int previousMaxBufferSize = 0;
        if (this.graph instanceof TransactionalGraph) {
            previousMaxBufferSize = ((TransactionalGraph)this.graph).getMaxBufferSize();
            ((TransactionalGraph)this.graph).setMaxBufferSize(bufferSize);
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(inputStream, Charset.forName("ISO-8859-1")));
        StreamTokenizer st = new StreamTokenizer(r);
        try {
            st.commentChar(35);
            st.ordinaryChar(91);
            st.ordinaryChar(93);
            String stringCharacters = "/\\(){}<>!\u00a3$%^&*-+=,.?:;@_`|~";
            for (int i = 0; i < stringCharacters.length(); ++i) {
                st.wordChars(stringCharacters.charAt(i), stringCharacters.charAt(i));
            }
            this.parse(st);
            if (this.graph instanceof TransactionalGraph) {
                ((TransactionalGraph)this.graph).setMaxBufferSize(previousMaxBufferSize);
            }
        }
        catch (IOException e) {
            throw new IOException(this.error(st), e);
        }
        finally {
            this.vertexIds.clear();
        }
    }

    private boolean hasNext(StreamTokenizer st) throws IOException {
        return st.nextToken() != -1;
    }

    private String error(StreamTokenizer st) {
        return "GML malformed line number " + st.lineno() + ": ";
    }

    private boolean notLineBreak(int type) {
        return type != 10;
    }

    private void parse(StreamTokenizer st) throws IOException {
        while (this.hasNext(st)) {
            String value;
            int type = st.ttype;
            if (!this.notLineBreak(type) || !"graph".equals(value = st.sval)) continue;
            this.parseGraph(st);
            if (this.hasNext(st)) continue;
            return;
        }
        throw new IOException("Graph not complete");
    }

    private void parseGraph(StreamTokenizer st) throws IOException {
        this.checkValid(st, "graph");
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type)) continue;
            if (type == 93) {
                return;
            }
            String key = st.sval;
            if ("node".equals(key)) {
                this.addNode(this.parseNode(st));
                continue;
            }
            if ("edge".equals(key)) {
                this.addEdge(this.parseEdge(st));
                continue;
            }
            if ("directed".equals(key)) {
                this.directed = this.parseBoolean(st);
                continue;
            }
            this.parseValue("ignore", st);
        }
        throw new IOException("Graph not complete");
    }

    private void addNode(Map<String, Object> map) throws IOException {
        Object id = map.remove("id");
        if (id == null) {
            throw new IOException("No id found for node");
        }
        Vertex vertex = this.createVertex(map, id);
        this.addProperties(vertex, map);
    }

    private Vertex createVertex(Map<String, Object> map, Object id) {
        if (this.vertexIdKey != null) {
            Object vertexId = map.remove(this.vertexIdKey);
            if (vertexId != null) {
                this.vertexIds.put(id, vertexId);
                return this.graph.addVertex(vertexId);
            }
            this.vertexIds.put(id, id);
        }
        return this.graph.addVertex(id);
    }

    private void addEdge(Map<String, Object> map) throws IOException {
        Object mappedKey;
        Object source = map.remove("source");
        Object target = map.remove("target");
        if (source == null) {
            throw new IOException("Edge has no source");
        }
        if (target == null) {
            throw new IOException("Edge has no target");
        }
        if (this.vertexIdKey != null) {
            source = this.vertexIds.get(source);
            target = this.vertexIds.get(target);
        }
        Vertex outVertex = this.graph.getVertex(source);
        Vertex inVertex = this.graph.getVertex(target);
        if (outVertex == null) {
            throw new IOException("Edge source " + source + " not found");
        }
        if (inVertex == null) {
            throw new IOException("Edge target " + target + " not found");
        }
        Object label = map.remove(this.edgeLabelKey);
        if (label == null) {
            label = map.remove("label");
        } else {
            map.remove("label");
        }
        if (label == null) {
            label = this.defaultEdgeLabel;
        }
        Object edgeId = this.edgeCount++;
        if (this.edgeIdKey != null && (mappedKey = map.remove(this.edgeIdKey)) != null) {
            edgeId = mappedKey;
        }
        map.remove("id");
        Edge edge = this.graph.addEdge(edgeId, outVertex, inVertex, label.toString());
        if (this.directed) {
            edge.setProperty("directed", this.directed);
        }
        this.addProperties(edge, map);
    }

    private void addProperties(Element element, Map<String, Object> map) {
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            element.setProperty(entry.getKey(), entry.getValue());
        }
    }

    private Object parseValue(String key, StreamTokenizer st) throws IOException {
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type)) continue;
            if (type == -2) {
                Double doubleValue = st.nval;
                if (doubleValue.equals(doubleValue.intValue())) {
                    return doubleValue.intValue();
                }
                return Float.valueOf(doubleValue.floatValue());
            }
            if (type == 91) {
                return this.parseMap(key, st);
            }
            if (type != 34) continue;
            return st.sval;
        }
        throw new IOException("value not found");
    }

    private boolean parseBoolean(StreamTokenizer st) throws IOException {
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type) || type != -2) continue;
            return st.nval == 1.0;
        }
        throw new IOException("boolean not found");
    }

    private Map<String, Object> parseNode(StreamTokenizer st) throws IOException {
        return this.parseElement(st, "node");
    }

    private Map<String, Object> parseEdge(StreamTokenizer st) throws IOException {
        return this.parseElement(st, "edge");
    }

    private Map<String, Object> parseElement(StreamTokenizer st, String node) throws IOException {
        this.checkValid(st, node);
        return this.parseMap(node, st);
    }

    private Map<String, Object> parseMap(String node, StreamTokenizer st) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        while (this.hasNext(st)) {
            int type = st.ttype;
            if (!this.notLineBreak(type)) continue;
            if (type == 93) {
                return map;
            }
            String key = st.sval;
            Object value = this.parseValue(key, st);
            map.put(key, value);
        }
        throw new IOException(node + " incomplete");
    }

    private void checkValid(StreamTokenizer st, String token) throws IOException {
        if (st.nextToken() != 91) {
            throw new IOException(token + " not followed by [");
        }
    }

    public static void inputGraph(Graph graph, InputStream inputStream) throws IOException {
        GMLReader.inputGraph(graph, inputStream, DEFAULT_LABEL);
    }

    public static void inputGraph(Graph graph, InputStream inputStream, String defaultEdgeLabel) throws IOException {
        new GMLReader(graph, defaultEdgeLabel).inputGraph(inputStream, 1000);
    }
}

