/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.id;

import com.tinkerpop.blueprints.pgm.AutomaticIndex;
import com.tinkerpop.blueprints.pgm.CloseableSequence;
import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Element;
import com.tinkerpop.blueprints.pgm.Index;
import com.tinkerpop.blueprints.pgm.IndexableGraph;
import com.tinkerpop.blueprints.pgm.Parameter;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.util.wrappers.id.IdEdge;
import com.tinkerpop.blueprints.pgm.util.wrappers.id.IdEdgeIterable;
import com.tinkerpop.blueprints.pgm.util.wrappers.id.IdElement;
import com.tinkerpop.blueprints.pgm.util.wrappers.id.IdVertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.id.IdVertexIterable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class IdGraph
implements IndexableGraph {
    private static final Logger LOGGER = Logger.getLogger(IdGraph.class.getName());
    public static final String ID = "__id";
    public static final String VERTEX_IDS = "__vertex-ids";
    public static final String EDGE_IDS = "__edge-ids";
    private final IndexableGraph baseGraph;
    private Index<Vertex> vertexIds;
    private Index<Edge> edgeIds;
    private final IdFactory idFactory;

    public IdGraph(IndexableGraph baseGraph) {
        this(baseGraph, null);
    }

    public IdGraph(IndexableGraph baseGraph, IdFactory idFactory) {
        this.baseGraph = baseGraph;
        this.idFactory = null == idFactory ? new IdFactory(){

            @Override
            public Object createId() {
                return UUID.randomUUID().toString();
            }
        } : idFactory;
        this.createIndices();
    }

    private void createIndices() {
        HashSet<String> ids = new HashSet<String>();
        ids.add(ID);
        this.vertexIds = null == this.baseGraph.getIndex(VERTEX_IDS, Vertex.class) ? this.baseGraph.createAutomaticIndex(VERTEX_IDS, Vertex.class, ids, new Parameter[0]) : this.baseGraph.getIndex(VERTEX_IDS, Vertex.class);
        this.edgeIds = null == this.baseGraph.getIndex(EDGE_IDS, Edge.class) ? this.baseGraph.createAutomaticIndex(EDGE_IDS, Edge.class, ids, new Parameter[0]) : this.baseGraph.getIndex(EDGE_IDS, Edge.class);
    }

    @Override
    public <T extends Element> Index<T> createManualIndex(String s, Class<T> tClass, Parameter ... params) {
        if (0 < params.length) {
            LOGGER.warning("index parameters will be ignored");
        }
        if (s.equals(VERTEX_IDS) || s.equals(EDGE_IDS)) {
            throw new IllegalArgumentException("can't create index with reserved name '" + s + "'");
        }
        Index<Vertex> index = this.baseGraph.createManualIndex(s, tClass, new Parameter[0]);
        if (Vertex.class.isAssignableFrom(tClass)) {
            return new VertexIndexWrapper(index);
        }
        if (Edge.class.isAssignableFrom(tClass)) {
            return new EdgeIndexWrapper(index);
        }
        throw new IllegalStateException("unexpected index class: " + tClass);
    }

    @Override
    public <T extends Element> AutomaticIndex<T> createAutomaticIndex(String s, Class<T> tClass, Set<String> strings, Parameter ... params) {
        if (0 < params.length) {
            LOGGER.warning("index parameters will be ignored");
        }
        if (s.equals(VERTEX_IDS) || s.equals(EDGE_IDS)) {
            throw new IllegalArgumentException("can't create index with reserved name '" + s + "'");
        }
        if (null != strings && strings.contains(ID)) {
            throw new IllegalArgumentException("can't index on reserved property '__id'");
        }
        AutomaticIndex<Vertex> index = this.baseGraph.createAutomaticIndex(s, tClass, strings, new Parameter[0]);
        if (Vertex.class.isAssignableFrom(tClass)) {
            return new AutoVertexIndexWrapper(index);
        }
        if (Edge.class.isAssignableFrom(tClass)) {
            return new AutoEdgeIndexWrapper(index);
        }
        throw new IllegalStateException("unexpected index class: " + tClass);
    }

    @Override
    public <T extends Element> Index<T> getIndex(String s, Class<T> tClass) {
        if (s.equals(VERTEX_IDS) || s.equals(EDGE_IDS)) {
            return null;
        }
        Index<Vertex> index = this.baseGraph.getIndex(s, tClass);
        if (null == index) {
            return null;
        }
        if (Vertex.class.isAssignableFrom(tClass)) {
            if (Index.Type.AUTOMATIC.equals((Object)index.getIndexType())) {
                return new AutoVertexIndexWrapper(index);
            }
            return new VertexIndexWrapper(index);
        }
        if (Edge.class.isAssignableFrom(tClass)) {
            if (Index.Type.AUTOMATIC.equals((Object)index.getIndexType())) {
                return new AutoEdgeIndexWrapper(index);
            }
            return new EdgeIndexWrapper(index);
        }
        throw new IllegalStateException("unexpected index class: " + tClass);
    }

    @Override
    public Iterable<Index<? extends Element>> getIndices() {
        LinkedList<Index<? extends Element>> indices = new LinkedList<Index<? extends Element>>();
        for (Index<? extends Element> i : this.baseGraph.getIndices()) {
            if (i.getIndexName().equals(VERTEX_IDS) || i.getIndexName().equals(EDGE_IDS)) continue;
            if (Vertex.class.isAssignableFrom(i.getIndexClass())) {
                if (Index.Type.AUTOMATIC.equals((Object)i.getIndexType())) {
                    indices.add(new AutoVertexIndexWrapper(i));
                    continue;
                }
                indices.add(new VertexIndexWrapper(i));
                continue;
            }
            if (Edge.class.isAssignableFrom(i.getIndexClass())) {
                if (Index.Type.AUTOMATIC.equals((Object)i.getIndexType())) {
                    indices.add(new AutoEdgeIndexWrapper(i));
                    continue;
                }
                indices.add(new EdgeIndexWrapper(i));
                continue;
            }
            throw new IllegalStateException("unexpected index class: " + i.getIndexClass());
        }
        return indices;
    }

    @Override
    public void dropIndex(String s) {
        if (!s.equals(VERTEX_IDS) && !s.equals(EDGE_IDS)) {
            this.baseGraph.dropIndex(s);
        }
    }

    @Override
    public Vertex addVertex(Object id) {
        if (null != id && null != this.getVertex(id)) {
            throw new IllegalArgumentException("vertex with given id already exists: '" + id + "'");
        }
        Vertex base = this.baseGraph.addVertex(null);
        base.setProperty(ID, null == id ? this.idFactory.createId() : id);
        return new IdVertex(base);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Vertex getVertex(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        CloseableSequence<Vertex> i = this.vertexIds.get(ID, id);
        try {
            if (!i.hasNext()) {
                Vertex vertex = null;
                return vertex;
            }
            Vertex e = (Vertex)i.next();
            if (i.hasNext()) {
                throw new IllegalStateException("multiple vertices exist with id '" + id + "'");
            }
            IdVertex idVertex = new IdVertex(e);
            return idVertex;
        }
        finally {
            i.close();
        }
    }

    @Override
    public void removeVertex(Vertex vertex) {
        IdGraph.verifyNativeElement(vertex);
        this.baseGraph.removeVertex(((IdVertex)vertex).getBase());
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new IdVertexIterable(this.baseGraph.getVertices());
    }

    @Override
    public Edge addEdge(Object id, Vertex v1, Vertex v2, String s) {
        if (null != id && null != this.getEdge(id)) {
            throw new IllegalArgumentException("edge with given id already exists: '" + id + "'");
        }
        IdGraph.verifyNativeElement(v1);
        IdGraph.verifyNativeElement(v2);
        Edge e = this.baseGraph.addEdge(null, ((IdVertex)v1).getBase(), ((IdVertex)v2).getBase(), s);
        e.setProperty(ID, null == id ? this.idFactory.createId() : id);
        return new IdEdge(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Edge getEdge(Object id) {
        if (null == id) {
            throw new IllegalArgumentException("Element identifier cannot be null");
        }
        CloseableSequence<Edge> i = this.edgeIds.get(ID, id);
        try {
            if (!i.hasNext()) {
                Edge edge = null;
                return edge;
            }
            Edge e = (Edge)i.next();
            if (i.hasNext()) {
                throw new IllegalStateException("multiple edges exist with id '" + id + "'");
            }
            IdEdge idEdge = new IdEdge(e);
            return idEdge;
        }
        finally {
            i.close();
        }
    }

    @Override
    public void removeEdge(Edge edge) {
        IdGraph.verifyNativeElement(edge);
        this.baseGraph.removeEdge(((IdEdge)edge).getBase());
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new IdEdgeIterable(this.baseGraph.getEdges());
    }

    @Override
    public void clear() {
        this.baseGraph.clear();
        this.createIndices();
    }

    @Override
    public void shutdown() {
        this.baseGraph.shutdown();
    }

    private static void verifyNativeElement(Element e) {
        if (!(e instanceof IdElement)) {
            throw new IllegalArgumentException("given element was not created in this graph");
        }
    }

    public String toString() {
        return StringFactory.graphString(this, "base graph: " + this.baseGraph.toString());
    }

    public static void main(String[] args) throws Exception {
        System.out.println(UUID.randomUUID().toString());
    }

    private static class CloseableEdgeSequence
    implements CloseableSequence<Edge> {
        private final CloseableSequence<Edge> base;

        public CloseableEdgeSequence(CloseableSequence<Edge> base) {
            this.base = base;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public Iterator<Edge> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public Edge next() {
            return new IdEdge((Edge)this.base.next());
        }

        @Override
        public void remove() {
            this.base.remove();
        }
    }

    private static class CloseableVertexSequence
    implements CloseableSequence<Vertex> {
        private final CloseableSequence<Vertex> base;

        public CloseableVertexSequence(CloseableSequence<Vertex> base) {
            this.base = base;
        }

        @Override
        public void close() {
            this.base.close();
        }

        @Override
        public Iterator<Vertex> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.base.hasNext();
        }

        @Override
        public Vertex next() {
            return new IdVertex((Vertex)this.base.next());
        }

        @Override
        public void remove() {
            this.base.remove();
        }
    }

    private class AutoEdgeIndexWrapper
    extends EdgeIndexWrapper
    implements AutomaticIndex<Edge> {
        public AutoEdgeIndexWrapper(Index<Edge> base) {
            super(base);
        }

        @Override
        public Set<String> getAutoIndexKeys() {
            return ((AutomaticIndex)this.base).getAutoIndexKeys();
        }
    }

    private class EdgeIndexWrapper
    implements Index<Edge> {
        protected final Index<Edge> base;

        public EdgeIndexWrapper(Index<Edge> base) {
            this.base = base;
        }

        @Override
        public String getIndexName() {
            return this.base.getIndexName();
        }

        @Override
        public Class<Edge> getIndexClass() {
            return this.base.getIndexClass();
        }

        @Override
        public Index.Type getIndexType() {
            return this.base.getIndexType();
        }

        @Override
        public void put(String s, Object o, Edge edge) {
            IdGraph.verifyNativeElement(edge);
            this.base.put(s, o, ((IdEdge)edge).getBase());
        }

        @Override
        public CloseableSequence<Edge> get(String s, Object o) {
            return new CloseableEdgeSequence(this.base.get(s, o));
        }

        @Override
        public long count(String s, Object o) {
            return this.base.count(s, o);
        }

        @Override
        public void remove(String s, Object o, Edge edge) {
            IdGraph.verifyNativeElement(edge);
            this.base.remove(s, o, ((IdEdge)edge).getBase());
        }
    }

    private static class AutoVertexIndexWrapper
    extends VertexIndexWrapper
    implements AutomaticIndex<Vertex> {
        public AutoVertexIndexWrapper(Index<Vertex> base) {
            super(base);
        }

        @Override
        public Set<String> getAutoIndexKeys() {
            return ((AutomaticIndex)this.base).getAutoIndexKeys();
        }
    }

    private static class VertexIndexWrapper
    implements Index<Vertex> {
        protected final Index<Vertex> base;

        public VertexIndexWrapper(Index<Vertex> base) {
            this.base = base;
        }

        @Override
        public String getIndexName() {
            return this.base.getIndexName();
        }

        @Override
        public Class<Vertex> getIndexClass() {
            return this.base.getIndexClass();
        }

        @Override
        public Index.Type getIndexType() {
            return this.base.getIndexType();
        }

        @Override
        public void put(String s, Object o, Vertex vertex) {
            IdGraph.verifyNativeElement(vertex);
            this.base.put(s, o, ((IdVertex)vertex).getBase());
        }

        @Override
        public CloseableSequence<Vertex> get(String s, Object o) {
            return new CloseableVertexSequence(this.base.get(s, o));
        }

        @Override
        public long count(String s, Object o) {
            return this.base.count(s, o);
        }

        @Override
        public void remove(String s, Object o, Vertex vertex) {
            IdGraph.verifyNativeElement(vertex);
            this.base.remove(s, o, ((IdVertex)vertex).getBase());
        }
    }

    public static interface IdFactory {
        public Object createId();
    }
}

