/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.readonly;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.pgm.util.wrappers.readonly.ReadOnlyEdge;
import com.tinkerpop.blueprints.pgm.util.wrappers.readonly.ReadOnlyVertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.readonly.util.ReadOnlyEdgeSequence;
import com.tinkerpop.blueprints.pgm.util.wrappers.readonly.util.ReadOnlyVertexSequence;

public class ReadOnlyGraph<T extends Graph>
implements Graph,
WrapperGraph<T> {
    protected final T baseGraph;

    public ReadOnlyGraph(T baseGraph) {
        this.baseGraph = baseGraph;
    }

    @Override
    public void removeVertex(Vertex vertex) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.baseGraph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        return new ReadOnlyVertex(vertex);
    }

    @Override
    public void removeEdge(Edge edge) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new ReadOnlyEdgeSequence(this.baseGraph.getEdges().iterator());
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.baseGraph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new ReadOnlyEdge(edge);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new ReadOnlyVertexSequence(this.baseGraph.getVertices().iterator());
    }

    @Override
    public Vertex addVertex(Object id) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void clear() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    @Override
    public void shutdown() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("It is not possible to mutate a ReadOnlyGraph");
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }
}

