/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.pgm.util.wrappers.wrapped;

import com.tinkerpop.blueprints.pgm.Edge;
import com.tinkerpop.blueprints.pgm.Graph;
import com.tinkerpop.blueprints.pgm.Vertex;
import com.tinkerpop.blueprints.pgm.impls.StringFactory;
import com.tinkerpop.blueprints.pgm.util.wrappers.WrapperGraph;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.WrappedEdge;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.WrappedVertex;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.util.WrappedEdgeSequence;
import com.tinkerpop.blueprints.pgm.util.wrappers.wrapped.util.WrappedVertexSequence;

public class WrappedGraph<T extends Graph>
implements Graph,
WrapperGraph<T> {
    protected T baseGraph;

    public WrappedGraph(T baseGraph) {
        this.baseGraph = baseGraph;
    }

    @Override
    public void clear() {
        this.baseGraph.clear();
    }

    @Override
    public void shutdown() {
        this.baseGraph.shutdown();
    }

    @Override
    public Vertex addVertex(Object id) {
        return new WrappedVertex(this.baseGraph.addVertex(id));
    }

    @Override
    public Vertex getVertex(Object id) {
        Vertex vertex = this.baseGraph.getVertex(id);
        if (null == vertex) {
            return null;
        }
        return new WrappedVertex(vertex);
    }

    @Override
    public Iterable<Vertex> getVertices() {
        return new WrappedVertexSequence(this.baseGraph.getVertices().iterator());
    }

    @Override
    public Edge addEdge(Object id, Vertex outVertex, Vertex inVertex, String label) {
        return new WrappedEdge(this.baseGraph.addEdge(id, ((WrappedVertex)outVertex).getBaseVertex(), ((WrappedVertex)inVertex).getBaseVertex(), label));
    }

    @Override
    public Edge getEdge(Object id) {
        Edge edge = this.baseGraph.getEdge(id);
        if (null == edge) {
            return null;
        }
        return new WrappedEdge(edge);
    }

    @Override
    public Iterable<Edge> getEdges() {
        return new WrappedEdgeSequence(this.baseGraph.getEdges().iterator());
    }

    @Override
    public void removeEdge(Edge edge) {
        this.baseGraph.removeEdge(((WrappedEdge)edge).getBaseEdge());
    }

    @Override
    public void removeVertex(Vertex vertex) {
        this.baseGraph.removeVertex(((WrappedVertex)vertex).getBaseVertex());
    }

    @Override
    public T getBaseGraph() {
        return this.baseGraph;
    }

    public String toString() {
        return StringFactory.graphString(this, this.baseGraph.toString());
    }
}

