/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.console;

import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.io.OFileUtils;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.profiler.OProfiler;
import com.orientechnologies.orient.client.remote.OServerAdmin;
import com.orientechnologies.orient.client.remote.OStorageRemote;
import com.orientechnologies.orient.client.remote.OStorageRemoteThread;
import com.orientechnologies.orient.console.OConsoleDatabaseListener;
import com.orientechnologies.orient.console.OrientConsole;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.db.tool.ODatabaseCompare;
import com.orientechnologies.orient.core.db.tool.ODatabaseExport;
import com.orientechnologies.orient.core.db.tool.ODatabaseExportException;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.intent.OIntentMassiveRead;
import com.orientechnologies.orient.core.iterator.OIdentifiableIterator;
import com.orientechnologies.orient.core.iterator.ORecordIteratorClass;
import com.orientechnologies.orient.core.iterator.ORecordIteratorCluster;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.ORecordSchemaAwareAbstract;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ORecordBytes;
import com.orientechnologies.orient.core.record.impl.ORecordFlat;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.string.ORecordSerializerStringAbstract;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.ORawBuffer;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageEmbedded;
import com.orientechnologies.orient.core.storage.impl.local.ODataHoleInfo;
import com.orientechnologies.orient.core.storage.impl.local.OStorageLocal;
import com.orientechnologies.orient.enterprise.command.OCommandExecutorScript;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OConsoleDatabaseApp
extends OrientConsole
implements OCommandOutputListener,
OProgressListener {
    protected ODatabaseDocument currentDatabase;
    protected String currentDatabaseName;
    protected ORecordInternal<?> currentRecord;
    protected List<OIdentifiable> currentResultSet;
    protected OServerAdmin serverAdmin;
    private int lastPercentStep;
    private String currentDatabaseUserName;
    private String currentDatabaseUserPassword;

    public OConsoleDatabaseApp(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        try {
            boolean tty = false;
            try {
                if (OConsoleDatabaseApp.setTerminalToCBreak()) {
                    tty = true;
                }
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    public void run() {
                        try {
                            OConsoleDatabaseApp.stty("echo");
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
            OConsoleDatabaseApp console = new OConsoleDatabaseApp(args);
            if (tty) {
                console.setReader((OConsoleReader)new TTYConsoleReader());
            }
            console.run();
        }
        finally {
            try {
                OConsoleDatabaseApp.stty("echo");
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void onBefore() {
        super.onBefore();
        this.currentResultSet = new ArrayList<OIdentifiable>();
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)false);
        this.properties.put("limit", "20");
        this.properties.put("debug", "false");
        this.properties.put("maxBinaryDisplay", "160");
        OCommandManager.instance().registerExecutor(OCommandScript.class, OCommandExecutorScript.class);
    }

    @Override
    protected void onAfter() {
        super.onAfter();
        Orient.instance().shutdown();
    }

    protected List<String> filterCommands(String[] commandLines) {
        StringBuilder buffer = new StringBuilder();
        ArrayList<String> modifiedCommandLines = new ArrayList<String>();
        String[] stringArray = commandLines;
        int n = commandLines.length;
        int n2 = 0;
        while (n2 < n) {
            String commandLine = stringArray[n2];
            if (buffer.length() > 0 && commandLine.startsWith("end")) {
                modifiedCommandLines.add(buffer.toString());
                buffer.setLength(0);
            } else if (commandLine.startsWith("js")) {
                buffer.append(commandLine);
            } else if (buffer.length() > 0) {
                buffer.append(';');
                buffer.append(commandLine);
            } else {
                modifiedCommandLines.add(commandLine);
            }
            ++n2;
        }
        if (buffer.length() > 0) {
            modifiedCommandLines.add(buffer.toString());
        }
        return modifiedCommandLines;
    }

    @ConsoleCommand(aliases={"use database"}, description="Connect to a database or a remote Server instance")
    public void connect(@ConsoleParameter(name="url", description="The url of the remote server or the database to connect to in the format '<mode>:<path>'") String iURL, @ConsoleParameter(name="user", description="User name") String iUserName, @ConsoleParameter(name="password", description="User password") String iUserPassword) throws IOException {
        this.disconnect();
        this.currentDatabaseUserName = iUserName;
        this.currentDatabaseUserPassword = iUserPassword;
        if (iURL.contains("/")) {
            this.out.print("Connecting to database [" + iURL + "] with user '" + iUserName + "'...");
            this.currentDatabase = new ODatabaseDocumentTx(iURL);
            if (this.currentDatabase == null) {
                throw new OException("Database " + iURL + " not found");
            }
            this.currentDatabase.registerListener((ODatabaseListener)new OConsoleDatabaseListener(this));
            this.currentDatabase.open(iUserName, iUserPassword);
            this.currentDatabaseName = this.currentDatabase.getName();
            if (this.currentDatabase.getStorage() instanceof OStorageRemote) {
                this.serverAdmin = new OServerAdmin((OStorageRemote)this.currentDatabase.getStorage());
            }
        } else {
            this.out.print("Connecting to remote Server instance [" + iURL + "] with user '" + iUserName + "'...");
            this.serverAdmin = new OServerAdmin(iURL).connect(iUserName, iUserPassword);
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.out.println("OK");
    }

    @ConsoleCommand(aliases={"close database"}, description="Disconnect from the current database")
    public void disconnect() {
        if (this.serverAdmin != null) {
            this.out.print("\nDisconnecting from remote server [" + this.serverAdmin.getURL() + "]...");
            this.serverAdmin.close(true);
            this.serverAdmin = null;
            this.out.println("OK");
        }
        if (this.currentDatabase != null) {
            this.out.print("\nDisconnecting from the database [" + this.currentDatabaseName + "]...");
            OStorage stg = Orient.instance().getStorage(this.currentDatabase.getURL());
            this.currentDatabase.close();
            if (stg != null) {
                stg.close(true);
            }
            this.currentDatabase = null;
            this.currentDatabaseName = null;
            this.currentRecord = null;
            this.out.println("OK");
        }
    }

    @ConsoleCommand(description="Create a new database")
    public void createDatabase(@ConsoleParameter(name="database-url", description="The url of the database to create in the format '<mode>:<path>'") String iDatabaseURL, @ConsoleParameter(name="user", description="Server administrator name") String iUserName, @ConsoleParameter(name="password", description="Server administrator password") String iUserPassword, @ConsoleParameter(name="storage-type", description="The type of the storage. Either 'local' for disk-based database and 'memory' for in-memory database") String iStorageType, @ConsoleParameter(name="db-type", optional=true, description="The type of the database used between 'document' and 'graph'. By default is document.") String iDatabaseType) throws IOException {
        if (iDatabaseType == null) {
            iDatabaseType = "document";
        }
        this.out.println("Creating database [" + iDatabaseURL + "] using the storage type [" + iStorageType + "]...");
        this.currentDatabaseUserName = iUserName;
        this.currentDatabaseUserPassword = iUserPassword;
        if (iDatabaseURL.startsWith("remote")) {
            String dbURL = iDatabaseURL.substring("remote".length() + 1);
            new OServerAdmin(dbURL).connect(iUserName, iUserPassword).createDatabase(iDatabaseType, iStorageType).close();
            this.connect(iDatabaseURL, "admin", "admin");
        } else {
            this.currentDatabase = Orient.instance().getDatabaseFactory().createDatabase(iDatabaseType, iDatabaseURL);
            this.currentDatabase.create();
            this.currentDatabaseName = this.currentDatabase.getName();
        }
        this.out.println("Database created successfully.");
        this.out.println("\nCurrent database is: " + iDatabaseURL);
    }

    @ConsoleCommand(description="List all the databases available on the connected server")
    public void listDatabases() throws IOException {
        if (this.serverAdmin != null) {
            Map<String, String> databases = this.serverAdmin.listDatabases();
            this.out.printf("\nFound %d databases:\n", databases.size());
            for (Map.Entry<String, String> database : databases.entrySet()) {
                this.out.printf("\n* %s (%s)", database.getKey(), database.getValue().substring(0, database.getValue().indexOf(":")));
            }
        } else {
            this.out.println("Not connected to the Server instance");
        }
        this.out.println();
    }

    @ConsoleCommand(description="Reload the database schema")
    public void reloadSchema() throws IOException {
        this.out.println("reloading database schema...");
        this.updateDatabaseInfo();
        this.out.println("\nDone.");
    }

    @ConsoleCommand(description="Create a new data-segment in the current database.")
    public void createDatasegment(@ConsoleParameter(name="datasegment-name", description="The name of the data segment to create") String iName, @ConsoleParameter(name="datasegment-location", description="The directory where to place the files", optional=true) String iLocation) {
        this.checkForDatabase();
        if (iLocation != null) {
            this.out.println("Creating data-segment [" + iName + "] in database " + this.currentDatabaseName + " in path: " + iLocation + "...");
        } else {
            this.out.println("Creating data-segment [" + iName + "] in database directory...");
        }
        this.currentDatabase.addDataSegment(iName, iLocation);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Create a new cluster in the current database. The cluster can be physical or memory")
    public void createCluster(@ConsoleParameter(name="cluster-name", description="The name of the cluster to create") String iClusterName, @ConsoleParameter(name="cluster-type", description="Cluster type: 'physical' or 'memory'") String iClusterType, @ConsoleParameter(name="data-segment", description="Data segment to use. 'default' will use the default one") String iDataSegmentName, @ConsoleParameter(name="location", description="Location where to place the new cluster files, if appliable. use 'default' to leave into the database directory") String iLocation, @ConsoleParameter(name="position", description="cluster id to replace, an empty position or 'append' to append at the end") String iPosition) {
        int position;
        this.checkForDatabase();
        int n = position = iPosition.toLowerCase().equals("append") ? -1 : Integer.parseInt(iPosition);
        if ("default".equalsIgnoreCase(iLocation)) {
            iLocation = null;
        }
        this.out.println("Creating cluster [" + iClusterName + "] of type '" + iClusterType + "' in database " + this.currentDatabaseName + (position == -1 ? " as last one" : " in place of #" + position) + "...");
        iClusterType = iClusterType.toUpperCase();
        int clusterId = this.currentDatabase.addCluster(iClusterType, iClusterName, iLocation, iDataSegmentName, new Object[0]);
        this.out.println(String.valueOf(this.currentDatabase.getClusterType(iClusterName)) + " cluster created correctly with id #" + clusterId);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Remove a cluster in the current database. The cluster can be physical or memory")
    public void dropCluster(@ConsoleParameter(name="cluster-name", description="The name or the id of the cluster to remove") String iClusterName) {
        this.checkForDatabase();
        this.out.println("Dropping cluster [" + iClusterName + "] in database " + this.currentDatabaseName + "...");
        boolean result = this.currentDatabase.dropCluster(iClusterName);
        if (!result) {
            try {
                int clusterId = Integer.parseInt(iClusterName);
                if (clusterId > -1) {
                    result = this.currentDatabase.dropCluster(clusterId);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result) {
            this.out.println("Cluster correctly removed");
        } else {
            this.out.println("Cannot find the cluster to remove");
        }
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alters a cluster in the current database. The cluster can be physical or memory")
    public void alterCluster(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nCluster updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Shows the holes in current storage")
    public void showHoles() throws IOException {
        this.checkForDatabase();
        if (!(this.currentDatabase.getStorage() instanceof OStorageLocal)) {
            this.out.println("Error: cannot show holes in databases different by local");
            return;
        }
        OStorageLocal storage = (OStorageLocal)this.currentDatabase.getStorage();
        this.out.println("List of holes in database " + this.currentDatabaseName + "...");
        this.out.println("--------------------------------------------------");
        this.out.println("Position             Size");
        this.out.println("--------------------------------------------------");
        List result = storage.getHolesList();
        for (ODataHoleInfo ppos : result) {
            this.out.printf("%20d %11d\n", ppos.dataOffset, ppos.size);
        }
        this.out.println("--------------------------------------------------");
    }

    @ConsoleCommand(description="Begins a transaction. All the changes will remain local")
    public void begin() throws IOException {
        this.checkForDatabase();
        if (this.currentDatabase.getTransaction().isActive()) {
            this.out.println("Error: an active transaction is currently open (id=" + this.currentDatabase.getTransaction().getId() + "). Commit or rollback before starting a new one.");
            return;
        }
        this.currentDatabase.begin();
        this.out.println("Transaction " + this.currentDatabase.getTransaction().getId() + " is running");
    }

    @ConsoleCommand(description="Commits transaction changes to the database")
    public void commit() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.out.println("Error: no active transaction is currently open.");
            return;
        }
        this.currentDatabase.commit();
        this.out.println("Transaction " + this.currentDatabase.getTransaction().getId() + " has been committed");
    }

    @ConsoleCommand(description="Rolls back transaction changes to the previous state")
    public void rollback() throws IOException {
        this.checkForDatabase();
        if (!this.currentDatabase.getTransaction().isActive()) {
            this.out.println("Error: no active transaction is running right now.");
            return;
        }
        this.currentDatabase.rollback();
        this.out.println("Transaction " + this.currentDatabase.getTransaction().getId() + " has been rollbacked");
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the class content in the current database")
    public void truncateClass(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate the cluster content in the current database")
    public void truncateCluster(@ConsoleParameter(name="text", description="The name of the class to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Truncate a record deleting it at low level")
    public void truncateRecord(@ConsoleParameter(name="text", description="The record(s) to truncate") String iCommandText) {
        this.sqlCommand("truncate", iCommandText, "\nTruncated %d record(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(description="Load a record in memory using passed fetch plan")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.loadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Load a record in memory and set it as the current")
    public void loadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.loadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(description="Reloads a record using passed fetch plan")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId, @ConsoleParameter(name="fetch-plan", description="The fetch plan to load the record with") String iFetchPlan) {
        this.reloadRecordInternal(iRecordId, iFetchPlan);
    }

    @ConsoleCommand(description="Reload a record and set it as the current one")
    public void reloadRecord(@ConsoleParameter(name="record-id", description="The unique Record Id of the record to load. If you do not have the Record Id, execute a query first") String iRecordId) {
        this.reloadRecordInternal(iRecordId, null);
    }

    @ConsoleCommand(splitInWords=false, description="Insert a new record into the database")
    public void insert(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("insert", iCommandText, "\nInserted record '%s' in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Update records in the database")
    public void update(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("update", iCommandText, "\nUpdated %d record(s) in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLevel1Cache().invalidate();
        this.currentDatabase.getLevel2Cache().clear();
    }

    @ConsoleCommand(splitInWords=false, description="Delete records from the database")
    public void delete(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("delete", iCommandText, "\nDelete %d record(s) in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.currentDatabase.getLevel1Cache().invalidate();
        this.currentDatabase.getLevel2Cache().clear();
    }

    @ConsoleCommand(splitInWords=false, description="Grant privileges to a role")
    public void grant(@ConsoleParameter(name="text", description="Grant command") String iCommandText) {
        this.sqlCommand("grant", iCommandText, "\nPrivilege granted to the role: %s\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Revoke privileges to a role")
    public void revoke(@ConsoleParameter(name="text", description="Revoke command") String iCommandText) {
        this.sqlCommand("revoke", iCommandText, "\nPrivilege revoked to the role: %s\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Create a link from a JOIN")
    public void createLink(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nCreated %d link(s) in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Find all references the target record id @rid")
    public void findReferences(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("find", iCommandText, "\nFound %s in %f sec(s).\n", true);
    }

    @ConsoleCommand(splitInWords=false, description="Alter a database property")
    public void alterDatabase(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nDatabase updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class in the database schema")
    public void alterClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nClass updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a class")
    public void createClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nClass created successfully with id=%d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Alter a class property in the database schema")
    public void alterProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("alter", iCommandText, "\nProperty updated successfully\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Create a property")
    public void createProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) {
        this.sqlCommand("create", iCommandText, "\nProperty created successfully with id=%d\n", true);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Traverse records and display the results")
    public void traverse(@ConsoleParameter(name="query-text", description="The traverse to execute") String iQueryText) {
        ArrayList<String> columns = new ArrayList<String>();
        int limit = iQueryText.contains("limit") ? -1 : Integer.parseInt((String)this.properties.get("limit"));
        long start = System.currentTimeMillis();
        this.currentResultSet = (List)this.currentDatabase.command((OCommandRequest)new OCommandSQL("traverse " + iQueryText)).execute(new Object[0]);
        int i = 0;
        for (OIdentifiable record : this.currentResultSet) {
            this.dumpRecordInTable(i++, record, columns);
        }
        if (this.currentResultSet.size() > 0 && (limit == -1 || this.currentResultSet.size() < limit)) {
            this.printHeaderLine(columns);
        }
        this.out.println("\n" + this.currentResultSet.size() + " item(s) found. Traverse executed in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " sec(s).");
    }

    @ConsoleCommand(splitInWords=false, description="Execute a query against the database and display the results")
    public void select(@ConsoleParameter(name="query-text", description="The query to execute") String iQueryText) {
        this.checkForDatabase();
        if (iQueryText == null) {
            return;
        }
        if ((iQueryText = iQueryText.trim()).length() == 0 || iQueryText.equalsIgnoreCase("select")) {
            return;
        }
        int limit = (iQueryText = "select " + iQueryText).contains("limit") ? -1 : Integer.parseInt((String)this.properties.get("limit"));
        long start = System.currentTimeMillis();
        this.currentResultSet = this.currentDatabase.query(new OSQLSynchQuery(iQueryText, limit).setFetchPlan("*:1"), new Object[0]);
        this.dumpResultSet(limit);
        this.out.println("\n" + this.currentResultSet.size() + " item(s) found. Query executed in " + (float)(System.currentTimeMillis() - start) / 1000.0f + " sec(s).");
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands in the console")
    public void js(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        if (iText == null) {
            return;
        }
        long start = System.currentTimeMillis();
        this.currentResultSet.clear();
        OCommandExecutorScript cmd = new OCommandExecutorScript();
        cmd.parse((OCommandRequest)new OCommandScript("javascript", iText));
        Object result = cmd.execute(null);
        if (result instanceof Collection) {
            this.currentResultSet = (List)result;
            this.dumpResultSet(-1);
            this.out.printf("Client side script executed in %f sec(s). Returned %d records", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f), this.currentResultSet.size());
        } else {
            this.out.printf("Client side script executed in %f sec(s). Value returned is: %s", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f), result);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Execute javascript commands against a remote server")
    public void jss(@ConsoleParameter(name="text", description="The javascript to execute. Use 'db' to reference to a document database, 'gdb' for a graph database") String iText) {
        this.checkForRemoteServer();
        if (iText == null) {
            return;
        }
        long start = System.currentTimeMillis();
        this.currentResultSet.clear();
        Object result = this.currentDatabase.command((OCommandRequest)new OCommandScript("javascript", iText.toString())).execute(new Object[0]);
        if (result instanceof Collection) {
            this.currentResultSet = (List)result;
            this.dumpResultSet(-1);
            this.out.printf("Server side script executed in %f sec(s). Returned %d records", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f), this.currentResultSet.size());
        } else {
            this.out.printf("Server side script executed in %f sec(s). Value returned is: %s", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f), result);
        }
    }

    @ConsoleCommand(splitInWords=false, description="Create an index against a property")
    public void createIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.out.println("\nCreating index...");
        this.sqlCommand("create", iCommandText, "\nCreated index successfully with %d entries in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.out.println("\nIndex created successfully");
    }

    @ConsoleCommand(description="Delete the current database")
    public void dropDatabase() throws IOException {
        this.checkForDatabase();
        String dbName = this.currentDatabase.getName();
        if (this.currentDatabase.getURL().startsWith("remote")) {
            if (this.serverAdmin == null) {
                this.out.println("\nCannot drop a remote database without connecting to the server with a valid server's user");
                return;
            }
            String dbURL = this.currentDatabase.getURL().substring("remote".length() + 1);
            new OServerAdmin(dbURL).connect(this.currentDatabaseUserName, this.currentDatabaseUserPassword).dropDatabase();
        } else {
            this.currentDatabase.drop();
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.out.println("\nDatabase '" + dbName + "' deleted successfully");
    }

    @ConsoleCommand(description="Delete the specified database")
    public void dropDatabase(@ConsoleParameter(name="database-url", description="The url of the database to drop in the format '<mode>:<path>'") String iDatabaseURL, @ConsoleParameter(name="user", description="Server administrator name") String iUserName, @ConsoleParameter(name="password", description="Server administrator password") String iUserPassword) throws IOException {
        if (iDatabaseURL.startsWith("remote")) {
            String dbURL = iDatabaseURL.substring("remote".length() + 1);
            this.serverAdmin = new OServerAdmin(dbURL).connect(iUserName, iUserPassword);
            this.serverAdmin.dropDatabase();
            this.disconnect();
        } else {
            this.currentDatabase = new ODatabaseDocumentTx(iDatabaseURL);
            this.currentDatabase.drop();
            this.currentDatabase = null;
            this.currentDatabaseName = null;
        }
        this.out.println("\nDatabase '" + iDatabaseURL + "' deleted successfully");
    }

    @ConsoleCommand(splitInWords=false, description="Remove an index")
    public void dropIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.out.println("\nRemoving index...");
        this.sqlCommand("drop", iCommandText, "\nDropped index in %f sec(s).\n", false);
        this.updateDatabaseInfo();
        this.out.println("\nIndex removed successfully");
    }

    @ConsoleCommand(splitInWords=false, description="Rebuild an index if it is automatic")
    public void rebuildIndex(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.out.println("\nRebuilding index(es)...");
        this.sqlCommand("rebuild", iCommandText, "\nRebuilt index(es). Found %d link(s) in %f sec(s).\n", true);
        this.updateDatabaseInfo();
        this.out.println("\nIndex(es) rebuilt successfully");
    }

    @ConsoleCommand(splitInWords=false, description="Remove a class from the schema")
    public void dropClass(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(splitInWords=false, description="Remove a property from a class")
    public void dropProperty(@ConsoleParameter(name="command-text", description="The command text to execute") String iCommandText) throws IOException {
        this.sqlCommand("drop", iCommandText, "\nRemoved class property in %f sec(s).\n", false);
        this.updateDatabaseInfo();
    }

    @ConsoleCommand(description="Browse all records of a class")
    public void browseClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        this.checkForDatabase();
        this.currentResultSet.clear();
        ArrayList<String> columns = new ArrayList<String>();
        int limit = Integer.parseInt((String)this.properties.get("limit"));
        ORecordIteratorClass it = this.currentDatabase.browseClass(iClassName);
        this.browseRecords((List<String>)columns, limit, (OIdentifiableIterator<?>)it);
    }

    @ConsoleCommand(description="Browse all records of a cluster")
    public void browseCluster(@ConsoleParameter(name="cluster-name", description="The name of the cluster") String iClusterName) {
        this.checkForDatabase();
        this.currentResultSet.clear();
        ArrayList<String> columns = new ArrayList<String>();
        int limit = Integer.parseInt((String)this.properties.get("limit"));
        ORecordIteratorCluster it = this.currentDatabase.browseCluster(iClusterName);
        this.browseRecords((List<String>)columns, limit, (OIdentifiableIterator<?>)it);
    }

    @ConsoleCommand(aliases={"display"}, description="Display current record attributes")
    public void displayRecord(@ConsoleParameter(name="number", description="The number of the record in the most recent result set") String iRecordNumber) {
        this.checkForDatabase();
        if (iRecordNumber == null) {
            this.checkCurrentObject();
        } else {
            int recNumber = Integer.parseInt(iRecordNumber);
            if (this.currentResultSet.size() == 0) {
                throw new OException("No result set where to find the requested record. Execute a query first.");
            }
            if (this.currentResultSet.size() <= recNumber) {
                throw new OException("The record requested is not part of current result set (0" + (this.currentResultSet.size() > 0 ? "-" + (this.currentResultSet.size() - 1) : "") + ")");
            }
            this.currentRecord = (ORecordInternal)this.currentResultSet.get(recNumber).getRecord();
        }
        this.dumpRecordDetails();
    }

    @ConsoleCommand(description="Display a record as raw bytes")
    public void displayRawRecord(@ConsoleParameter(name="rid", description="The record id to display") String iRecordId) {
        this.checkForDatabase();
        ORecordId rid = new ORecordId(iRecordId);
        ORawBuffer buffer = this.currentDatabase.getStorage().readRecord(rid, null, false, null);
        if (buffer == null) {
            throw new OException("The record has been deleted");
        }
        String content = Integer.parseInt((String)this.properties.get("maxBinaryDisplay")) < buffer.buffer.length ? new String(Arrays.copyOf(buffer.buffer, Integer.parseInt((String)this.properties.get("maxBinaryDisplay")))) : new String(buffer.buffer);
        this.out.println("Raw record content. The size is " + buffer.buffer.length + " bytes, while settings force to print first " + content.length() + " bytes:\n\n" + new String(content));
    }

    @ConsoleCommand(aliases={"status"}, description="Display information about the database")
    public void info() {
        if (this.currentDatabaseName != null) {
            this.out.println("Current database: " + this.currentDatabaseName + " (url=" + this.currentDatabase.getURL() + ")");
            OStorage stg = this.currentDatabase.getStorage();
            this.out.println("\nTotal size: " + OFileUtils.getSizeAsString((long)stg.getSize()));
            if (stg instanceof OStorageRemoteThread) {
                ODocument clusterConfig = ((OStorageRemoteThread)stg).getClusterConfiguration();
                if (clusterConfig != null) {
                    this.out.println("\nCluster configuration: " + clusterConfig.toJSON("indent:2"));
                } else {
                    this.out.println("\nCluster configuration: none");
                }
            } else if (stg instanceof OStorageLocal) {
                OStorageLocal localStorage = (OStorageLocal)stg;
                long holeSize = localStorage.getHoleSize();
                this.out.print("\nFragmented at " + (float)holeSize * 100.0f / (float)localStorage.getSize() + "%");
                this.out.println(" (" + localStorage.getHoles() + " holes, total size of holes: " + OFileUtils.getSizeAsString((long)holeSize) + ")");
            }
            this.clusters();
            this.classes();
            this.indexes();
        }
    }

    @ConsoleCommand(aliases={"desc"}, description="Display the schema of a class")
    public void infoClass(@ConsoleParameter(name="class-name", description="The name of the class") String iClassName) {
        Set indexes;
        if (this.currentDatabaseName == null) {
            this.out.println("No database selected yet.");
            return;
        }
        OClass cls = this.currentDatabase.getMetadata().getSchema().getClass(iClassName);
        if (cls == null) {
            this.out.println("! Class '" + iClassName + "' does not exist in the database '" + this.currentDatabaseName + "'");
            return;
        }
        this.out.println();
        this.out.println("Class................: " + cls);
        if (cls.getShortName() != null) {
            this.out.println("Alias................: " + cls.getShortName());
        }
        if (cls.getSuperClass() != null) {
            this.out.println("Super class..........: " + cls.getSuperClass());
        }
        this.out.println("Default cluster......: " + this.currentDatabase.getClusterNameById(cls.getDefaultClusterId()) + " (id=" + cls.getDefaultClusterId() + ")");
        this.out.println("Supported cluster ids: " + Arrays.toString(cls.getClusterIds()));
        if (cls.getBaseClasses() != null) {
            this.out.print("Base classes.........: ");
            int i = 0;
            Iterator it = cls.getBaseClasses();
            while (it.hasNext()) {
                if (i > 0) {
                    this.out.print(", ");
                }
                this.out.print(((OClass)it.next()).getName());
                ++i;
            }
            this.out.println();
        }
        if (cls.properties().size() > 0) {
            this.out.println("Properties:");
            this.out.println("-------------------------------+-------------+-------------------------------+-----------+----------+-----------+-----------+");
            this.out.println(" NAME                          | TYPE        | LINKED TYPE/CLASS             | MANDATORY | NOT NULL |    MIN    |    MAX    |");
            this.out.println("-------------------------------+-------------+-------------------------------+-----------+----------+-----------+-----------+");
            for (OProperty p : cls.properties()) {
                try {
                    this.out.printf(" %-30s| %-12s| %-30s| %-10s| %-9s| %-10s| %-10s|\n", p.getName(), p.getType(), p.getLinkedClass() != null ? p.getLinkedClass() : p.getLinkedType(), p.isMandatory(), p.isNotNull(), p.getMin() != null ? p.getMin() : "", p.getMax() != null ? p.getMax() : "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.out.println("-------------------------------+-------------+-------------------------------+-----------+----------+-----------+-----------+");
        }
        if (!(indexes = cls.getClassIndexes()).isEmpty()) {
            this.out.println("Indexes (" + indexes.size() + " altogether):");
            this.out.println("-------------------------------+----------------+");
            this.out.println(" NAME                          | PROPERTIES     |");
            this.out.println("-------------------------------+----------------+");
            for (OIndex index : indexes) {
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition != null) {
                    List fields = indexDefinition.getFields();
                    this.out.printf(" %-30s| %-15s|\n", index.getName(), String.valueOf((String)fields.get(0)) + (fields.size() > 1 ? " (+)" : ""));
                    int i = 1;
                    while (i < fields.size()) {
                        if (i < fields.size() - 1) {
                            this.out.printf(" %-30s| %-15s|\n", "", String.valueOf((String)fields.get(i)) + " (+)");
                        } else {
                            this.out.printf(" %-30s| %-15s|\n", "", fields.get(i));
                        }
                        ++i;
                    }
                    continue;
                }
                this.out.printf(" %-30s| %-15s|\n", index.getName(), "");
            }
            this.out.println("-------------------------------+----------------+");
        }
    }

    @ConsoleCommand(description="Display all indexes")
    public void indexes() {
        if (this.currentDatabaseName != null) {
            this.out.println("\nINDEXES:");
            this.out.println("----------------------------------------------+------------+-----------------------+----------------+-----------+");
            this.out.println(" NAME                                         | TYPE       |         CLASS         |     FIELDS     | RECORDS   |");
            this.out.println("----------------------------------------------+------------+-----------------------+----------------+-----------+");
            int totalIndexes = 0;
            long totalRecords = 0L;
            for (OIndex index : this.currentDatabase.getMetadata().getIndexManager().getIndexes()) {
                try {
                    OIndexDefinition indexDefinition = index.getDefinition();
                    if (indexDefinition == null || indexDefinition.getClassName() == null) {
                        this.out.printf(" %-45s| %-10s | %-22s| %-15s|%10d |\n", index.getName(), index.getType(), "", "", index.getSize());
                    } else {
                        List fields = indexDefinition.getFields();
                        if (fields.size() == 1) {
                            this.out.printf(" %-45s| %-10s | %-22s| %-15s|%10d |\n", index.getName(), index.getType(), indexDefinition.getClassName(), fields.get(0), index.getSize());
                        } else {
                            this.out.printf(" %-45s| %-10s | %-22s| %-15s|%10d |\n", index.getName(), index.getType(), indexDefinition.getClassName(), fields.get(0), index.getSize());
                            int i = 1;
                            while (i < fields.size()) {
                                this.out.printf(" %-45s| %-10s | %-22s| %-15s|%10s |\n", "", "", "", fields.get(i), "");
                                ++i;
                            }
                        }
                    }
                    ++totalIndexes;
                    totalRecords += index.getSize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.out.println("----------------------------------------------+------------+-----------------------+----------------+-----------+");
            this.out.printf(" TOTAL = %-3d                                                                                    %15d |\n", totalIndexes, totalRecords);
            this.out.println("----------------------------------------------------------------------------------------------------------------+\n");
        } else {
            this.out.println("No database selected yet.");
        }
    }

    @ConsoleCommand(description="Display all the configured clusters")
    public void clusters() {
        if (this.currentDatabaseName != null) {
            this.out.println("\nCLUSTERS:");
            this.out.println("----------------------------------------------+------+---------------------+-----------+--------------+");
            this.out.println(" NAME                                         |  ID  | TYPE                | RECORDS   | SIZE         |");
            this.out.println("----------------------------------------------+------+---------------------+-----------+--------------+");
            String clusterType = null;
            long totalElements = 0L;
            long size = 0L;
            long totalSize = 0L;
            for (String clusterName : this.currentDatabase.getClusterNames()) {
                try {
                    int clusterId = this.currentDatabase.getClusterIdByName(clusterName);
                    clusterType = this.currentDatabase.getClusterType(clusterName);
                    long count = this.currentDatabase.countClusterElements(clusterName);
                    if (this.currentDatabase.getStorage() instanceof OStorageEmbedded) {
                        size = this.currentDatabase.getClusterRecordSizeByName(clusterName);
                        totalElements += count;
                        totalSize += size;
                        this.out.printf(" %-45s|%6d| %-20s|%10d |%10s |\n", clusterName, clusterId, clusterType, count, OFileUtils.getSizeAsString((long)size));
                        continue;
                    }
                    this.out.printf(" %-45s|%6d| %-20s|%10d |%10s |\n", clusterName, clusterId, clusterType, count, "Not supported");
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.out.println("----------------------------------------------+------+---------------------+-----------+--------------+");
            this.out.printf(" TOTAL                                                                 %15d | %9s |\n", totalElements, OFileUtils.getSizeAsString((long)totalSize));
            this.out.println("---------------------------------------------------------------------------------------+--------------+");
        } else {
            this.out.println("No database selected yet.");
        }
    }

    @ConsoleCommand(description="Display all the configured classes")
    public void classes() {
        if (this.currentDatabaseName != null) {
            this.out.println("\nCLASSES:");
            this.out.println("----------------------------------------------+---------------------+-----------+");
            this.out.println(" NAME                                         | CLUSTERS            | RECORDS   |");
            this.out.println("----------------------------------------------+---------------------+-----------+");
            long totalElements = 0L;
            for (OClass cls : this.currentDatabase.getMetadata().getSchema().getClasses()) {
                try {
                    StringBuilder clusters = new StringBuilder();
                    int i = 0;
                    while (i < cls.getClusterIds().length) {
                        if (i > 0) {
                            clusters.append(", ");
                        }
                        clusters.append(cls.getClusterIds()[i]);
                        ++i;
                    }
                    long count = this.currentDatabase.countClass(cls.getName());
                    totalElements += count;
                    this.out.printf(" %-45s| %-20s|%10d |\n", cls.getName(), clusters, count);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.out.println("----------------------------------------------+---------------------+-----------+");
            this.out.printf(" TOTAL                                                          %15d |\n", totalElements);
            this.out.println("--------------------------------------------------------------------------------+");
        } else {
            this.out.println("No database selected yet.");
        }
    }

    @ConsoleCommand(description="Display all keys in the database dictionary")
    public void dictionaryKeys() {
        this.checkForDatabase();
        Iterable keys = this.currentDatabase.getDictionary().keys();
        int i = 0;
        for (Object k : keys) {
            this.out.print(String.format("#%d: %s\n", i++, k));
        }
        this.out.println("Found " + i + " keys:");
    }

    @ConsoleCommand(description="Loook up a record using the dictionary. If found, set it as the current record")
    public void dictionaryGet(@ConsoleParameter(name="key", description="The key to search") String iKey) {
        this.checkForDatabase();
        this.currentRecord = (ORecordInternal)this.currentDatabase.getDictionary().get(iKey);
        if (this.currentRecord == null) {
            this.out.println("Entry not found in dictionary.");
        } else {
            this.currentRecord = (ORecordInternal)this.currentRecord.load();
            this.displayRecord(null);
        }
    }

    @ConsoleCommand(description="Insert or modify an entry in the database dictionary. The entry is comprised of key=String, value=record-id")
    public void dictionaryPut(@ConsoleParameter(name="key", description="The key to bind") String iKey, @ConsoleParameter(name="record-id", description="The record-id of the record to bind to the key") String iRecordId) {
        this.checkForDatabase();
        this.currentRecord = (ORecordInternal)this.currentDatabase.load((ORID)new ORecordId(iRecordId));
        if (this.currentRecord == null) {
            this.out.println("Error: record with id '" + iRecordId + "' was not found in database");
        } else {
            this.currentDatabase.getDictionary().put(iKey, (Object)((ODocument)this.currentRecord));
            this.displayRecord(null);
            this.out.println("The entry " + iKey + "=" + iRecordId + " has been inserted in the database dictionary");
        }
    }

    @ConsoleCommand(description="Remove the association in the dictionary")
    public void dictionaryRemove(@ConsoleParameter(name="key", description="The key to remove") String iKey) {
        this.checkForDatabase();
        boolean result = this.currentDatabase.getDictionary().remove(iKey);
        if (!result) {
            this.out.println("Entry not found in dictionary.");
        } else {
            this.out.println("Entry removed from the dictionary.");
        }
    }

    @ConsoleCommand(description="Copy a database to a remote server")
    public void copyDatabase(@ConsoleParameter(name="db-name", description="Name of the database to share") String iDatabaseName, @ConsoleParameter(name="db-user", description="Database user") String iDatabaseUserName, @ConsoleParameter(name="db-password", description="Database password") String iDatabaseUserPassword, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName, @ConsoleParameter(name="engine-name", description="Remote server's engine to use between 'local' or 'memory'") String iRemoteEngine) throws IOException {
        try {
            if (this.serverAdmin == null) {
                throw new IllegalStateException("You must be connected to a remote server to share a database");
            }
            this.out.println("Copying database '" + iDatabaseName + "' to the server '" + iRemoteName + "' via network streaming...");
            this.serverAdmin.copyDatabase(iDatabaseName, iDatabaseUserName, iDatabaseUserPassword, iRemoteName, iRemoteEngine);
            this.out.println("Database '" + iDatabaseName + "' has been copied to the server '" + iRemoteName + "'");
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Start the replication of a database against a remote server")
    public void replicationStart(@ConsoleParameter(name="db-name", description="Name of the database") String iDatabaseName, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName) throws IOException {
        this.checkForRemoteServer();
        try {
            this.out.println("Starting replication for database '" + iDatabaseName + "' between server '" + this.serverAdmin.getURL() + "' and '" + iRemoteName + "'...");
            this.serverAdmin.replicationStart(iDatabaseName, iRemoteName);
            this.out.println("Replication successfully started");
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Stop the replication of a database against a remote server")
    public void replicationStop(@ConsoleParameter(name="db-name", description="Name of the database") String iDatabaseName, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName) throws IOException {
        this.checkForRemoteServer();
        try {
            this.serverAdmin.replicationStop(iDatabaseName, iRemoteName);
            this.out.println("Replication ended for database '" + iDatabaseName + "' against the server '" + iRemoteName + "'");
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Gets the replication journal for a database against a remote server")
    public void replicationGetJournal(@ConsoleParameter(name="db-name", description="Name of the database") String iDatabaseName, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName) throws IOException {
        this.checkForRemoteServer();
        try {
            ODocument response = this.serverAdmin.getReplicationJournal(iDatabaseName, iRemoteName);
            if (response.fieldNames().length == 0) {
                this.out.println("Replication journal for database '" + iDatabaseName + "' is empty");
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                this.out.println("Replication journal for database '" + iDatabaseName + "'\n");
                this.out.printf("+-----------+-----------+---------------+-------------------------+\n", new Object[0]);
                this.out.printf("| SERIAL    | OPERATION | RECORD ID     | DATE                    |\n", new Object[0]);
                this.out.printf("+-----------+-----------+---------------+-------------------------+\n", new Object[0]);
                String[] stringArray = response.fieldNames();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String k = stringArray[n2];
                    long opSerial = Long.parseLong(k);
                    String[] split = ((String)response.field(k)).split("-");
                    byte opType = (byte)Integer.parseInt(split[0]);
                    String opRID = split[1];
                    String date = split[2];
                    this.out.printf("| %-10d| %9s | %-14s| %23s |\n", opSerial, ORecordOperation.getName((int)opType), opRID, format.format(new Date(Long.parseLong(date))));
                    ++n2;
                }
                this.out.printf("+-----------+--------+---------------+-------------------------+\n", new Object[0]);
            }
            this.out.println();
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Resets the replication journal for a database against a remote server")
    public void replicationResetJournal(@ConsoleParameter(name="db-name", description="Name of the database") String iDatabaseName, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName) throws IOException {
        this.checkForRemoteServer();
        try {
            ODocument response = this.serverAdmin.resetReplicationJournal(iDatabaseName, iRemoteName);
            this.out.println("Reset replication journal for database '" + iDatabaseName + "': removed " + response.field("removedEntries") + " entries");
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Gets the replication conflicts for a database against a remote server")
    public void replicationGetConflicts(@ConsoleParameter(name="db-name", description="Name of the database") String iDatabaseName) throws IOException {
        this.checkForRemoteServer();
        try {
            ODocument response = this.serverAdmin.getReplicationConflicts(iDatabaseName);
            List entries = (List)response.field("entries");
            if (entries == null || entries.size() == 0) {
                this.out.println("There are not replication conflicts for database '" + iDatabaseName + "'");
            } else {
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                this.out.println("Replication conflicts for database '" + iDatabaseName + "'\n");
                this.out.printf("+---------------+-----------+-------------------------+--------------+---------------+-------------------+\n", new Object[0]);
                this.out.printf("| RECORD ID     | OPERATION | DATE                    | CURR VERSION | OTHER VERSION | OTHER CLUSTER POS |\n", new Object[0]);
                this.out.printf("+---------------+-----------+-------------------------+--------------+---------------+-------------------+\n", new Object[0]);
                for (ODocument doc : entries) {
                    this.out.printf("| %-14s| %-9s | %23s | %-12d | %-13d | %-17d |\n", doc.field("record", OType.LINK), ORecordOperation.getName((int)((Byte)doc.field("operation")).byteValue()), format.format((Date)doc.field("date")), doc.field("currentVersion"), doc.field("otherVersion"), doc.field("otherClusterPos"));
                }
                this.out.printf("+---------------+-----------+-------------------------+--------------+---------------+-------------------+\n", new Object[0]);
            }
            this.out.println();
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Displays the status of the cluster nodes")
    public void clusterStatus() throws IOException {
        this.checkForRemoteServer();
        try {
            this.out.println("Cluster status:");
            this.out.println(this.serverAdmin.clusterStatus().toJSON("attribSameRow,alwaysFetchEmbedded,fetchPlan:*:0"));
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Add a new server node to the current cluster")
    public void clusterAddNode(@ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iServerNode) throws IOException {
        this.checkForRemoteServer();
        try {
            this.out.println("Adding new server node '" + iServerNode + "' to the curret cluster...");
            this.out.println(this.serverAdmin.clusterAddNode(iServerNode));
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Remove a server node from the current cluster")
    public void clusterRemoveNode(@ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iServerNode) throws IOException {
        this.checkForRemoteServer();
        try {
            this.out.println("Removing server node '" + iServerNode + "' from the curret cluster...");
            this.out.println(this.serverAdmin.clusterRemoveNode(iServerNode));
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Align two databases in different servers")
    public void replicationAlign(@ConsoleParameter(name="db-name", description="Name of the database") String iDatabaseName, @ConsoleParameter(name="server-name", description="Remote server's name as <address>:<port>") String iRemoteName, @ConsoleParameter(name="options", description="Alignment options", optional=true) String iOptions) throws IOException {
        try {
            if (this.serverAdmin == null) {
                throw new IllegalStateException("You must be connected to a remote server to align database");
            }
            this.serverAdmin.replicationAlign(iDatabaseName, iRemoteName, iOptions);
            this.out.println("Alignment started for database '" + iDatabaseName + "' against the server '" + iRemoteName + "'");
        }
        catch (Exception e) {
            this.printError(e);
        }
    }

    @ConsoleCommand(description="Check database integrity")
    public void checkDatabase(@ConsoleParameter(name="options", description="Options: -v", optional=true) String iOptions) throws IOException {
        this.checkForDatabase();
        if (!(this.currentDatabase.getStorage() instanceof OStorageLocal)) {
            this.out.println("Cannot check integrity of non-local database. Connect to it using local mode.");
            return;
        }
        boolean verbose = iOptions != null && iOptions.indexOf("-v") > -1;
        try {
            ((OStorageLocal)this.currentDatabase.getStorage()).check(verbose, (OCommandOutputListener)this);
        }
        catch (ODatabaseImportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Compare two databases")
    public void compareDatabases(@ConsoleParameter(name="db1-url", description="URL of the first database") String iDb1URL, @ConsoleParameter(name="db2-url", description="URL of the second database") String iDb2URL, @ConsoleParameter(name="user-name", description="User name", optional=true) String iUserName, @ConsoleParameter(name="user-password", description="User password", optional=true) String iUserPassword) throws IOException {
        try {
            ODatabaseCompare compare = iUserName == null ? new ODatabaseCompare(iDb1URL, iDb2URL, (OCommandOutputListener)this) : new ODatabaseCompare(iDb1URL, iDb1URL, iUserName, iUserPassword, (OCommandOutputListener)this);
            compare.compare();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export a database")
    public void exportDatabase(@ConsoleParameter(name="output-file", description="Output file path") String iOutputFilePath) throws IOException {
        this.checkForDatabase();
        this.out.println("Exporting current database to: " + iOutputFilePath + "...");
        try {
            new ODatabaseExport((ODatabaseRecord)this.currentDatabase, iOutputFilePath, (OCommandOutputListener)this).exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export a database schema")
    public void exportSchema(@ConsoleParameter(name="output-file", description="Output file path") String iOutputFilePath) throws IOException {
        this.checkForDatabase();
        this.out.println("Exporting current database to: " + iOutputFilePath + "...");
        try {
            ODatabaseExport exporter = new ODatabaseExport((ODatabaseRecord)this.currentDatabase, iOutputFilePath, (OCommandOutputListener)this);
            exporter.setIncludeRecords(false);
            exporter.exportDatabase().close();
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Import a database into the current one")
    public void importDatabase(@ConsoleParameter(name="input-file", description="Input file path") String iInputFilePath) throws IOException {
        this.checkForDatabase();
        this.out.println("Importing database from file " + iInputFilePath + "...");
        try {
            new ODatabaseImport(this.currentDatabase, iInputFilePath, (OCommandOutputListener)this).importDatabase().close();
        }
        catch (ODatabaseImportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Export the current record in the requested format")
    public void exportRecord(@ConsoleParameter(name="format", description="Format, such as 'json'") String iFormat) throws IOException {
        this.checkForDatabase();
        this.checkCurrentObject();
        ORecordSerializer serializer = ORecordSerializerFactory.instance().getFormat(iFormat.toLowerCase());
        if (serializer == null) {
            this.out.println("ERROR: Format '" + iFormat + "' was not found.");
            this.printSupportedSerializerFormat();
            return;
        }
        if (!(serializer instanceof ORecordSerializerStringAbstract)) {
            this.out.println("ERROR: Format '" + iFormat + "' does not export as text.");
            this.printSupportedSerializerFormat();
            return;
        }
        try {
            this.out.println(((ORecordSerializerStringAbstract)serializer).toString(this.currentRecord, null));
        }
        catch (ODatabaseExportException e) {
            this.printError((Exception)((Object)e));
        }
    }

    @ConsoleCommand(description="Return all configured properties")
    public void properties() {
        this.out.println("PROPERTIES:");
        this.out.println("+---------------------+----------------------+");
        this.out.printf("| %-30s| %-30s |\n", "NAME", "VALUE");
        this.out.println("+---------------------+----------------------+");
        for (Map.Entry p : this.properties.entrySet()) {
            this.out.printf("| %-30s= %-30s |\n", p.getKey(), p.getValue());
        }
        this.out.println("+---------------------+----------------------+");
    }

    @ConsoleCommand(description="Return the value of a property")
    public void get(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName) {
        Object value = this.properties.get(iPropertyName);
        this.out.println();
        if (value == null) {
            this.out.println("Property '" + iPropertyName + "' is not setted");
        } else {
            this.out.println(String.valueOf(iPropertyName) + " = " + value);
        }
    }

    @ConsoleCommand(description="Change the value of a property")
    public void set(@ConsoleParameter(name="property-name", description="Name of the property") String iPropertyName, @ConsoleParameter(name="property-value", description="Value to set") String iPropertyValue) {
        Object prevValue = this.properties.get(iPropertyName);
        this.out.println();
        if (iPropertyName.equalsIgnoreCase("limit") && (Integer.parseInt(iPropertyValue) == 0 || Integer.parseInt(iPropertyValue) < -1)) {
            this.out.println("ERROR: Limit must be > 0 or = -1 (no limit)");
        } else {
            if (prevValue != null) {
                this.out.println("Previous value was: " + prevValue);
            }
            this.properties.put(iPropertyName, iPropertyValue);
            this.out.println();
            this.out.println(String.valueOf(iPropertyName) + " = " + iPropertyValue);
        }
    }

    @ConsoleCommand(description="Declare an intent")
    public void declareIntent(@ConsoleParameter(name="Intent name", description="name of the intent to execute") String iIntentName) {
        this.checkForDatabase();
        this.out.println("Declaring intent '" + iIntentName + "'...");
        if (iIntentName.equalsIgnoreCase("massiveinsert")) {
            this.currentDatabase.declareIntent((OIntent)new OIntentMassiveInsert());
        } else if (iIntentName.equalsIgnoreCase("massiveread")) {
            this.currentDatabase.declareIntent((OIntent)new OIntentMassiveRead());
        } else {
            throw new IllegalArgumentException("Intent '" + iIntentName + "' not supported. Available ones are: massiveinsert, massiveread");
        }
        this.out.println("Intent '" + iIntentName + "' setted successfully");
    }

    @ConsoleCommand(description="Execute a command against the profiler")
    public void profiler(@ConsoleParameter(name="profiler command", description="command to execute against the profiler") String iCommandName) {
        if (iCommandName.equalsIgnoreCase("on")) {
            OProfiler.getInstance().startRecording();
            this.out.println("Profiler is ON now, use 'profiler off' to turn off.");
        } else if (iCommandName.equalsIgnoreCase("off")) {
            OProfiler.getInstance().stopRecording();
            this.out.println("Profiler is OFF now, use 'profiler on' to turn on.");
        } else if (iCommandName.equalsIgnoreCase("dump")) {
            this.out.println(OProfiler.getInstance().dump());
        } else if (iCommandName.equalsIgnoreCase("reset")) {
            OProfiler.getInstance().reset();
            this.out.println("Profiler has been resetted");
        }
    }

    @ConsoleCommand(description="Return the value of a configuration value")
    public void configGet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName) throws IOException {
        String value;
        OGlobalConfiguration config = OGlobalConfiguration.findByKey((String)iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' wasn't found");
        }
        if (this.serverAdmin != null) {
            value = this.serverAdmin.getGlobalConfiguration(config);
            this.out.print("\nRemote configuration: ");
        } else {
            value = config.getValueAsString();
            this.out.print("\nLocal configuration: ");
        }
        this.out.println(String.valueOf(iConfigName) + " = " + value);
    }

    @ConsoleCommand(description="Sleep X milliseconds")
    public void sleep(String iTime) {
        try {
            Thread.sleep(Long.parseLong(iTime));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @ConsoleCommand(description="Change the value of a configuration value")
    public void configSet(@ConsoleParameter(name="config-name", description="Name of the configuration") String iConfigName, @ConsoleParameter(name="config-value", description="Value to set") String iConfigValue) throws IOException {
        OGlobalConfiguration config = OGlobalConfiguration.findByKey((String)iConfigName);
        if (config == null) {
            throw new IllegalArgumentException("Configuration variable '" + iConfigName + "' not found");
        }
        if (this.serverAdmin != null) {
            this.serverAdmin.setGlobalConfiguration(config, iConfigValue);
            this.out.println("\nRemote configuration value changed correctly");
        } else {
            config.setValue((Object)iConfigValue);
            this.out.println("\nLocal configuration value changed correctly");
        }
        this.out.println();
    }

    @ConsoleCommand(description="Return all the configuration values")
    public void config() throws IOException {
        if (this.serverAdmin != null) {
            Map<String, String> values = this.serverAdmin.getGlobalConfigurations();
            this.out.println("REMOTE SERVER CONFIGURATION:");
            this.out.println("+------------------------------------+--------------------------------+");
            this.out.printf("| %-35s| %-30s |\n", "NAME", "VALUE");
            this.out.println("+------------------------------------+--------------------------------+");
            for (Map.Entry<String, String> p : values.entrySet()) {
                this.out.printf("| %-35s= %-30s |\n", p.getKey(), p.getValue());
            }
        } else {
            this.out.println("LOCAL SERVER CONFIGURATION:");
            this.out.println("+------------------------------------+--------------------------------+");
            this.out.printf("| %-35s| %-30s |\n", "NAME", "VALUE");
            this.out.println("+------------------------------------+--------------------------------+");
            OGlobalConfiguration[] oGlobalConfigurationArray = OGlobalConfiguration.values();
            int n = oGlobalConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                OGlobalConfiguration cfg = oGlobalConfigurationArray[n2];
                this.out.printf("| %-35s= %-30s |\n", cfg.getKey(), cfg.getValue());
                ++n2;
            }
        }
        this.out.println("+------------------------------------+--------------------------------+");
    }

    protected void loadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = (ORecordInternal)this.currentDatabase.load((ORID)new ORecordId(iRecordId), iFetchPlan);
        this.displayRecord(null);
        this.out.println("OK");
    }

    protected void reloadRecordInternal(String iRecordId, String iFetchPlan) {
        this.checkForDatabase();
        this.currentRecord = ((ODatabaseRecordAbstract)this.currentDatabase.getUnderlying()).executeReadRecord(new ORecordId(iRecordId), null, iFetchPlan, true);
        this.displayRecord(null);
        this.out.println("OK");
    }

    protected void checkForRemoteServer() {
        if (this.serverAdmin == null && (this.currentDatabase == null || !(this.currentDatabase.getStorage() instanceof OStorageRemoteThread) || this.currentDatabase.isClosed())) {
            throw new OException("Remote server is not connected. Use 'connect remote:<host>[:<port>][/<database-name>]' to connect");
        }
    }

    protected void checkForDatabase() {
        if (this.currentDatabase == null) {
            throw new OException("Database not selected. Use 'connect <database-name>' to connect to a database.");
        }
        if (this.currentDatabase.isClosed()) {
            throw new ODatabaseException("Database '" + this.currentDatabaseName + "' is closed");
        }
    }

    protected void checkCurrentObject() {
        if (this.currentRecord == null) {
            throw new OException("The is no current object selected: create a new one or load it");
        }
    }

    protected void dumpRecordInTable(int iIndex, OIdentifiable iRecord, List<String> iColumns) {
        ArrayList<String> recordColumns = new ArrayList<String>();
        if (iRecord instanceof ODocument) {
            String[] stringArray = ((ODocument)iRecord).fieldNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                recordColumns.add(fieldName);
                ++n2;
            }
        }
        this.dumpRecordInTable(iIndex, iRecord, recordColumns, iColumns);
    }

    protected void dumpRecordInTable(int iIndex, OIdentifiable iRecord, List<String> iRecordColumns, List<String> iColumns) {
        for (String fieldName : iRecordColumns) {
            boolean foundCol = false;
            for (String colName : iColumns) {
                if (!fieldName.equals(colName)) continue;
                foundCol = true;
                break;
            }
            if (foundCol) continue;
            iColumns.add(fieldName);
        }
        if (iIndex == 0) {
            this.out.printf("\n", new Object[0]);
            this.printHeaderLine(iColumns);
            this.out.print("  #| RID     |");
            int col = 0;
            for (String colName : iColumns) {
                if (col++ > 0) {
                    this.out.printf("|", new Object[0]);
                }
                this.out.printf("%-20s", colName);
            }
            this.out.printf("\n", new Object[0]);
            this.printHeaderLine(iColumns);
        }
        StringBuilder format = new StringBuilder("%3d|%9s");
        ArrayList<Object> vargs = new ArrayList<Object>();
        vargs.add(iIndex);
        if (iRecord.getIdentity().isValid()) {
            vargs.add(iRecord.getIdentity());
        } else {
            vargs.add("");
        }
        try {
            Object value = null;
            if (iRecord instanceof ORecordBytes) {
                format.append("|%-70s");
                vargs.add("<binary> (size=" + ((ORecordBytes)iRecord).toStream().length + " bytes)");
            } else if (iRecord instanceof ODocument) {
                ((ODocument)iRecord).setLazyLoad(false);
            }
            for (String colName : iColumns) {
                format.append("|%-20s");
                if (iRecord instanceof ORecordSchemaAwareAbstract) {
                    value = ((ORecordSchemaAwareAbstract)iRecord).field(colName);
                }
                if (value instanceof Collection) {
                    value = "[" + ((Collection)value).size() + "]";
                } else if (value instanceof ORecord) {
                    value = ((ORecord)value).getIdentity().equals((Object)ORecordId.EMPTY_RECORD_ID) ? ((ORecord)value).toString() : ((ORecord)value).getIdentity().toString();
                } else if (value instanceof Date) {
                    value = this.currentDatabase.getStorage().getConfiguration().getDateTimeFormatInstance().format((Date)value);
                } else if (value instanceof byte[]) {
                    value = "byte[" + ((byte[])value).length + "]";
                }
                vargs.add(value);
            }
            this.out.println(String.format(format.toString(), vargs.toArray()));
        }
        catch (Throwable t) {
            this.out.printf("%3d|%9s|%s\n", iIndex, iRecord.getIdentity(), "Error on loading record dued to: " + t);
        }
    }

    private void printHeaderLine(List<String> iColumns) {
        this.out.print("---+---------");
        if (iColumns.size() > 0) {
            int i = 0;
            while (i < iColumns.size()) {
                this.out.print("+");
                int k = 0;
                while (k < 20) {
                    this.out.print("-");
                    ++k;
                }
                ++i;
            }
        }
        this.out.print("\n");
    }

    private void dumpRecordDetails() {
        if (this.currentRecord instanceof ODocument) {
            ODocument rec = (ODocument)this.currentRecord;
            this.out.println("--------------------------------------------------");
            this.out.printf("ODocument - Class: %s   id: %s   v.%d\n", rec.getClassName(), rec.getIdentity().toString(), rec.getVersion());
            this.out.println("--------------------------------------------------");
            String[] stringArray = rec.fieldNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String fieldName = stringArray[n2];
                Object value = rec.field(fieldName);
                if (value instanceof byte[]) {
                    value = "byte[" + ((byte[])value).length + "]";
                }
                this.out.printf("%20s : %-20s\n", fieldName, value);
                ++n2;
            }
        } else if (this.currentRecord instanceof ORecordFlat) {
            ORecordFlat rec = (ORecordFlat)this.currentRecord;
            this.out.println("--------------------------------------------------");
            this.out.printf("Flat - record id: %s   v.%d\n", rec.getIdentity().toString(), rec.getVersion());
            this.out.println("--------------------------------------------------");
            this.out.print(rec.value());
        } else if (this.currentRecord instanceof ORecordBytes) {
            ORecordBytes rec = (ORecordBytes)this.currentRecord;
            this.out.println("--------------------------------------------------");
            this.out.printf("Flat - record id: %s   v.%d\n", rec.getIdentity().toString(), rec.getVersion());
            this.out.println("--------------------------------------------------");
            byte[] value = rec.toStream();
            int max = Math.min(Integer.parseInt((String)this.properties.get("maxBinaryDisplay")), Array.getLength(value));
            int i = 0;
            while (i < max) {
                this.out.printf("%03d", Array.getByte(value, i));
                ++i;
            }
        } else {
            this.out.println("--------------------------------------------------");
            this.out.printf("%s - record id: %s   v.%d\n", this.currentRecord.getClass().getSimpleName(), this.currentRecord.getIdentity().toString(), this.currentRecord.getVersion());
        }
        this.out.println();
    }

    public String ask(String iText) {
        this.out.print(iText);
        Scanner scanner = new Scanner(this.in);
        String answer = scanner.nextLine();
        scanner.close();
        return answer;
    }

    public void onMessage(String iText) {
        this.out.print(iText);
    }

    private void printSupportedSerializerFormat() {
        this.out.println("Supported formats are:");
        for (ORecordSerializer s : ORecordSerializerFactory.instance().getFormats()) {
            if (!(s instanceof ORecordSerializerStringAbstract)) continue;
            this.out.println("- " + s.toString());
        }
    }

    private void browseRecords(List<String> columns, int limit, OIdentifiableIterator<?> it) {
        while (it.hasNext()) {
            this.currentRecord = (ORecordInternal)((OIdentifiable)it.next()).getRecord();
            try {
                if (this.currentRecord instanceof ORecordSchemaAwareAbstract) {
                    this.dumpRecordInTable(this.currentResultSet.size(), (OIdentifiable)((ORecordSchemaAwareAbstract)this.currentRecord), columns);
                } else if (this.currentRecord != null) {
                    this.dumpRecordDetails();
                    this.out.println();
                }
                this.currentResultSet.add((OIdentifiable)this.currentRecord);
            }
            catch (Exception e) {
                this.out.printf("\n!Error on displaying record " + this.currentRecord.getIdentity() + ". Cause: " + e.getMessage(), new Object[0]);
            }
            if (limit <= -1 || this.currentResultSet.size() < limit) continue;
            this.printHeaderLine(columns);
            this.out.println("\nResultset contains more items not displayed (max=" + limit + ")");
            return;
        }
        this.printHeaderLine(columns);
    }

    private Object sqlCommand(String iExpectedCommand, String iReceivedCommand, String iMessage, boolean iIncludeResult) {
        this.checkForDatabase();
        if (iReceivedCommand == null) {
            return null;
        }
        long start = System.currentTimeMillis();
        iReceivedCommand = String.valueOf(iExpectedCommand) + " " + iReceivedCommand.trim();
        this.currentResultSet.clear();
        Object result = new OCommandSQL(iReceivedCommand).setProgressListener((OProgressListener)this).execute(new Object[0]);
        if (result != null && iIncludeResult) {
            this.out.printf(iMessage, result, Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
        } else {
            this.out.printf(iMessage, Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
        }
        return result;
    }

    public void onBegin(Object iTask, long iTotal) {
        this.lastPercentStep = 0;
        this.out.print("[");
        if (this.interactiveMode) {
            int i = 0;
            while (i < 10) {
                this.out.print(' ');
                ++i;
            }
            this.out.print("]   0%");
        }
    }

    public boolean onProgress(Object iTask, long iCounter, float iPercent) {
        int completitionBar = (int)iPercent / 10;
        if ((int)(iPercent * 10.0f) == this.lastPercentStep) {
            return true;
        }
        if (this.interactiveMode) {
            this.out.print("\r[");
            int i = 0;
            while (i < completitionBar) {
                this.out.print('=');
                ++i;
            }
            i = completitionBar;
            while (i < 10) {
                this.out.print(' ');
                ++i;
            }
            this.out.printf("] %3.1f%% ", Float.valueOf(iPercent));
        } else {
            int i = this.lastPercentStep / 100;
            while (i < completitionBar) {
                this.out.print('=');
                ++i;
            }
        }
        this.lastPercentStep = (int)(iPercent * 10.0f);
        return true;
    }

    public void onCompletition(Object iTask, boolean iSucceed) {
        if (this.interactiveMode) {
            if (iSucceed) {
                this.out.print("\r[==========] 100% Done.");
            } else {
                this.out.print(" Error!");
            }
        } else {
            this.out.print(iSucceed ? "] Done." : " Error!");
        }
    }

    @Override
    protected void printApplicationInfo() {
        this.out.println("OrientDB console v." + OConstants.getVersion() + " " + "www.orientechnologies.com");
        this.out.println("Type 'help' to display all the commands supported.");
    }

    protected static boolean setTerminalToCBreak() throws IOException, InterruptedException {
        int result = OConsoleDatabaseApp.stty("-icanon min 1");
        if (result != 0) {
            return false;
        }
        OConsoleDatabaseApp.stty("-echo");
        return true;
    }

    protected void dumpResultSet(int limit) {
        int i = 0;
        ArrayList<String> columns = new ArrayList<String>();
        for (OIdentifiable record : this.currentResultSet) {
            this.dumpRecordInTable(i++, record, columns);
        }
        if (this.currentResultSet.size() > 0 && (limit == -1 || this.currentResultSet.size() < limit)) {
            this.printHeaderLine(columns);
        }
    }

    protected static int stty(String args) throws IOException, InterruptedException {
        String cmd = "stty " + args + " < /dev/tty";
        return OConsoleDatabaseApp.exec(new String[]{"sh", "-c", cmd});
    }

    private static int exec(String[] cmd) throws IOException, InterruptedException {
        int c;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Process p = Runtime.getRuntime().exec(cmd);
        InputStream in = p.getInputStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        in = p.getErrorStream();
        while ((c = in.read()) != -1) {
            bout.write(c);
        }
        p.waitFor();
        return p.exitValue();
    }

    private void printError(Exception e) {
        if (this.properties.get("debug") != null && Boolean.parseBoolean(((String)this.properties.get("debug")).toString())) {
            this.out.println("\n!ERROR:");
            e.printStackTrace();
        } else {
            this.out.println("\n!ERROR: " + e.getMessage());
            if (e.getCause() != null) {
                Throwable t = e.getCause();
                while (t != null) {
                    this.out.println("-> " + t.getMessage());
                    t = t.getCause();
                }
            }
        }
    }

    private void updateDatabaseInfo() {
        this.currentDatabase.getMetadata().getSchema().reload();
        this.currentDatabase.getMetadata().getIndexManager().reload();
    }
}

