/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.console;

import com.orientechnologies.common.console.OConsoleReader;
import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;

public class OGremlinConsole
extends OConsoleDatabaseApp {
    public OGremlinConsole(String[] args) {
        super(args);
    }

    public static void main(String[] args) {
        try {
            boolean tty = false;
            try {
                if (OGremlinConsole.setTerminalToCBreak()) {
                    tty = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            OGremlinConsole console = new OGremlinConsole(args);
            if (tty) {
                console.setReader((OConsoleReader)new TTYConsoleReader());
            }
            console.run();
        }
        finally {
            try {
                OGremlinConsole.stty((String)"echo");
            }
            catch (Exception exception) {}
        }
    }

    protected void onBefore() {
        super.onBefore();
        this.out.println("\nInstalling extensions for GREMLIN language v." + OGremlinHelper.getEngineVersion());
        OGremlinHelper.global().create();
    }

    @ConsoleCommand(splitInWords=false, description="Execute a GREMLIN script")
    public void gremlin(@ConsoleParameter(name="script-text", description="The script text to execute") String iScriptText) {
        this.checkForDatabase();
        if (iScriptText == null || iScriptText.length() == 0) {
            return;
        }
        long start = System.currentTimeMillis();
        this.currentResultSet.clear();
        Object result = this.currentDatabase.command((OCommandRequest)new OCommandGremlin(iScriptText)).execute(new Object[0]);
        this.out.println("\n" + result);
        this.out.printf("\nScript executed in %f sec(s).", Float.valueOf((float)(System.currentTimeMillis() - start) / 1000.0f));
    }
}

