/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.gremlin;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.graph.OGraphDatabasePool;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import java.io.IOException;
import java.util.List;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class LocalGraphDbTest {
    public static void main(String[] args) throws IOException {
        new LocalGraphDbTest().multipleDatabasesSameThread();
    }

    public LocalGraphDbTest() {
        OGremlinHelper.global().create();
    }

    @BeforeClass
    public void before() {
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)false);
    }

    @AfterClass
    public void after() {
        OGlobalConfiguration.STORAGE_KEEP_OPEN.setValue((Object)true);
    }

    @Test
    public void multipleDatabasesSameThread() throws IOException {
        String db1URL = "local:target/databases/tinkerpop";
        String db2URL = "local:target/databases/tinkerpop";
        OGraphDatabase db1 = (OGraphDatabase)OGraphDatabasePool.global().acquire(db1URL, "admin", "admin");
        ODocument doc1 = db1.createVertex();
        doc1.field("key", (Object)"value");
        doc1.save();
        db1.close();
        OGraphDatabase db2 = (OGraphDatabase)OGraphDatabasePool.global().acquire(db2URL, "admin", "admin");
        ODocument doc2 = db2.createVertex();
        doc2.field("key", (Object)"value");
        doc2.save();
        db2.close();
        db1 = (OGraphDatabase)OGraphDatabasePool.global().acquire(db1URL, "admin", "admin");
        List result = db1.query((OQuery)new OSQLSynchQuery("select out[weight=3].size() from V where out.size() > 0"), new Object[0]);
        doc1 = db1.createVertex();
        doc1.field("newkey", (Object)"newvalue");
        doc1.save();
        db1.close();
    }
}

