/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.gremlin;

import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class LocalGremlinTest {
    public LocalGremlinTest() {
        OGremlinHelper.global().create();
    }

    @Test
    public void function() {
        OGraphDatabase db = new OGraphDatabase("local:target/databases/tinkerpop");
        db.open("admin", "admin");
        ODocument vertex1 = db.createVertex().field("label", (Object)"car").save();
        ODocument vertex2 = db.createVertex().field("label", (Object)"pilot").save();
        ODocument edge = db.createEdge(vertex1, vertex2).field("label", (Object)"drives").save();
        List result = db.query((OQuery)new OSQLSynchQuery("select gremlin('current.out.in') as value from V where out.size() > 0 limit 3"), new Object[0]);
        System.out.println("Query result: " + result);
        result = db.query((OQuery)new OSQLSynchQuery("select gremlin('current.out') as value from V"), new Object[0]);
        System.out.println("Query result: " + result);
        int clusterId = db.getVertexBaseClass().getDefaultClusterId();
        result = db.query((OQuery)new OSQLSynchQuery("select gremlin('current.out.in') as value from " + clusterId + ":1"), new Object[0]);
        System.out.println("Query result: " + result);
        result = db.query((OQuery)new OSQLSynchQuery("select gremlin('current.out(\"drives\").count()') as value from V"), new Object[0]);
        System.out.println("Query result: " + result);
        result = db.query((OQuery)new OSQLSynchQuery("select gremlin('current.out') as value from V order by label"), new Object[0]);
        System.out.println("Query result: " + result);
        db.close();
    }

    @Test
    public void command() {
        OGraphDatabase db = new OGraphDatabase("local:target/databases/tinkerpop");
        db.open("admin", "admin");
        List result = (List)db.command((OCommandRequest)new OCommandGremlin("g.V[0..10]")).execute(new Object[0]);
        if (result != null) {
            for (OIdentifiable doc : result) {
                System.out.println(doc.getRecord().toJSON());
            }
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("par1", 100);
        result = (List)db.command((OCommandRequest)new OCommandSQL("select gremlin('current.out.filter{ it.performances > par1 }') from V")).execute(new Object[]{params});
        System.out.println("Command result: " + result);
        db.close();
    }

    @Test
    public void testMultipleExpressions() {
        OGraphDatabase db = new OGraphDatabase("local:target/databases/tinkerpop");
        db.open("admin", "admin");
        List result = (List)db.command((OCommandRequest)new OCommandSQL("SELECT gremlin('m = []; m << 1; m;') FROM #6:1")).execute(new Object[0]);
        Assert.assertEquals((int)1, (int)result.size());
        Assert.assertEquals((Object)1, ((Collection)((ODocument)result.get(0)).field("gremlin")).iterator().next());
        db.close();
    }

    @Test
    public void testMultipleExpressionsSideEffects() {
        OGraphDatabase db = new OGraphDatabase("local:target/databases/tinkerpop");
        db.open("admin", "admin");
        List result = (List)db.command((OCommandRequest)new OCommandSQL("SELECT gremlin('m = []; current.out.sideEffect({ m << it.id }).out.out.sideEffect({ m << it.id })') FROM #6:1")).execute(new Object[0]);
        Assert.assertEquals((int)1, (int)result.size());
        System.out.println("Query result: " + result);
        db.close();
    }
}

