/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.gremlin;

import com.orientechnologies.common.concur.resource.OResourcePool;
import com.orientechnologies.common.concur.resource.OResourcePoolListener;
import com.orientechnologies.orient.core.command.OCommandManager;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.ODatabaseRecord;
import com.orientechnologies.orient.core.db.record.ODatabaseRecordTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlinExecutor;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import com.tinkerpop.gremlin.groovy.jsr223.GremlinGroovyScriptEngineFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;

public class OGremlinHelper {
    private static final String PARAM_OUTPUT = "output";
    private static Object ONE = new Object();
    private static GremlinGroovyScriptEngineFactory factory = new GremlinGroovyScriptEngineFactory();
    private static OGremlinHelper instance = new OGremlinHelper();
    private int maxEngines = 50;
    private int maxGraphs = 50;
    private OResourcePool<Object, ScriptEngine> enginePool;
    private OResourcePool<String, OrientGraph> graphPool;

    public OGremlinHelper() {
        OCommandManager.instance().registerRequester("gremlin", OCommandGremlin.class);
        OCommandManager.instance().registerExecutor(OCommandGremlin.class, OCommandGremlinExecutor.class);
    }

    public void create() {
        if (this.enginePool != null) {
            return;
        }
        this.enginePool = new OResourcePool(this.maxEngines, (OResourcePoolListener)new OResourcePoolListener<Object, ScriptEngine>(){

            public ScriptEngine createNewResource(Object iKey, Object ... iAdditionalArgs) {
                try {
                    return OGremlinHelper.this.getGroovyEngine();
                }
                catch (Throwable e) {
                    throw new OConfigurationException("Error on loading Gremlin engine", e);
                }
            }

            public boolean reuseResource(Object iKey, Object[] iAdditionalArgs, ScriptEngine iReusedEngine) {
                iReusedEngine.getBindings(100).clear();
                return true;
            }
        });
        this.graphPool = new OResourcePool(this.maxGraphs, (OResourcePoolListener)new OResourcePoolListener<String, OrientGraph>(){

            public OrientGraph createNewResource(String iKey, Object ... iAdditionalArgs) {
                String[] parts = iKey.split(",");
                return new OrientGraph(parts[1]);
            }

            public boolean reuseResource(String iKey, Object[] iAdditionalArgs, OrientGraph iReusedGraph) {
                return true;
            }
        });
    }

    public void destroy() {
        if (this.enginePool != null) {
            for (ScriptEngine engine : this.enginePool.getResources()) {
                engine.getBindings(100).clear();
            }
            this.enginePool.close();
        }
        if (this.graphPool != null) {
            for (OrientGraph graph : this.graphPool.getResources()) {
                graph.shutdown();
            }
            this.graphPool.close();
        }
    }

    public ScriptEngine acquireEngine() {
        this.checkStatus();
        return (ScriptEngine)this.enginePool.getResource(ONE, Long.MAX_VALUE, new Object[0]);
    }

    public void releaseEngine(ScriptEngine engine) {
        this.checkStatus();
        engine.getBindings(100).clear();
        this.enginePool.returnResource((Object)engine);
    }

    public OrientGraph acquireGraph(String iURL) {
        return this.acquireGraph("admin", "admin", iURL);
    }

    public OrientGraph acquireGraph(String iURL, String iUserName, String iUserPassword) {
        this.checkStatus();
        OrientGraph g = (OrientGraph)this.graphPool.getResource((Object)(String.valueOf(iUserName) + "," + iURL), Long.MAX_VALUE, new Object[0]);
        if (!g.getRawGraph().getUser().checkPassword(iUserPassword)) {
            this.graphPool.returnResource((Object)g);
            throw new OSecurityException("User and/or password not valid to open database: " + iURL);
        }
        return g;
    }

    public OrientGraph acquireGraph(OGraphDatabase iDatabase) {
        this.checkStatus();
        return ((OrientGraph)this.graphPool.getResource((Object)(String.valueOf(iDatabase.getUser().getName()) + "," + iDatabase.getURL()), Long.MAX_VALUE, new Object[0])).reuse(iDatabase);
    }

    public void releaseGraph(OrientGraph iGraph) {
        this.checkStatus();
        this.graphPool.returnResource((Object)iGraph);
    }

    /*
     * Exception decompiling
     */
    public static Object execute(OGraphDatabase iDatabase, String iText, Map<Object, Object> iConfiguredParameters, Map<Object, Object> iCurrentParameters, List<Object> iResult, OGremlinCallback iBeforeExecution, OGremlinCallback iAfterExecution) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 28[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String bindParameters(ScriptEngine iEngine, Map<Object, Object> iParameters, Map<Object, Object> iCurrentParameters) {
        if (iParameters == null || iParameters.isEmpty()) {
            return null;
        }
        for (Map.Entry<Object, Object> param : iParameters.entrySet()) {
            String key = (String)param.getKey();
            Object objectToClone = param.getValue();
            Object previousItem = iCurrentParameters.get(key);
            Object newItem = OGremlinHelper.cloneObject(objectToClone, previousItem);
            iCurrentParameters.put(key, newItem);
        }
        String output = null;
        for (Map.Entry<Object, Object> param : iCurrentParameters.entrySet()) {
            String paramName = param.getKey().toString().trim();
            if (paramName.equals(PARAM_OUTPUT)) {
                output = param.getValue().toString();
                continue;
            }
            iEngine.getBindings(100).put(paramName, param.getValue());
        }
        return output;
    }

    public static Object cloneObject(Object objectToClone, Object previousClone) {
        if (objectToClone instanceof Map) {
            HashMap recycledMap = (HashMap)previousClone;
            if (recycledMap == null) {
                recycledMap = new HashMap();
            } else {
                recycledMap.clear();
            }
            recycledMap.putAll((Map)objectToClone);
            return recycledMap;
        }
        if (objectToClone instanceof Collection) {
            ArrayList recycledCollection = (ArrayList)previousClone;
            if (recycledCollection == null) {
                recycledCollection = new ArrayList();
            } else {
                recycledCollection.clear();
            }
            recycledCollection.addAll((Collection)objectToClone);
            return recycledCollection;
        }
        if (objectToClone instanceof String) {
            return objectToClone;
        }
        if (objectToClone instanceof Number) {
            return objectToClone;
        }
        if (objectToClone instanceof Date) {
            Date clonedDate = (Date)((Date)objectToClone).clone();
            return clonedDate;
        }
        try {
            Object newClone = null;
            Class<?> obj = objectToClone.getClass();
            while (!obj.equals(Object.class)) {
                Method[] m = obj.getDeclaredMethods();
                int i = 0;
                while (i < m.length) {
                    if (m[i].getName().equals("clone")) {
                        m[i].setAccessible(true);
                        newClone = m[i].invoke(objectToClone, new Object[0]);
                        System.out.println(objectToClone.getClass() + " cloned by Reflection. Performance can be improved by adding the class to the list of known types");
                        return newClone;
                    }
                    ++i;
                }
                obj = obj.getSuperclass();
            }
            throw new Exception("Method clone not found");
        }
        catch (Throwable e1) {
            try {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream(){

                    @Override
                    public synchronized byte[] toByteArray() {
                        return this.buf;
                    }
                };
                ObjectOutputStream out = new ObjectOutputStream(bytes);
                out.writeObject(objectToClone);
                out.close();
                ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray()));
                System.out.println(objectToClone.getClass() + " cloned by Serialization. Performance can be improved by adding the class to the list of known types");
                return in.readObject();
            }
            catch (Throwable e2) {
                e2.printStackTrace();
                return null;
            }
        }
    }

    public static OGremlinHelper global() {
        return instance;
    }

    public int getMaxEngines() {
        return this.maxEngines;
    }

    public void setMaxEngines(int maxEngines) {
        this.maxEngines = maxEngines;
    }

    public int getMaxGraphs() {
        return this.maxGraphs;
    }

    public void setMaxGraphs(int maxGraphs) {
        this.maxGraphs = maxGraphs;
    }

    private void checkStatus() {
        if (this.enginePool == null || this.graphPool == null) {
            throw new IllegalStateException("OGremlinHelper instance has been not created. Call OGremlinHelper.global().create() to iniziailze it");
        }
    }

    public static OGraphDatabase getGraphDatabase(ODatabaseRecord iCurrentDatabase) {
        OGraphDatabase db;
        ODatabaseRecord currentDb = ODatabaseRecordThreadLocal.INSTANCE.get();
        if (currentDb == null && iCurrentDatabase != null) {
            currentDb = iCurrentDatabase;
        }
        if ((currentDb = (ODatabaseRecord)currentDb.getDatabaseOwner()) instanceof OGraphDatabase) {
            db = (OGraphDatabase)currentDb;
        } else if (currentDb instanceof ODatabaseDocumentTx) {
            db = new OGraphDatabase((ODatabaseRecordTx)currentDb.getUnderlying());
            ODatabaseRecordThreadLocal.INSTANCE.set((Object)db);
        } else if (currentDb instanceof ODatabaseRecordTx) {
            db = new OGraphDatabase((ODatabaseRecordTx)currentDb);
            ODatabaseRecordThreadLocal.INSTANCE.set((Object)db);
        } else {
            throw new OCommandExecutionException("Cannot find a database of type OGraphDatabase or ODatabaseRecordTx");
        }
        return db;
    }

    public static String getEngineVersion() {
        return factory.getEngineVersion();
    }

    protected ScriptEngine getGroovyEngine() {
        return factory.getScriptEngine();
    }

    public static interface OGremlinCallback {
        public boolean call(ScriptEngine var1, OrientGraph var2);
    }
}

