/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.gremlin;

import com.orientechnologies.orient.core.command.OCommandExecutor;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.functions.OSQLFunctionAbstract;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientEdge;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientGraph;
import com.tinkerpop.blueprints.pgm.impls.orientdb.OrientVertex;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptEngine;

public class OSQLFunctionGremlin
extends OSQLFunctionAbstract {
    public static final String NAME = "gremlin";
    private List<Object> result;
    private Map<Object, Object> currentParameters;

    public OSQLFunctionGremlin() {
        super(NAME, 1, 1);
    }

    public Object execute(final OIdentifiable iCurrentRecord, Object[] iParameters, OCommandExecutor iRequester) {
        if (!(iCurrentRecord instanceof ODocument)) {
            return null;
        }
        final OGraphDatabase db = OGremlinHelper.getGraphDatabase(ODatabaseRecordThreadLocal.INSTANCE.get());
        if (this.result == null) {
            this.result = new ArrayList<Object>();
        }
        if (iRequester != null && iRequester.getParameters() != null) {
            this.currentParameters = new HashMap<Object, Object>();
        }
        Object scriptResult = OGremlinHelper.execute(db, (String)iParameters[0], iRequester != null ? iRequester.getParameters() : null, this.currentParameters, this.result, new OGremlinHelper.OGremlinCallback(){

            @Override
            public boolean call(ScriptEngine iEngine, OrientGraph iGraph) {
                OrientVertex graphElement;
                ODocument document = (ODocument)iCurrentRecord;
                if (db.isVertex(document)) {
                    graphElement = new OrientVertex(iGraph, document);
                } else if (db.isEdge(document)) {
                    graphElement = new OrientEdge(iGraph, document);
                } else {
                    return false;
                }
                iEngine.getBindings(100).put("current", (Object)graphElement);
                return true;
            }
        }, null);
        return scriptResult;
    }

    public boolean aggregateResults(Object[] iConfiguredParameters) {
        return false;
    }

    public String getSyntax() {
        return "Syntax error: gremlin(<gremlin-expression>)";
    }

    public boolean filterResult() {
        return true;
    }

    public Object getResult() {
        return this.result;
    }
}

