/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.gremlin;

import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.graph.OGraphDatabase;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.query.OQuery;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.OCommandSQL;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerMain;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.testng.annotations.AfterClass;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RemoteGremlinTest {
    private final OServer server;
    private OGraphDatabase graphDatabase;

    public RemoteGremlinTest() throws Exception {
        if (System.getProperty("ORIENTDB_HOME") == null) {
            System.setProperty("ORIENTDB_HOME", "target");
        }
        OGremlinHelper.global().create();
        this.server = OServerMain.create();
    }

    @BeforeClass
    public void setUp() throws Exception {
        this.server.startup(new File(this.getClass().getResource("db-config.xml").getFile()));
        this.server.activate();
    }

    @AfterClass
    public void tearDown() throws Exception {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    @BeforeMethod
    public void beforeMethod() {
        for (OStorage stg : Orient.instance().getStorages()) {
            System.out.println("Closing storage: " + stg);
            stg.close(true);
        }
        this.graphDatabase = new OGraphDatabase("remote:localhost/tinkerpop");
        this.graphDatabase.open("admin", "admin");
    }

    @AfterMethod
    public void afterMethod() {
        this.graphDatabase.close();
    }

    @Test
    public void function() throws IOException {
        ODocument vertex1 = this.graphDatabase.createVertex().field("label", (Object)"car").save();
        ODocument vertex2 = this.graphDatabase.createVertex().field("label", (Object)"pilot").save();
        ODocument edge = this.graphDatabase.createEdge(vertex1, vertex2).field("label", (Object)"drives").save();
        List result = this.graphDatabase.query((OQuery)new OSQLSynchQuery("select gremlin('current.out.in') as value from V where out.size() > 0 limit 3"), new Object[0]);
        System.out.println("Query result: " + result);
        result = this.graphDatabase.query((OQuery)new OSQLSynchQuery("select gremlin('current.out') as value from V"), new Object[0]);
        System.out.println("Query result: " + result);
        int clusterId = this.graphDatabase.getVertexBaseClass().getDefaultClusterId();
        result = this.graphDatabase.query((OQuery)new OSQLSynchQuery("select gremlin('current.out.in') as value from " + clusterId + ":1"), new Object[0]);
        System.out.println("Query result: " + result);
        result = this.graphDatabase.query((OQuery)new OSQLSynchQuery("select gremlin('current.out(\"drives\").count()') as value from V"), new Object[0]);
        System.out.println("Query result: " + result);
    }

    @Test
    public void command() throws IOException {
        List result = (List)this.graphDatabase.command((OCommandRequest)new OCommandGremlin("g.V[0..10]")).execute(new Object[0]);
        if (result != null) {
            for (OIdentifiable doc : result) {
                System.out.println(doc.getRecord().toJSON());
            }
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("par1", 100);
        result = (List)this.graphDatabase.command((OCommandRequest)new OCommandSQL("select gremlin('current.out.filter{ it.performances > par1 }') from V")).execute(new Object[]{params});
        System.out.println("Command result: " + result);
    }
}

